#include <stdio.h>
#include "sym.h"
#include "assem.h"
#include "scanner.h"

char *dtmp "/tmp/as4XXXX";
char *ftmp "/tmp/as5XXXX";
char *gtmp "/tmp/as6XXXX";
char *htmp "/tmp/as7XXXX";
char *itmp "/tmp/as8XXXX";
char *jtmp "/tmp/as9XXXX";
char *ktmp "/tmp/as10XXXX";
FILE *instfil, *listfil;
FILE *datafil, *textfil, *bssfil, *dataobj, *textobj, *bssobj, *litobj;

/*
 * This routine produces an assembler listing together with C source
 * code, C line number, assembler code, assembler line number, relative
 * offset, object code, and effective addresses. The text, data, and bss
 * segments are separated into three logical sections (in that order).
 *
 * The positions of each field are:
 *
 *     FIELD                              COL
 *
 *     relocatable location                1
 *     object code                         9
 *     effective address #1                27
 *     effective address #2                33
 *     assembler line #                    41
 *     assembler code                      49
 *     C line #                            81
 *     C code                              89
 *
 */
list()
{
	char srcln[MAXLINE];
	int dot, type, line, length, n, count, *p, *l, *s;
	int dccnt, i;
	char *c;

	p = &type;
	l = &line;
	s = &dccnt;

	/*
	 * read text line - get type
	 */
	fprintf(listfil, "\t\t\t\t\t\t.text\n");
	while (gettext(srcln, p, l, s) > 0) {
		if (type > 0) {
			/*
			 * instruction - get next translated instruction
			 */
			getinstr();
		        fprintf(listfil, "%4d\t%-s", line, srcln);
		}
		else if (type == -2) {
			/*
			 * 'dc' or 'ds' in text segment - get offset and value
			 */
		        fprintf(listfil, "\t\t\t\t\t%4d\t%s", line, srcln);
			for (i = 0; i < dccnt; i++) {
				dot = getw(textobj);
				length = getw(textobj);
				if (length != 0) {
				        fprintf(listfil, "%06x\t", dot);
				        n = length;
				        count = 0;
				        while (n--) {
					        if (count == 16) {
						        fprintf(listfil, "\n\t");
						        count = 0;
						}
				                fprintf(listfil, "%02x", getc(textobj));
						count++;
					}
				        fprintf(listfil, "\n");
				}
			}
		}
		else if (type == -3) {
			/*
			 * ltorg - get offsets and values of literals.
			 * a negative value for dot marks the
			 * end of the literal list.
			 */
	                fprintf(listfil, "\t\t\t\t\t%4d\t%-s", line, srcln);
			dot = getw(textobj);
			while (dot > 0) {
			        fprintf(listfil, "%06x\t", dot);
			        length = getw(textobj);
			        while (length--)
			                fprintf(listfil, "%02x", getc(textobj));
			        fprintf(listfil, "\n");
			        dot = getw(textobj);
		        }
		}
		else if (type == -5)
			/*
			 * SVC or SYS
			 */
			fprintf(listfil, "%06x\t%02x%02x\t\t\t\t%4d\t%-s", getw(textobj), getw(textobj), getw(textobj), line, srcln);
		else if (type == -6)
			/*
			 * SPM
			 */
			fprintf(listfil, "%06x\t%02x%02x\t\t\t\t%4d\t%-s", getw(textobj), getw(textobj), getw(textobj), line, srcln);
		else if (type == -7) {
			/*
			 * CNOP
			 */
	                fprintf(listfil, "\t\t\t\t\t%4d\t%-s", line, srcln);
			dot = getw(textobj);
			while (dot > 0) {
			        fprintf(listfil, "%06x\t", dot);
			        fprintf(listfil, "%02x", getw(textobj));
			        fprintf(listfil, "%02x\n", getw(textobj));
			        dot = getw(textobj);
		        }
		}
		else if (type == -8) {
			/*
			 * CCW
			 */
			fprintf(listfil, "%06x\t%02x%02x%02x%02x%02x%02x%02x%02x", getw(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj));
	                fprintf(listfil, "\t\t%4d\t%-s", line, srcln);
		}
	        else {
			if ((*srcln == '/') && (*(srcln+1) == '/') && (*(srcln+2) == '/'))
				/*
				 * C source line generated by the compiler as a comment
				 */
			        fprintf(listfil, "\t\t\t\t\t%5s\t%-s", " ", srcln+3);
			else
				/*
				 * assembler code
				 */
			        fprintf(listfil, "\t\t\t\t\t%4d\t%-s", line, srcln);
		}
	}

	/*
	 * read data line - get type
	 */
	fprintf(listfil, "\t\t\t\t\t\t.data\n");
	while (getdata(srcln, p, l, s) > 0) {
		if (type == -2) {
			/*
			 * 'dc' or 'ds' in data segment - get offset and value
			 */
		        fprintf(listfil, "\t\t\t\t\t%4d\t%s", line, srcln);
			for (i = 0; i < dccnt; i++) {
				dot = getw(dataobj);
				length = getw(dataobj);
				if (length != 0) {
				        fprintf(listfil, "%06x\t", dot);
				        n = length;
				        count = 0;
				        while (n--) {
					        if (count == 16) {
						        fprintf(listfil, "\n\t");
						        count = 0;
						}
				                fprintf(listfil, "%02x", getc(dataobj));
						count++;
					}
				        fprintf(listfil, "\n");
				}
			}
		}
		else if (type == -7) {
			/*
			 * CNOP
			 */
	                fprintf(listfil, "\t\t\t\t\t%4d\t%-s", line, srcln);
			dot = getw(dataobj);
			while (dot > 0) {
			        fprintf(listfil, "%06x\t", dot);
			        fprintf(listfil, "%02x", getw(dataobj));
			        fprintf(listfil, "%02x\n", getw(dataobj));
			        dot = getw(dataobj);
		        }
		}
		else if (type == -8) {
			/*
			 * CCW
			 */
			fprintf(listfil, "%06x\t%02x%02x%02x%02x%02x%02x%02x%02x", getw(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj), getc(dataobj));
	                fprintf(listfil, "\t\t%4d\t%-s", line, srcln);
		}
		else {
			if ((*srcln == '/') && (*(srcln+1) == '/') && (*(srcln+2) == '/'))
				/*
				 * C source line generated by the compiler as a comment
				 */
			        fprintf(listfil, "\t\t\t\t\t%5s\t%-s", " ", srcln+3);
			else
				/*
				 * assembler code
				 */
			        fprintf(listfil, "\t\t\t\t\t%4d\t%-s", line, srcln);
		}
	}

	/*
	 * read bss line - get type
	 */
	fprintf(listfil, "\t\t\t\t\t\t.bss\n");
	while (getbss(srcln, p, l, s) > 0) {
		if (type == -2) {
			/*
			 * 'dc' in bss segment - get offset and value
			 */
			for (i = 0; i < dccnt; i++) {
				dot = getw(bssobj);
				length = getw(bssobj);
				if (length != 0) {
				        fprintf(listfil, "%06x\t", dot);
				        n = length;
				        while (length--)
				                fprintf(listfil, "%02x", getc(bssobj));
				        fprintf(listfil, "\t\t\t");
				}
				else
				        fprintf(listfil, "\t\t\t\t\t");
			}
		}
		else
			fprintf(listfil, "\t\t\t\t\t");
		if ((*srcln == '/') && (*(srcln+1) == '/') && (*(srcln+2) == '/'))
			/*
			 * C source line generated by the compiler as a comment
			 */
		        fprintf(listfil, "%5s\t%-s", " ", srcln+3);
		else
			/*
			 * assembler code
			 */
		        fprintf(listfil, "%4d\t%-s", line, srcln);
	}
}

/*
 * read an assembler source line from the text segment file and determine
 * the type (i.e. instruction, 'dc' or 'ds' line, ltorg, etc.)
 * and line number.
 */
gettext(s, type, line, dccnt)
char s[];
int *type, *line, *dccnt;
{
	int c, i, lim;

	i = 0;
	lim = MAXLINE;
	while (--lim > 0 && (c=getc(textfil)) != EOF && c != '\n')
		s[i++] = c;
	if (c == '\n')
		s[i++] = c;
	else
		s[i++] = '\n';
	s[i] = '\0';
	*type = getw(textfil);
	*line = getw(textfil);
	if (*type == -2 /* dc or ds statement */)
	        *dccnt = getw(textfil);
	return(c==EOF ? 0 : 1);
}

/*
 * read an assembler line from the data segment file and determine
 * the type (i.e. 'dc' or 'ds' line, etc.) and line number.
 */
getdata(s, type, line, dccnt)
char s[];
int *type, *line, *dccnt;
{
	int c, i, lim;

	i = 0;
	lim = MAXLINE;
	while (--lim > 0 && (c=getc(datafil)) != EOF && c != '\n')
		s[i++] = c;
	if (c == '\n')
		s[i++] = c;
	else
		s[i++] = '\n';
	s[i] = '\0';
	*type = getw(datafil);
	*line = getw(datafil);
	if (*type == -2 /* dc or ds statement */)
	        *dccnt = getw(datafil);
	return(c==EOF ? 0 : 1);
}

/*
 * read an assembler line from the bss segment file and determine
 * the type (i.e. 'dc' or 'ds' line, etc.) and line number.
 */
getbss(s, type, line, dccnt)
char s[];
int *type, *line, *dccnt;
{
	int c, i, lim;

	i = 0;
	lim = MAXLINE;
	while (--lim > 0 && (c=getc(bssfil)) != EOF && c != '\n')
		s[i++] = c;
	if (c == '\n')
		s[i++] = c;
	else
		s[i++] = '\n';
	s[i] = '\0';
	*type = getw(bssfil);
	*line = getw(bssfil);
	if (*type == -2 /* dc or ds statement */)
	        *dccnt = getw(bssfil);
	return(c==EOF ? 0 : 1);
}

/*
 * get the hex representation of an instruction
 */
getinstr()
{
	int length, addr1, addr2;

	length = getc(instfil);    /* length of instruction */
	fprintf(listfil, "%06x\t%02x%02x", getw(instfil), getc(instfil), getc(instfil));
	if (length == BPH) {
		fprintf(listfil, "\t\t\t\t");
		return;
	}
	else {
		fprintf(listfil, "  %02x%02x", getc(instfil), getc(instfil));
		addr1 = getw(instfil);  /* effective address #1 */
	}
	if (length == BPW) {
		fprintf(listfil, "\t");
		if (addr1 == -2)        /* no effective address #1 */
		        fprintf(listfil, "\t\t");
		else
		        fprintf(listfil, "  %6x\t", addr1);
	}
	else {
		fprintf(listfil, "  %02x%02x", getc(instfil), getc(instfil));
		addr2 = getw(instfil);  /* effective address #2 */
		if (addr1 == -2)        /* no effective address #1 */
		        fprintf(listfil, "\t");
		else
		        fprintf(listfil, "  %6x", addr1);
		if (addr2 == -2)        /* no effective address #2 */
		        fprintf(listfil, "\t");
		else
		        fprintf(listfil, " %6x ", addr2);
	}
}

/*
 * open the files which will contain the hex values of the assembler
 * instructions, and the text, data, and bss object values.
 */
opfil1()
{
	if ((instfil = fopen(dtmp, "w")) == NULL) error(1, "Can't create instfil temp");
	if ((dataobj = fopen(htmp, "w")) == NULL) error(1, "Can't create dataobj temp");
	if ((textobj = fopen(itmp, "w")) == NULL) error(1, "Can't create textobj temp");
	if ((bssobj = fopen(ktmp, "w")) == NULL) error(1, "Can't create bssobj temp");
}

/*
 * print the assembler listing
 */
prtfiles()
{
	extern char *etmp;

	fclose(instfil);
	fclose(dataobj);
	fclose(textobj);
	fclose(bssobj);
	if ((instfil = fopen(dtmp, "r")) == NULL) error(1, "Can't open instfil");
	if ((datafil = fopen(ftmp, "r")) == NULL) error(1, "Can't open datafil");
	if ((textfil = fopen(gtmp, "r")) == NULL) error(1, "Can't open textfil");
	if ((bssfil = fopen(jtmp, "r")) == NULL) error(1, "Can't open bssfil");
	if ((dataobj = fopen(htmp, "r")) == NULL) error(1, "Can't open dataobj");
	if ((textobj = fopen(itmp, "r")) == NULL) error(1, "Can't open textobj");
	if ((bssobj = fopen(ktmp, "r")) == NULL) error(1, "Can't open bssobj");
	if ((listfil = fopen(etmp, "w")) == NULL) error(1, "Can't create list file");
	list();
	fclose(listfil);
}

/*
 * open the files which will contain the text, data, and bss
 * source lines
 */
opfil2()
{
	dtmp = mktemp(dtmp);
	ftmp = mktemp(ftmp);
	gtmp = mktemp(gtmp);
	htmp = mktemp(htmp);
	itmp = mktemp(itmp);
	jtmp = mktemp(jtmp);
	ktmp = mktemp(ktmp);
	if ((datafil = fopen(ftmp, "w")) == NULL) error(1, "Can't create temp");
	if ((textfil = fopen(gtmp, "w")) == NULL) error(1, "Can't create temp");
	if ((bssfil = fopen(jtmp, "w")) == NULL) error(1, "Can't create temp");
}

closefil()
{
	fclose(datafil);
	fclose(textfil);
	fclose(bssfil);
}

/*
 * for debugging purposes only
 */
dbgprt()
{
	register int c;

	textfil = fopen(gtmp, "r");
	/*
	 * print the input file
	 */
	fprintf(stderr, "\t\tINPUT\n");
	while((c=getc(textfil)) != EOF) {
		if (c == '\n')
			fprintf(stderr, "  # %d", getw(textfil));
		fprintf(stderr, "%c", c);
	}
	fclose(textfil);
	datafil = fopen(ftmp, "r");
	fprintf(stderr, "\t.data\n");
	while((c=getc(datafil)) != EOF) {
		if (c == '\n')
			fprintf(stderr, "  # %d", getw(datafil));
		fprintf(stderr, "%c", c);
	}
	fclose(datafil);
	bssfil = fopen(jtmp, "r");
	fprintf(stderr, "\t.bss\n");
	while((c=getc(bssfil)) != EOF) {
		if (c == '\n')
			fprintf(stderr, "  # %d", getw(bssfil));
		fprintf(stderr, "%c", c);
	}
	fclose(bssfil);
}

ridtmp()
{
	unlink(dtmp);
	unlink(ftmp);
	unlink(gtmp);
	unlink(htmp);
	unlink(itmp);
	unlink(jtmp);
	unlink(ktmp);
}

/*
 * determine the line type (i.e. instruction, 'dc' or 'ds' line,
 * ltorg, etc.) of an assembler source line
 */
setype(s)
char *s;
{
	if (strcmp(s, "~") == 0)
               lntype = 0;
	else if (strcmp(s, "dc")==0 || strcmp(s, "ds")==0)
		lntype = -2;
	else if (strcmp(s, "ltorg")==0 || strcmp(s, "end")==0)
		lntype = -3;
	else if ((strcmp(s, "svc")==0) || (strcmp(s, "sys")==0))
		lntype = -5;
	else if (strcmp(s, "spm")==0)
		lntype = -6;
	else if (strcmp(s, "cnop")==0)
		lntype = -7;
	else if (strcmp(s, "ccw")==0)
		lntype = -8;
	else
	        return;
	ready = 0;
}

/*
 * prints line type or line number on the appropriate source text
 * segment
 */
prtwrd(value)
int value;
{
	if (prtype == DATASEG) 
	        putw(value, datafil);
	else if (prtype == TEXTSEG) 
	        putw(value, textfil);
	else if (prtype == BSSSEG) 
	        putw(value, bssfil);
	else
		error(1, "wrong segment for printing text word");
}
 
/*
 * print a character and change segment files if necessary
 */
outchar(c)
int c;
{
	register int cc;
	register int peekc, temp;

	if (c == '/' && ready)
		/*
		 * switch segment files if the line after the comment is
		 * a '.data', '.text'. or '.bss'
		 */
		seekdot();
	else if (c == '.' && ready) {
		/*
		 * switch segment files
		 */
		printc = 0;
		if ((peekc=getc(infil))== 'd')
			prtype = DATASEG;
		else if (peekc == 't')
			prtype = TEXTSEG;
		else if (peekc == 'b')
			prtype = BSSSEG;
		else if (peekc=='c') {
			/*
			 * .comm or CSECT
			 */
			if ((temp=getc(infil))=='s')
			        /*
			         * CSECT
			         */
			        prtype = TEXTSEG;
		        ungetc(temp, infil);
		        prtchar(c);
		        prtchar(peekc);
		        printc = 1;
		}
		else {
			/*
			 * actually is a '. = expr'
			 */
			printc = 1;
		        prtchar('.');
		        prtchar(peekc);
		}
		ungetc(peekc, infil);
		peekchar = 1;
		return(c);
	}
	if (printc == 0)
		return(c);
	else {
		if (c==';' && comment==0)
			/*
			 * change semi-colon to newline if not within a comment
			 */
			cc = '\n';
		else
			cc = c;
	        prtchar(cc);
	}
        return(c);
}

/*
 * print a character on the appropriate segment source file
 */
prtchar(c)
int c;
{
	if (c == EOF)
		return;
	if (peekchar) {
		peekchar = 0;
		return;
	}
	if (prtype == DATASEG)
	        putc(c, datafil);
	else if (prtype == TEXTSEG)
	        putc(c, textfil);
	else if (prtype == BSSSEG)
	        putc(c, bssfil);
	else
		error(1, "wrong segment for printing text character");
}

/*
 * print a word of object code on the appropriate object segment file
 */
objwrd(n)
int n;
{

	if (dotrel == DATASEG)
	        putw(n, dataobj);
	else if (dotrel == TEXTSEG)
	        putw(n, textobj);
	else if (dotrel == BSSSEG)
	        putw(n, bssobj);
	else
		/*
		 * CSECT in text segment
		 */
	        putw(n, textobj);
}

/*
 * print a character of object code on the appropriate object segment file
 */
objchar(n)
int n;
{

	if (dotrel == DATASEG)
	        putc(n, dataobj);
	else if (dotrel == TEXTSEG)
	        putc(n, textobj);
	else if (dotrel == BSSSEG)
	        putc(n, bssobj);
	else
		/*
		 * CSECT in text segment
		 */
	        putc(n, textobj);
}

/*
 * print the appropriate number of zeros for a 'ds' statement only
 * if the statement is not being used to force alignment
 */
outds(dot, opv)
int dot, opv;
{
	register int n;

	if (opv == 0) {    /* forcing alignment */
	        objwrd(dot);
	        objwrd(0);
	}
	else {
		objwrd(dot);
		objwrd(opv);
	        for (n = 0; n < opv; n++)
	                objchar('\0');
	}
}

/*
 * check for a .data, .text, or .bss after the comment and adjust
 * prtype so that the comment will be read out to the correct output
 * file.
 */
seekdot()
{
	register int byte, c, peekc;

	byte = ftell(infil);

  scan: while ((c = getc(infil))!='\n' && c!=-1 /*EOF*/)
		/*
		 * scan to the end of the comment
		 */
		;
	c = getc(infil);
	if (c == '/')
		/*
		 * another comment
		 */
		goto scan;
	else if (c == '.') {
		c = getc(infil);
		switch(c) {
			case 'd':
				prtype = DATASEG;
				break;
			case 't':
				prtype = TEXTSEG;
				break;
			case 'b':
				prtype = BSSSEG;
				break;
			case 'c':
				/*
				 * CSECT
				 */
				if ((c=getc(infil)) == 's')
				        prtype = TEXTSEG;
				break;
		}
	}
	/*
	 * restore file position
	 */
	fseek(infil, byte, 0);
}
