#include "stdio.h"
#include "sym.h"
#include "assem.h"

/*
 * literal handler
 *      uses a linked list for each "type" of literal
 *      there are 7 types of literals:
 *              double word constants
 *              full word address constants
 *              full word constants
 *              half word address constants
 *              half word constants
 *              other length address constants
 *              other length constants
 *
 *      Address constants are handled specially because during pass 1
 *      they are stored in the literal pool as 2 words, symbol table
 *      pointer and offset, pass 2 understands this and fudges accordingly.
 *
 *      lit dumps addresses, ltorg dumps arranged pool to temp file
 *      dumplits dumps temp file to output file
 */

int litlen[]  = { 8,8,4,8,2,8,1 };
int litrel;
struct lit {
	struct lit *next;
	union {
		char data1[1];  /* for fixed length lits */
		int length;     /* for variable length lits */
	} l;
	char data2[1];          /* for variable length */
};

struct lit *head[LITTYPES];
int litcount[LITTYPES];
char pool[POOLSIZE], *poolp;

lit(e)
register EXPR *e;{

	register int i;
	register struct lit *p, *lastp;
	char cval[LINESIZE];
	int index, count, length;

	if (scan == scan1) dc1(e, cval);
	else dc2(e, cval);
	count = e->e_val;
	length = e->e_len;

	switch(length) {
		case BPD:
			index = LITD;
			break;
		case BPW:
			index = LITF;
			break;
		case BPH:
			index = LITH;
			break;
		default:
			index = LITO;
			break;
		}
	if (e->e_symp != NULL){
		if (length > BPW)
			error(0,"Address too long");
		length = 8;
		--index;
		}
	i = 0;
	lastp = NULL;
	p = head[index];
	if (p == NULL)
		head[index] = (struct lit *)poolp;
	else {
		while (p != NULL){
			if (count==1 && equal(index, cval, p->l.data1, length)){
				e->e_val = i;
				putw(index, litfil);
				putw(e->e_val, litfil);
				return(index);
				}
			if (index == LITOA || index == LITO)
				i += p->l.length;
			else if (index & 01) i += litlen[index+1];
			else i += length;
			lastp = p;
			p = p->next;
			}
		}
	i = count;
	while (i--){
		p = (struct lit *)poolp;
		if (lastp != NULL) lastp->next = p;
		p->next = NULL;
		lastp = p;
		poolp += BPW;
		if (index == LITOA || index == LITO){
			p->l.length = length;
			poolp += BPW;
			}
		if (poolp+length > pool+POOLSIZE)
			error(1,"fatal error:  out of literal space");
		move(cval, poolp, length);
		poolp += length;
		}
	e->e_val = litcount[index];
	litcount[index] += count*e->e_len;
	putw(index, litfil);
	putw(e->e_val, litfil);
	return(index);
	}

equal(i, n1, n2, len)
register int i, len;
register char *n1,*n2;{

	if (i==LITOA || i==LITO) len += BPW;
	while (len--)
		if (*n1++ != *n2++) return(0);
	return(-1);
	}

ltorg(){
	register struct lit *p;
	register char *cp, *q;
	register int n, x;
	int r, length;

	fflush(litfil);
	r = ftell(litfil);
	fseek(litfil, litstart, 0);
	for (n = 0; n < LITTYPES; n++){
		x = align(dot, litlen[(n+1) & ~1]);
		if (litcount[n] > 0)
			dot = x;
		putw(x, litfil);
		dot += litcount[n];
		}
	putw(dot, litfil);
	putw(dotrel, litfil);
	fflush(litfil);
	fseek(litfil, r, 0);
	for (n = 0; n < LITOA; n++){
		p = head[n];
		while (p != NULL){
			cp = p->l.data1;
			q = cp+litlen[n];
			while (cp < q) putc(*cp++, litfil);
			p = p->next;
			}
		}
	for (n = LITOA; n <= LITO; n++){
		p = head[n];
		while (p != NULL){
			length = p->l.length;
			cp = p->data2;
			q = cp+length;
			putw(length, litfil);
			while (cp < q) putc(*cp++, litfil);
			p = p->next;
			}
		}
	fflush(litfil);
	litstart = ftell(litfil);
	for (n = 0; n < LITTYPES; n++){
		putw(0, litfil);
		litcount[n] = 0;
		head[n] = NULL;
		}
	putw(0, litfil);
	putw(0, litfil);
	poolp = pool;
	}

dumplits(){
	register int i, j, k;
	int len, *last, *next;
	int c, bingo;

	bingo = 0;
	if (litcount[0] == EOF) return;
	for (i = 1; i < LITOA; i++)
		if (litcount[i]-litcount[i-1] > 0){
			dot = align(dot, litlen[i & ~1]);
			break;
			}
	next = &litcount[LITD];
	last = next++;
	for (i = 0; i < LITTYPES; i++){
		len = litlen[(i+1) & ~1];
		if (next >= (litcount+LITTYPES))
			next = &litstart;
		bingo = 1;
		for (j = *last; j < *next; j += len){
			if (i >= LITOA) len = getw(litfil);
			if (len <= 0) error(1,"Literal botch");
			if (listflg) {
				/*
				 * all literals are stored in text segment
				 */
				putw(dot, textobj);
				putw(len, textobj);
			}
			if (i & 1) putadcon(len);
			else for (k = 0; k < len; k++) {
				        c = getc(litfil);
				        if (listflg)
					        putc(c, textobj);
				        putob(c);
			     }
			dot += len;
			}
		last = next++;
		}
	if (listflg && bingo)
		/*
		 * mark end of literal list
		 */
		putw(-1, textobj);
	for (i = 0; i < LITTYPES; i++)
		litcount[i] = getw(litfil);
	dot = litstart;
	litstart = getw(litfil);
	litrel = getw(litfil);
	}

putadcon(len)
register int len;{

	register int a, b;
	int atype, aval;
	EXPR e;
	register SYM *symp;

	a = getw(litfil);
	b = getw(litfil);
	symp = (SYM *)b;
/*
	if (symp < usym && symp != NULL){
		error(-1, "Forbidden literal");
		return;
		}
 */
	atype = symp->s_type & LOCAL;
	aval = symp->s_val;
	if (atype >= TEXTSEG && atype < DABS)
		aval += oseek[atype-TEXTSEG]-oseek[0];
	a += aval;
	if (listflg) {
		/*
		 * =a(blah) address constant (i.e. address
		 * constant in text segment)
		 */
		putc(a >> 24, textobj);
		putc(a >> 16, textobj);
		putc(a >> 8, textobj);
		putc(a & 0377, textobj);
	}
	putob(a >> 24);
	putob(a >> 16);
	putob(a >> 8);
	putob(a & 0377);
	e.e_type = symp->s_type;
	e.e_val = -1;
	e.e_len = -1;
	e.e_symp = symp;
	genreloc(dot, len, &e);
	}
