/*
 * opcodes and their friends
 * this file must be included elsewhere because it's static
 * the data takes about 5K, beware extending the file where
 * this gets included
 */

static SYM opcode[] = {
	{ ".csym", OPCODE, 0, -1, CSYM },
	{ ".clineno", OPCODE, 0, -1, CLINENO },
	{ ".cblock", OPCODE, 0, -1, CBLOCK },
	{ ".cfunc", OPCODE, 0, -1, CFUNC },
	{ ".cfile", OPCODE, 0, -1, CFILE },
	{ ".bss", OPCODE, 0, -1, BSS },
	{ ".comm", OPCODE, 0, -1, COMM },
	{ ".csect", OPCODE, 0, -1, CSECT },
	{ ".data", OPCODE, 0, -1, DATA },
	{ ".dsect", OPCODE, 0, -1, DSECT },
	{ ".text", OPCODE, 0, -1, TEXT },
	{ "a", OPCODE, RX, -1, ADD },
	{ "ad", OPCODE, RX, -1, AD },
	{ "adr", OPCODE, RR, -1, ADR },
	{ "ae", OPCODE, RX, -1, AE },
	{ "aer", OPCODE, RR, -1, AER },
	{ "ah", OPCODE, RX, -1, ADDH },
	{ "al", OPCODE, RX, -1, AL },
	{ "alr", OPCODE, RR, -1, ALR },
	{ "ap", OPCODE, SS1, -1, AP },
	{ "ar", OPCODE, RR, -1, AR },
	{ "au", OPCODE, RX, -1, AU },
	{ "aur", OPCODE, RR, -1, AUR },
	{ "aw", OPCODE, RX, -1, AW },
	{ "awr", OPCODE, RR, -1, AWR },
	{ "axr", OPCODE, RR, -1, AXR },
	{ "b", OPCODE, BRANCH, -1, 15 },
	{ "bal", OPCODE, RX, -1, BAL },
	{ "balr", OPCODE, RR, -1, BALR },
	{ "bc", OPCODE, RX, -1, BC },
	{ "bcr", OPCODE, RR, -1, BCR },
	{ "bct", OPCODE, RX, -1, BCT },
	{ "bctr", OPCODE, RR, -1, BCTR },
	{ "be", OPCODE, BRANCH, -1, 8 },
	{ "ber", OPCODE, BRANCHR, -1, 8 },
	{ "bh", OPCODE, BRANCH, -1, 2 },
	{ "bhr", OPCODE, BRANCHR, -1, 2 },
	{ "bl", OPCODE, BRANCH, -1, 4 },
	{ "blr", OPCODE, BRANCHR, -1, 4 },
	{ "bm", OPCODE, BRANCH, -1, 4 },
	{ "bmr", OPCODE, BRANCHR, -1, 4 },
	{ "bne", OPCODE, BRANCH, -1, 7 },
	{ "bner", OPCODE, BRANCHR, -1, 7 },
	{ "bnh", OPCODE, BRANCH, -1, 13 },
	{ "bnhr", OPCODE, BRANCHR, -1, 13 },
	{ "bnl", OPCODE, BRANCH, -1, 11 },
	{ "bnlr", OPCODE, BRANCHR, -1, 11 },
	{ "bnm", OPCODE, BRANCH, -1, 11 },
	{ "bnmr", OPCODE, BRANCHR, -1, 11 },
	{ "bno", OPCODE, BRANCH, -1, 14 },
	{ "bnor", OPCODE, BRANCHR, -1, 14 },
	{ "bnp", OPCODE, BRANCH, -1, 13 },
	{ "bnpr", OPCODE, BRANCHR, -1, 13 },
	{ "bnz", OPCODE, BRANCH, -1, 7 },
	{ "bnzr", OPCODE, BRANCHR, -1, 7 },
	{ "bo", OPCODE, BRANCH, -1, 1 },
	{ "bor", OPCODE, BRANCHR, -1, 1 },
	{ "bp", OPCODE, BRANCH, -1, 2 },
	{ "bpr", OPCODE, BRANCHR, -1, 2 },
	{ "br", OPCODE, BRANCHR, -1, 15 },
	{ "bxh", OPCODE, RS1, -1, BXH },
	{ "bxle", OPCODE, RS1, -1, BXLE },
	{ "bz", OPCODE, BRANCH, -1, 8 },
	{ "bzr", OPCODE, BRANCHR, -1, 8 },
	{ "c", OPCODE, RX, -1, CMP },
	{ "ccw", OPCODE, 0, -1, CCW },
	{ "cd", OPCODE, RX, -1, CD },
	{ "cdr", OPCODE, RR, -1, CDR },
	{ "cds", OPCODE, RS1, -1, CDS },
	{ "ce", OPCODE, RX, -1, CE },
	{ "cer", OPCODE, RR, -1, CER },
	{ "ch", OPCODE, RX, -1, CH },
	{ "cl", OPCODE, RX, -1, CL },
	{ "clc", OPCODE, SS2, -1, CLC },
	{ "clcl", OPCODE, RR, -1, CLCL },
	{ "cli", OPCODE, SI1, -1, CLI },
	{ "clm", OPCODE, RS1, -1, CLM },
	{ "clr", OPCODE, RR, -1, CLR },
	{ "clrio", OPCODE, S, -1, CLRIO },
	{ "cnop", OPCODE, 0, -1, CNOP },
	{ "cp", OPCODE, SS1, -1, CP },
	{ "cr", OPCODE, RR, -1, CR },
	{ "cs", OPCODE, RS1, -1, CS },
	{ "cvb", OPCODE, RX, -1, CVB },
	{ "cvd", OPCODE, RX, -1, CVD },
	{ "d", OPCODE, RX, -1, DIV },
	{ "dc", OPCODE, 0, -1, DC },
	{ "dd", OPCODE, RX, -1, DD },
	{ "ddr", OPCODE, RR, -1, DDR },
	{ "de", OPCODE, RX, -1, DE },
	{ "dentry", OPCODE, 0, -1, DENTRY },
	{ "der", OPCODE, RR, -1, DER },
	{ "diag", OPCODE, RS1, -1, DIAG },
	{ "dp", OPCODE, SS1, -1, DP },
	{ "dr", OPCODE, RR, -1, DR },
	{ "drop", OPCODE, 0, -1, DROP },
	{ "ds", OPCODE, 0, -1, DS },
	{ "ed", OPCODE, SS2, -1, ED },
	{ "edmk", OPCODE, SS2, -1, EDMK },
	{ "end", OPCODE, 0, -1, ENDOP },
	{ "entry", OPCODE, 0, -1, ENTRY },
	{ "ex", OPCODE, RX, -1, EX },
	{ "extrn", OPCODE, 0, -1, EXTRN },
	{ "hdr", OPCODE, RR, -1, HDR },
	{ "hdv", OPCODE, S, -1, HDV },
	{ "her", OPCODE, RR, -1, HER },
	{ "hio", OPCODE, S, -1, HIO },
	{ "ic", OPCODE, RX, -1, IC },
	{ "icm", OPCODE, RS1, -1, ICM },
	{ "ipk", OPCODE, S, -1, IPK },
	{ "isk", OPCODE, RR, -1, ISK },
	{ "l", OPCODE, RX, -1, LOAD },
	{ "la", OPCODE, RX, -1, LA },
	{ "lcdr", OPCODE, RR, -1, LCDR },
	{ "lcer", OPCODE, RR, -1, LCER },
	{ "lcr", OPCODE, RR, -1, LCR },
	{ "lctl", OPCODE, RS1, -1, LCTL },
	{ "ld", OPCODE, RX, -1, LD },
	{ "ldr", OPCODE, RR, -1, LDR },
	{ "le", OPCODE, RX, -1, LE },
	{ "ler", OPCODE, RR, -1, LER },
	{ "lh", OPCODE, RX, -1, LH },
	{ "lm", OPCODE, RS1, -1, LM },
	{ "lndr", OPCODE, RR, -1, LNDR },
	{ "lner", OPCODE, RR, -1, LNER },
	{ "lnr", OPCODE, RR, -1, LNR },
	{ "lpdr", OPCODE, RR, -1, LPDR },
	{ "lper", OPCODE, RR, -1, LPER },
	{ "lpr", OPCODE, RR, -1, LPR },
	{ "lpsw", OPCODE, SI2, -1, LPSW },
	{ "lr", OPCODE, RR, -1, LR },
	{ "lra", OPCODE, RX, -1, LRA },
	{ "lrdr", OPCODE, RR, -1, LRDR },
	{ "lrer", OPCODE, RR, -1, LRER },
	{ "ltdr", OPCODE, RR, -1, LTDR },
	{ "lter", OPCODE, RR, -1, LTER },
	{ "ltorg", OPCODE, 0, -1, LTORG },
	{ "ltr", OPCODE, RR, -1, LTR },
	{ "m", OPCODE, RX, -1, MULT },
	{ "mc", OPCODE, SI1, -1, MC },
	{ "md", OPCODE, RX, -1, MD },
	{ "mdr", OPCODE, RR, -1, MDR },
	{ "me", OPCODE, RX, -1, ME },
	{ "mer", OPCODE, RR, -1, MER },
	{ "mh", OPCODE, RX, -1, MH },
	{ "mp", OPCODE, SS1, -1, MP },
	{ "mr", OPCODE, RR, -1, MR },
	{ "mvc", OPCODE, SS2, -1, MVC },
	{ "mvcl", OPCODE, RR, -1, MVCL },
	{ "mvi", OPCODE, SI1, -1, MVI },
	{ "mvn", OPCODE, SS2, -1, MVN },
	{ "mvo", OPCODE, SS1, -1, MVO },
	{ "mvz", OPCODE, SS2, -1, MVZ },
	{ "mxd", OPCODE, RX, -1, MXD },
	{ "mxdr", OPCODE, RR, -1, MXDR },
	{ "mxr", OPCODE, RR, -1, MXR },
	{ "n", OPCODE, RX, -1, AND },
	{ "nc", OPCODE, SS2, -1, ANDC },
	{ "ni", OPCODE, SI1, -1, ANDI },
	{ "nop", OPCODE, BRANCH, -1, 0 },
	{ "nopr", OPCODE, BRANCHR, -1, 0 },
	{ "nr", OPCODE, RR, -1, ANDR },
	{ "o", OPCODE, RX, -1, OR },
	{ "oc", OPCODE, SS2, -1, OC },
	{ "oi", OPCODE, SI1, -1, OI },
	{ "or", OPCODE, RR, -1, ORR },
	{ "pack", OPCODE, SS1, -1, PACK },
	{ "ptlb", OPCODE, S, -1, PTLB },
	{ "rdd", OPCODE, SI1, -1, RDD },
	{ "rrb", OPCODE, S, -1, RRB },
	{ "s", OPCODE, RX, -1, SUB },
	{ "sck", OPCODE, S, -1, SCK },
	{ "sckc", OPCODE, S, -1, SCKC },
	{ "sd", OPCODE, RX, -1, SUBD },
	{ "sdr", OPCODE, RR, -1, SDR },
	{ "se", OPCODE, RX, -1, SUBE },
	{ "ser", OPCODE, RR, -1, SER },
	{ "sh", OPCODE, RX, -1, SHop },
	{ "sigp", OPCODE, RS1, -1, SIGP },
	{ "sio", OPCODE, S, -1, SIO },
	{ "siof", OPCODE, S, -1, SIOF },
	{ "sl", OPCODE, RX, -1, SLop },
	{ "sla", OPCODE, RS2, -1, SLA },
	{ "slda", OPCODE, RS2, -1, SLDA },
	{ "sldl", OPCODE, RS2, -1, SLDL },
	{ "sll", OPCODE, RS2, -1, SLL },
	{ "slr", OPCODE, RR, -1, SLR },
	{ "sp", OPCODE, SS1, -1, SP },
	{ "spka", OPCODE, S, -1, SPKA },
	{ "spm", OPCODE, RR, -1, SPM },
	{ "spt", OPCODE, S, -1, SPT },
	{ "spx", OPCODE, S, -1, SPX },
	{ "sr", OPCODE, RR, -1, SR },
	{ "sra", OPCODE, RS2, -1, SRA },
	{ "srda", OPCODE, RS2, -1, SRDA },
	{ "srdl", OPCODE, RS2, -1, SRDL },
	{ "srl", OPCODE, RS2, -1, SRL },
	{ "srp", OPCODE, SS3, -1, SRP },
	{ "ssk", OPCODE, RR, -1, SSK },
	{ "ssm", OPCODE, SI2, -1, SSM },
	{ "st", OPCODE, RX, -1, STORE },
	{ "stap", OPCODE, S, -1, STAP },
	{ "stc", OPCODE, RX, -1, STC },
	{ "stck", OPCODE, S, -1, STCK },
	{ "stckc", OPCODE, S, -1, STCKC },
	{ "stcm", OPCODE, RS1, -1, STCM },
	{ "stctl", OPCODE, RS1, -1, STCTL },
	{ "std", OPCODE, RX, -1, STD },
	{ "ste", OPCODE, RX, -1, STE },
	{ "sth", OPCODE, RX, -1, STH },
	{ "stidc", OPCODE, S, -1, STIDC },
	{ "stidp", OPCODE, S, -1, STIDP },
	{ "stm", OPCODE, RS1, -1, STM },
	{ "stnsm", OPCODE, SI1, -1, STNSM },
	{ "stosm", OPCODE, SI1, -1, STOSM },
	{ "stpt", OPCODE, S, -1, STPT },
	{ "stpx", OPCODE, S, -1, STPX },
	{ "su", OPCODE, RX, -1, SU },
	{ "sur", OPCODE, RR, -1, SUR },
	{ "svc", OPCODE, RR, -1, SVC },
	{ "sw", OPCODE, RX, -1, SW },
	{ "swr", OPCODE, RR, -1, SWR },
	{ "sxr", OPCODE, RR, -1, SXR },
	{ "tch", OPCODE, SI2, -1, TCH },
	{ "tio", OPCODE, SI2, -1, TIO },
	{ "tm", OPCODE, SI1, -1, TM },
	{ "tr", OPCODE, SS2, -1, TR },
	{ "trt", OPCODE, SS2, -1, TRT },
	{ "ts", OPCODE, SI2, -1, TS },
	{ "unpk", OPCODE, SS1, -1, UNPK },
	{ "using", OPCODE, 0, -1, USING },
	{ "wrd", OPCODE, SI1, -1, WRD },
	{ "wxtrn", OPCODE, 0, -1, WXTRN },
	{ "x", OPCODE, RX, -1, XOR },
	{ "xc", OPCODE, SS2, -1, XC },
	{ "xi", OPCODE, SI1, -1, XI },
	{ "xr", OPCODE, RR, -1, XR },
	{ "zap", OPCODE, SS1, -1, ZAP },
	};
