/*
 * STOre File System
 * Sorry about the mneumonic
 *
 * stofs [-f listfile] tape
 * stofs tape [filesystem]...
 *
 */
#include <stdio.h>
#include <sgtty.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>

#define MDISK 32            /* Maximum # of file systems */
#define BLKTRK 3            /* # of blocks per track     */
#define BLOCK 4096          /* Tape block size           */
#define TBSIZE (5*BLKTRK*BLOCK)  /* 60k block size for tapes */
#define HEADERSIZE 4096     /* size of header            */

#define writetm(a)      ioctl(a, TAPIO, 0x1f)

extern int errno;
extern char *cmdname;
extern char atetab[];

char area[TBSIZE];
char disks[MDISK][20];
char *dsklist = "/etc/dsklist";
char *files[MDISK];
char tame[40];

int  blocks[MDISK];
int  fdout;

struct disklist {
	char device[20];
	char filesys[40];
	int  blks;
} dill;

char header[BLOCK];

struct disklist dsklst[4096/sizeof(dill) + 1];

main(argc, argv)
int argc;
char *argv[];
{
	struct disklist *dp;
	FILE *fplist;
	char *fslist;
	char *labelchk();
	int i;

	while(**++argv == '-') {
                argc--;
		switch(*++*argv) {
		case 'f':
			argc--;
			fslist = *++argv;
			break;
		default:
			fprintf(stderr, "%s: %s: unknown argument\n",
                                cmdname, *argv);
			exit(100);
		}
	}
	fplist = fopen(dsklist, "r");
	if(fplist == NULL) {
		fprintf(stderr, "%s: %s: cannot open\n", cmdname, dsklist);
		exit(1);
	}
	dp = dsklst;
	while(fscanf(fplist, "%s %s %d %d", dp->device, dp->filesys, &i, &dp->blks) == 4) {
		dp++;
	}
	fclose(fplist);

	dolabel(*argv);
	wrheader(argc, argv, fslist);
	wrfilesys(dp);
}
/*
 *  Check the label.  If its ok, rewrite it terminated by a tape mark
 */
dolabel(name)
char    *name;
{
	char    *lbl;
	char    label[80];
	int     i;

	if(name[0] != '/')
                sprintf(tame, "/dev/tape/%s", name);
	else
		sprintf(tame, "%s", name);
	fdout = open(tame, 0);
	if(fdout < 0) {
		fprintf(stderr, "%s: cannot open tape %s.\n", cmdname, tame);
		exit(2);
	}
	if ((lbl = labelchk(fdout, name)) != NULL) {
		fprintf(stderr, "%s: Label conflict: %s %s.\n", cmdname, tame, lbl);
		exit(6);
	} else {
		close(fdout);
		fdout = open(tame, 1);
		if (fdout == -1) {
			fprintf(stderr, "%s: Unable to write on tape %s\n", cmdname, tame);
			exit(2);
		}
		sprintf(label, "VOL1%-76.6s", name);
		for(i = 0; i < 10; i++) {
			if(islower(label[i]))
				label[i] = toupper(label[i]);
			label[i] = atetab[label[i]];
		}
		write(fdout, label, 80);
		writetm(fdout);
	}
}
/*
 *  wrfilesys - write the file systems to tape, each separated
 *  by a tape mark.
 */
wrfilesys(dp)
struct  disklist *dp;
{
	int     i, j;
	int     fdin;
	int     blockno;

	dp = (struct disklist *) (header + sizeof(time_t));
	while(*dp->device) {
		fprintf(stderr, "%s:\n", dp->filesys);
		fdin = open(dp->device, 0);
		if(fdin < 0) {
			fprintf(stderr, "%s: %s: cannot open input device\n",
                                cmdname, dp->device);
			exit(4);
		}
		blockno = 0;
		for (;;) {
		        j = read(fdin, area, TBSIZE);
			if (j < 0)
				if ((j = recover(dp->device, area, blockno)) < 0)
				        break;
			if (j == 0)
				break;
			blockno += j / BLOCK;
                        i = write(fdout, area, j);
                        if (i != j) {
                                if (i == -1 && errno == ENOSPC) {
                                        fprintf(stderr, "%s: End of tape encountered\n", cmdname);
                                        exit(8);
                                }
                                fprintf(stderr, "%s: Write error. i %d j %d errno %d\n",
                                        cmdname, i, j, errno);
                                exit(5);
                        }
		}
		if (j < 0) {
			fprintf(stderr, "%s: read error on %s. errno %d\n", cmdname, dp->device, errno);
		        exit(9);
		}
		writetm(fdout);
		close(fdin);
	        if (dp->blks != blockno)
	                fprintf(stderr, "\t%d out of %d blocks copied\n", blockno, dp->blks);
		dp++;
	}
	close(fdout);
        writetm(fdout);
}


/*
 * change /dev/dskn to /dev/fdskn
 */
speedup(new, old)
char *new;
char *old;
{
	static  char    devdsk[] = "/dev/dsk";

	if (strncmp(old, devdsk, strlen(devdsk)) != 0)
		strcpy(new, old);
	else
                sprintf(new, "/dev/fdsk%s", &old[strlen(devdsk)]);
}
/*
 *  wrheader - write the header block
 */
wrheader(argc, argv, fslist)
int     argc;
char    **argv;
char    *fslist;
{
	FILE    *fsfp;
	int     i;
	time_t  time();
	time_t  *t;
	char    *malloc();
	char    *fnspace;
	char    fsname[100];
	struct  disklist *dp;

	/*
	 *  Gather the file systems to write to tape
	 */
	if (argc > 2) {
		for(i = 0; *++argv; i++) {
			files[i] = *argv;
			if (findisk(i)) {
				fprintf(stderr, "%s: %s: not a file system\n",
                                        cmdname, *argv);
				exit(7);
			}
		}
	} else {
		if ((fsfp = fopen(fslist, "r")) == NULL) {
			fprintf(stderr, "%s: %s: unable to open\n", cmdname, fslist);
			exit(1);
		}
		i = 0;
		while (fscanf(fsfp, "%s", fsname) != EOF) {
			fnspace = malloc(strlen(fsname) + 1);
			strcpy(fnspace, fsname);
			files[i] = fnspace;
			if (findisk(i)) {
				fprintf(stderr, "%s: %s: not a file system\n",
                                        cmdname, fnspace);
				exit(7);
			}
			i++;
		}
		fclose(fsfp);
	}
	/*
	 * fill the structures of disk info.
	 */
        t = (time_t *) header;
	*t = time();
	dp = (struct disklist *) (header + sizeof(time_t));
	for (i = 0; files[i] != NULL; i++) {
		strcpy(dp->filesys, files[i]);
		speedup(dp->device, disks[i]);
		dp->blks = blocks[i];
		dp++;
	}
	if (write(fdout, header, HEADERSIZE) != HEADERSIZE) {
		fprintf(stderr, "%s: cannot write on tape %s.\n", cmdname, tame);
		exit(3);
	}
        writetm(fdout);
}
/*
 * find the 'other' information from the filesystem name
 */
findisk(n)
int n;
{
	int i;
	for(i=0; *dsklst[i].device; i++) {
		if(strcmp(dsklst[i].filesys, files[n]) == 0) {
			blocks[n] = dsklst[i].blks;
			strcpy(disks[n], dsklst[i].device);
			return(0);
		}
	}
	return(-1);
}

/*
 * Recover from read errors by reading normal disk.
 * The fast disk driver currently does not do all the error
 * recovery that it could.  Therefore, if we get an read error
 * from the fast disk driver, we come here to try and read the
 * blocks with the normal disk driver.  If we still get an
 * error on a block, write a block of zeros out to the tape.
 * Eventually this should not be necessary because the fast
 * disk driver should do the proper error recovery.
 */
recover(fdevname, area, blockno)
char *fdevname, *area;
int blockno;
{
	char ndevname[25];
	register int i, j, fd;

	/*
	 *        0123456789
	 * change /dev/fdskXXX
	 * to     /dev/dskXXX
	 */
	for (i = 0; i < 5; i++)
		ndevname[i] = fdevname[i];
	for (i = 5; fdevname[i]; i++)
		ndevname[i] = fdevname[i + 1];
	if ((fd = open(ndevname, 0)) < 0) {
		fprintf(stderr, "%s: cannot open %x\n", cmdname, ndevname);
		return(-1);
	}
	seek(fd, blockno * BLOCK, 0);
	for (i = 0; i < TBSIZE/BLOCK; i++) {
		j = read(fd, &area[i*BLOCK], BLOCK);
		if (j == -1) {
			fprintf(stderr, "\tbadblock %d\n", blockno + i);
			zero(&area[i*BLOCK], BLOCK);
		} else if (j != BLOCK) {
			fprintf(stderr, "%s: read error recovery failed. j %d\n", cmdname, j);
	                exit(9);
                } else  if (j == 0)
			break;
	}
        fprintf(stderr, "\trecovering from read error blockno %d\n", blockno);
	close(fd);
	return(i*BLOCK);
}
