#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>

#define DIRMODE       (S_IFDIR | (S_IREAD | S_IWRITE | S_IEXEC) | \
                                ((S_IREAD | S_IWRITE | S_IEXEC) >> 3) | \
                                ((S_IREAD | S_IEXEC) >> 6))
#define EOS             '\0'
#define USERIDLEN       8
#define DEPTLEN         4
#define PASSWDLEN       8
#define VPASSWDLEN      8
#define VMIDLEN         8
#define TSOIDLEN        8
#define OFFICELEN       7
#define PHONELEN        4
#define MSLEN           3
#define BINNOLEN        3
#define GROUPLEN        8
#define UIDNOLEN        4
#define HOMELEN         25
#define SHELLLEN        25
#define NAMELEN         25
#define MAXLINE         512

/*
 *  offsets to fields in /etc/identity
 */
#define DEPTLOC         23
#define OFFICELOC       31
#define PHONELOC        41
#define MSLOC           47
#define NAMELOC         53

char    userid[USERIDLEN + 1];
char    passwd[PASSWDLEN + 1];
char    vpasswd[VPASSWDLEN + 1];
char    group[GROUPLEN + 1];
char    dept[DEPTLEN + 1];
char    vmid[VMIDLEN + 1];
char    tsoid[TSOIDLEN + 1];
char    binno[BINNOLEN + 1];
char    homedir[HOMELEN + 1];
char    shell[SHELLLEN + 1];
char    office[OFFICELEN + 1];
char    phone[PHONELEN + 1];
char    mailstop[MSLEN + 1];
char    username[NAMELEN + 1];
/*
 *  Various file names
 */
char    etcpasswd[] = "/etc/passwd";
char    tmppasswd[] = "/etc/moduserXXXXXX";
char    lnpasswd[] = "/etc/moduserXXXXXX";
char    identity[] = "/etc/identity";
char    tmpident[] = "/etc/moduserXXXXXX";
char    lnident[] = "/etc/moduserXXXXXX";
/*
 *  Error messages
 */
char    *msg = "";
char    novpasswd[] = "No validate password";
char    conflpasswd[] = "Conflicting passwords";
char    deptwrong[] = "Department not right length";
char    nohomedir[] = "No home directory";
char    badhomedir[] = "Bad home directory";
char    notdirectory[] = "Not a directory";
char    noname[] = "No user name";

char    idline[MAXLINE];
int     uid;
int     gid;
int     cursor_pos;

struct  passwd  *pw;
struct  passwd  *getpwnam();
struct  passwd  *getpwuid();
struct  group   *getgrgid();
extern  char    *cmdname;

main(argc, argv)
int argc;
char **argv;
{

	argv++;
	if (argc <=  1) {
		uid = getuid();
		pw = getpwuid(uid);
	} else {
                if ((pw = getpwnam(*argv)) == NULL) {
			fprintf(stderr, "%s: user %s not found\n", cmdname, *argv);
			exit(1);
		}
		uid = pw->pw_uid;
                if (getuid() != 0) {
                        cursor_pos = 408;
                        gathfields();
                        do {
                                readit();
                        } while (qskp != TESTREQ);
                        exit(1);
                }
	}
        cursor_pos = 408;
        gathfields();
        do {
                readit();
                if (qskp == TESTREQ)
                        exit(0);
        } while (verify() || qskp != PF3);
        update();
}

/*
 *  readit - read the screen
 *  Get all the input fields and assign them to variables
 *  via quickscreen.
 */
readit()
{
        at 101;
	panel(erase, cursor = cursor_pos) {
#@101#
        Modify user information

Name:  #IN, username, NAMELEN#
Dept:  #IN, dept, DEPTLEN#               Office:   #IN, office, OFFICELEN#
Phone: #IN, phone, PHONELEN#               Mailstop: #IN, mailstop, MSLEN#

Userid:   #ON, userid, USERIDLEN#
Password: #II, passwd, PASSWDLEN#
Validate: #II, vpasswd, VPASSWDLEN#

Vmid:  #IN, vmid, VMIDLEN#           Group:   #ON, group, GROUPLEN#
Tsoid: #IN, tsoid, TSOIDLEN#           Homedir: #IN, homedir, HOMELEN#
Binno: #IN, binno, BINNOLEN#                Shell:   #IN, shell, SHELLLEN#


        #OH, msg, strlen(msg)#

        PF3:  make modifications
        TESTREQ:  quit
	}
}
/*
 *  verfiy - verify all the input fields.
 *  If a field is bad, set an error message and the
 *  cursor position and return true.
 */
verify()
{
	struct  stat    statb;

	msg = "";

	if (username[0] == EOS) {
		msg = noname;
                cursor_pos = qspos(username);
		return(1);
	}

	if (strlen(dept) != DEPTLEN) {
		msg = deptwrong;
                cursor_pos = qspos(dept);
		return(1);
	}

	if (passwd[0] != EOS) {
	        if (vpasswd[0] != EOS) {
                        if (strcmp(passwd, vpasswd) != 0) {
                                msg = conflpasswd;
                                cursor_pos = qspos(passwd);
                                return(1);
                        }
                } else {
                        msg = novpasswd;
                        cursor_pos = qspos(vpasswd);
                        return(1);
		}
	}

	if (homedir[0] == EOS) {
		msg = nohomedir;
                cursor_pos = qspos(homedir);
		return(1);
	} else if (stat(homedir, &statb) == -1) {
		msg = badhomedir;
                cursor_pos = qspos(homedir);
		return(1);
	} else if ((statb.st_mode & S_IFDIR) == 0) {
		msg = notdirectory;
                cursor_pos = qspos(homedir);
		return(1);
	}

        return(0);
}
/*
 *  update - update /etc/passwd, /etc/identity, if necessary
 */
update()
{
	signal(SIGHUP, SIG_IGN);
	signal(SIGINTR, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	if (passwd[0] != EOS)
                cryptpasswd();
	if (chgpasswd())
                editpasswd();
	if (chgidentity())
                editidentity();
}
/*
 *  chgpasswd - determine if the passwd file needs to be updated
 */
chgpasswd()
{
	if (passwd[0] != EOS)
		return(1);
	if (strcmp(binno, pw->pw_binno) != 0)
		return(1);
	if (strcmp(dept, pw->pw_dept) != 0)
		return(1);
	if (strcmp(vmid, pw->pw_vmid) != 0)
		return(1);
	if (strcmp(tsoid, pw->pw_tsoid) != 0)
		return(1);
	if (strcmp(homedir, pw->pw_dir) != 0)
		return(1);
	if (strcmp(shell, pw->pw_shell) != 0)
		return(1);
	return(0);
}
/*
 *  chgidentity - determine if the identity file needs to be updated
 */
chgidentity()
{
	if (strncmp(dept, &idline[DEPTLOC], strlen(dept)) != 0)
		return(1);
        if (strncmp(office,  &idline[OFFICELOC], strlen(office)) != 0)
		return(1);
        if (strncmp(phone, &idline[PHONELOC], strlen(phone)) != 0)
		return(1);
        if (strncmp(mailstop, &idline[MSLOC], strlen(mailstop)) != 0)
		return(1);
        if (strncmp(username, &idline[NAMELOC], strlen(username)) != 0)
		return(1);
	return(0);
}

/*
 *  editpasswd - update the entry to /etc/passwd.
 *  If any of the passwd fields have changed rewrite it.
 *  Do a song and dance with links to ensure the file
 *  is never completely lost.
 */
editpasswd()
{
	FILE    *fp, *ofp;
	char    line[MAXLINE];
	struct  passwd  *lpw, *getpwent();

	chkfile(etcpasswd);
	mktemp(tmppasswd);
	mktemp(lnpasswd);
	fp = fopen(etcpasswd, "r");
	ofp = fopen(tmppasswd, "w");
	setpwent();
	while (fgets(line, sizeof(line), fp) != NULL) {
		lpw = getpwent();
		if (lpw->pw_uid == uid) {
                        fprintf(ofp, "%s:%s:%d:%d:%s,%s,%s,%s:%s:%s\n",
                                userid, pw->pw_passwd, uid, gid, dept, vmid,
			        tsoid, binno, homedir, shell);
		} else
                        fprintf(ofp, "%s", line);
	}
	fclose(fp);
	fclose(ofp);
	link(etcpasswd, lnpasswd);
	unlink(etcpasswd);
	link(tmppasswd, etcpasswd);
	unlink(tmppasswd);
	unlink(lnpasswd);
	chmod(etcpasswd, 0664);
}

/*
 *  editidentity - change the user info in /etc/identity
 */
editidentity()
{
	FILE    *fp, *ofp;
	int     luid;
	char    line[MAXLINE];

	chkfile(identity);
	mktemp(tmpident);
	mktemp(lnident);
	fp = fopen(identity, "r");
	ofp = fopen(tmpident, "w");
	while (fgets(line, sizeof(line), fp) != NULL) {
                sscanf(line, "%*s %d", &luid);
                if (luid == uid) {
                        fprintf(ofp, "%-10s%4d/%-2d      %-4s    %-7s   %-4s  %-3s   %s\n",
                                userid, uid, gid, dept, office, phone, mailstop,
                                username);
                } else
                        fprintf(ofp, "%s", line);
        }
	fclose(fp);
	fclose(ofp);
	link(identity, lnident);
	unlink(identity);
	link(tmpident, identity);
	unlink(tmpident);
	unlink(lnident);
        chmod(identity, 0664);
}
/*
 *  cryptpasswd - encrypt the passwd
 *  This code stolen from the passwd command.
 */
cryptpasswd()
{
	char    saltc[2];
	int     salt, c, i;
	char    *crypt();

	salt = time();
	salt += getpid();

	saltc[0] = salt & 077;
	saltc[1] = (salt >> 6) & 077;
	for (i = 0; i < 2; i++) {
		c = saltc[i] + '.';
		if (c>'9')
			c += 7;
		if (c>'Z')
			c += 6;
		saltc[i] = c;
	}
	pw->pw_passwd = crypt(passwd, saltc);
}
/*
 *  gathfields - gather the fields to be displayed
 */
gathfields()
{
	struct  group   *gr;

        strcpy(userid, pw->pw_name);
        strcpy(dept, pw->pw_dept);
        strcpy(vmid, pw->pw_vmid);
        strcpy(tsoid, pw->pw_tsoid);
        strcpy(binno, pw->pw_binno);
        strcpy(homedir, pw->pw_dir);
        strcpy(shell, pw->pw_shell);
	gid = pw->pw_gid;

	if ((gr = getgrgid(gid)) != NULL)
                strcpy(group, gr->gr_name);
	else
		strcpy(group, "other");

        passwd[0] = EOS;
        vpasswd[0] = EOS;
	getidentity(pw->pw_name);
}

/*
 *  getidentity - the information from the identity file about this user
 */
getidentity(name)
char    *name;
{
	FILE    *fp;
	int     len;

	if ((fp = fopen(identity, "r")) == NULL) {
		fprintf(stderr, "%s: unable to open %s\n", cmdname, identity);
		exit(1);
	}
	while (fgets(idline, MAXLINE, fp) != NULL) {
		len = strlen(name);
		if ((strncmp(name, idline, len) == 0) && (idline[len] == ' ')) {
                        strncpy(office,  &idline[OFFICELOC], OFFICELEN);
                        strncpy(phone, &idline[PHONELOC], PHONELEN);
                        strncpy(mailstop, &idline[MSLOC], MSLEN);
                        strncpy(username, &idline[NAMELOC], NAMELEN);
			if (username[strlen(username)-1] == '\n')
			        username[strlen(username)-1] = EOS;
			break;
		}
	}
	fclose(fp);
}
/*
 *  chkfile - check if a file is currently in use.
 *  If so, sleep and try again.
 *  If not, turn on the execution bits to flag it as in use.
 */
chkfile(file)
char    *file;
{
	int     i;
	extern  int     errno;
	struct  stat    statb;

	for (i = 0; i < 5; i++) {
		stat(file, &statb);
		if ((statb.st_mode & 1) == 0) {
			chmod(file, 0777);
                        return;
                }
                sleep(2);
	}
	fprintf(stderr, "%s: %s is busy\n", cmdname, file);
	exit(1);
}
