/*
 * Translation stuff.
 */

#define COI  0

extern int K;
extern int listf;
extern int U;
extern char tubotab[];
extern char mrxotab[];

/*
 * Translate internal form to external form.
 */
char *
trie(cp)
register char *cp;
{
	static char buf[530];
	register char *bp, *bpstop;
	register int n;
	register char c;

	bp = buf;
	bpstop = bp + 512;
	if (K != COI) {
		if (listf == 0) {
			while ((c = *cp++) && bp < bpstop) {
				if (c == '\t') {
					n = 8 - (bp - buf) % 8;
					while (n--)
						*bp++ = ' ';
				} else
					*bp++ = c;
			}
		} else {
			while ((c = *cp++) && bp < bpstop) {
				if (c == '\b')
					*bp++ = 0x88;
				else {
					if (mrxotab[c] == 0x6a) {   /* Non-displayable */
						*bp++ = '\\';
						*bp++ = (c >> 6) + '0';
						*bp++ = ((c >> 3) & 07) + '0';
						*bp++ = (c & 07) + '0';
					} else
						*bp++ = c;
				}
			}
		}
	} else {
		while ((c = *cp++) && bp < bpstop) {
			switch (c) {
			case '{':
				*bp++ = '(';
				*bp++ = '<';
				break;
			case '}':
				*bp++ = '>';
				*bp++ = ')';
				break;
			case '[':
				*bp++ = '(';
				*bp++ = '|';
				break;
			case ']':
				*bp++ = '|';
				*bp++ = ')';
				break;
			case '`':
				*bp++ = '\\';
				*bp++ = '<';
				break;
			case '^':
				*bp++ = '\\';
				*bp++ = '~';
				break;
			case '\t':
				if (listf) {
					*bp++ = '>';
				} else {
					n = 8 - (bp - buf) % 8;
					while (n--)
						*bp++ = ' ';
				}
				break;
			case '\b':
				if (listf) {
					*bp++ = '<';
					break;
				} else
					*bp++ = c;
				break;
			default:
				if (listf && tubotab[c] == 0x6a) {
					*bp++ = '\\';
					*bp++ = (c >> 6) + '0';
					*bp++ = ((c >> 3) & 07) + '0';
					*bp++ = (c & 07) + '0';
				} else
					*bp++ = c;
				break;
			}
		}
	}
	*bp = '\0';
	return(buf);
}

/*
 * Translate external to internal.
 */
char *
trei(cp, u)
register char *cp;
int u;
{
	static char buf[530];
	register char *bp, *bpstop;
	register char c, c2;

	bp = buf;
	bpstop = bp + 512;
	while((c = *cp++) && bp < bpstop) {
		c2 = *cp;
		switch (c) {
		case'(':
			if (c2 == '<') {
				*bp++ = '{';
				cp++;
			} else if (c2 == '|') {
				*bp++ = '[';
				cp++;
			} else
				*bp++ = '(';
			break;
		case '|':
			if (c2 == ')') {
				*bp++ = ']';
				cp++;
			} else
				*bp++ = '|';
			break;
		case '>':
			if (c2 == ')') {
				*bp++ = '}';
				cp++;
			} else
				*bp++ = '>';
			break;
		case '\\':
			if (c2 == '~') {
				*bp++ = '^';
				cp++;
			} else if (c2 == '<') {
				*bp++ = '`';
				cp++;
			} else if (c2 == '!') {
				*bp++ = '\t';
				cp++;
			} else
				*bp++ = '\\';
			break;
		case 0177:        /* split | */
			*bp++ = '?';      /* Should recover, but it's real hard to do */
			break;
		default:
			if (U && u && c >= 'a' && c <= 'z')
				*bp++ = c - 'a' + 'A';
			else
				*bp++ = c;
			break;
		}
	}
	*bp = '\0';
	return(buf);
}
