#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "save.h"

extern  char    vflg;
extern  char    fflg;
extern  char    error;
extern  char    *cmdname;
extern  char    *tmp;
extern  char    *tmp2;
extern  char    *filestor;
extern  int     nver, maxver;
extern  struct  version *verhdr;
extern  int     die;
extern  int     errno;

/*
 *  save - save a file
 *  Restore the most recent version and run diff between it and
 *  the argument file.  Feed the argument file to diff and
 *  check for leading control characters (percent sign) and dots.
 *  Append the diff commands to the savefile.
 *  If this is the first save, diff between /dev/null and the
 *  argument file.
 *  Return: 0: if the file is saved,
 *         -1: if the file is not saved.
 */
save(name, nmaxver)
char    *name;                  /* file to save */
int     nmaxver;                /* new max # of saved versions */
{
	char    svname[100];
	char    *rname;         /* restore name */
	FILE    *rfp;           /* restore from this file */
	FILE    *tfp;           /* temp file to hold restoration */
	FILE    *sfp;           /* savefile to append to */
	FILE    *vfp;           /* version input to be fed to diff */
	FILE    *fopen();
	char    *c;
	char    *cantsave();
	struct  version *v, *nv;

	strcpy(svname, name);
	strcat(svname, SUFFIX);
	if ((rname = cantsave(name, svname)) == NULL)
		return(-1);
	/*
	 *  Open all the files
	 */
	if ((rfp = fopen(rname, "r")) == NULL) {
		fprintf(stderr, "%s: %s: unable to open\n", cmdname, rname);
		error++;
		return(-1);
	}
	if ((tfp = fopen(tmp, "w")) == NULL) {
		fprintf(stderr, "%s: %s: unable to open\n", cmdname, tmp);
		fclose(rfp);
		error++;
		return(-1);
	}
	if ((sfp = fopen(svname, "a")) == NULL) {
                fprintf(stderr, "%s: %s: unable to open\n", cmdname, svname);
		fclose(rfp);
		fclose(tfp);
		error++;
                return(-1);
        }
	if ((vfp = fopen(name, "r")) == NULL) {
		fprintf(stderr, "%s: %s: unable to open\n", cmdname, name);
		fclose(rfp);
		fclose(tfp);
		fclose(sfp);
		error++;
		return(-1);
	}
	restore(rfp, tfp, 0);
        fclose(rfp);
        fclose(tfp);
	/*
	 *  Save it
         */
	if (vflg)
                maxver = nmaxver;
	if (maxver && nver >= maxver) {
		fclose(sfp);
		combine(svname);
	} else if (vflg) {
		fclose(sfp);
		sfp = fopen(svname, "w");
		fprintf(sfp, "%c%c %d\n", CNTRLCHAR, NVERSIONS, maxver);
		for (v = verhdr; v != NULL; v = v->v_next)
			for (c = v->v_sptr; c <= v->v_eptr; c += strlen(c)+1)
                                fprintf(sfp, "%s\n", c);
	} else if (strcmp(rname, "/dev/null") == 0) {
		fclose(sfp);
		sfp = fopen(svname, "w");
		fprintf(sfp, "%c%c %d\n", CNTRLCHAR, NVERSIONS, maxver);
	}
	fclose(sfp);
	addver(name, svname, vfp);
	fclose(vfp);
	free(filestor);
	for (v = verhdr; v != NULL; v = nv) {
		nv = v->v_next;
		free((char *) v);
	}
	return(0);
}
/*
 *  cantsave - see if this file can/should be saved.
 *  Check the dates and the -f flag, and make sure
 *  the + file is writable.
 *  Returns: a pointer to the savefile (or /dev/null), or
 *           NULL, if the file can't be saved.
 */
char *
cantsave(name, svname)
char    *name;
char    *svname;
{
	struct  stat    svstatb, statb;

	if (stat(svname, &svstatb) != -1) {
		if (stat(name, &statb) == -1) {
			fprintf(stderr, "%s: %s: unable to open\n",
				cmdname, name);
			error++;
			return(NULL);
		}
                if (access(svname, 2)) {
                        fprintf(stderr, "%s: %s: unable to write\n",
				cmdname, svname);
			error++;
			return(NULL);
                }
		if (!fflg) {
                        if ((svstatb.st_mtime > statb.st_mtime) && !fflg) {
                                fprintf(stderr, "%s: %s: not out of date\n",
                                        cmdname, name);
                                error++;
                                return(NULL);
                        }
                }
		return(svname);
	} else
		return("/dev/null");
}
/*
 *  combine - combine some of the oldest versions
 *  If maxver is zero, forget all previous version and
 *  truncate the temporary file.
 */
combine(svname)
char    *svname;
{
	FILE    *sfp, *fopen();
	FILE    *tfp;
	int     comb;
	char    *c;
	struct  version *v, *sv;

        sfp = fopen(svname, "w");
        fprintf(sfp, "%c%c %d\n", CNTRLCHAR, NVERSIONS, maxver);
        if (maxver > 1) {
                /*
                 * combine some of the oldest versions
                 */
                comb = nver - maxver + 2;
                v = verhdr;
                while (comb--) {
                        getcmd(v);
                        if (comb)
                                v = v->v_next;
                }
                sv = v->v_next;
                v->v_next = NULL;
                c = v->v_sptr;
                while (*c == CNTRLCHAR && c < v->v_eptr) {
                        fprintf(sfp, "%s\n", c);
                        c += strlen(c) + 1;
                }
                /*
                 * Combine them
                 */
                fprintf(sfp, "a0\n");
                feed(verhdr, "", sfp);
                fprintf(sfp, ".\n%c%c\n", CNTRLCHAR, ENDVER);

                for (v = sv; v != NULL; v = v->v_next)
                        for (c = v->v_sptr; c <= v->v_eptr; c += strlen(c)+1)
                                fprintf(sfp, "%s\n", c);
        } else {                /* keep only the new version */
                tfp = fopen(tmp, "w");
                fclose(tfp);
        }
	fclose(sfp);
}
/*
 *  addver - add a version to a savefile
 */
addver(name, svname, vfp)
char    *name;
char    *svname;
FILE    *vfp;
{
	char    cmd[100], buff[MAXLINE];
	FILE    *pfp, *popen();
	FILE    *sfp, *fopen();
	FILE    *tfp;
	int     fd;
	int     c;

	mktemp(tmp2);
	fd = creat(tmp2, 0600);
	close(fd);
	sprintf(cmd, "diff -f %s - > %s", tmp, tmp2);
	pfp = popen(cmd, "w");
	while (fgets(buff, MAXLINE, vfp) != NULL) {
		if (buff[0] == CNTRLCHAR || buff[0] == PERIOD)
			putc(CNTRLCHAR, pfp);
		fprintf(pfp, "%s", buff);
	}
	pclose(pfp);
	tfp = fopen(tmp2, "r");
	/*
	 *  If there are no differences in this version, don't save
	 *  it unless the -f flag is given
	 */
	if (((c = getc(tfp)) != EOF) || fflg) {
                sfp = fopen(svname, "a");
                getcmt(sfp);
		while (c != EOF) {
                        putc(c, sfp);
		        c = getc(tfp);
		}
                fprintf(sfp, "%c%c\n", CNTRLCHAR, ENDVER);
                fclose(sfp);
	} else
		fprintf(stderr, "%s: %s: no changes\n", cmdname, name);
	die = 1;
	fclose(tfp);
        unlink(tmp);
	unlink(tmp2);
}
/*
 * feed - feed a line to the version applier
 * If no more versions, then output the line
 */
feed(v, line, ofp)
struct  version *v;
char    *line;
FILE    *ofp;
{
	if (v != NULL)
		ver(v, line, ofp);
	else
		fprintf(ofp, "%s", line);
}
