#include <stdio.h>

/*
 *  define buffer for standard output
 */

int     errors;                 /* count of errors detected */

/*
 * Main routine.
 *
 * The following flags are processed:
 *      none, yet.
 */
main(argc, argv)
int argc;
char **argv;
{
        /*
         * process option parameters
         */
        argc--;  /* skip command name argument */
        argv++;
        while (argc>0 && argv[0][0] =='-' && argv[0][1] !='\0') {
                switch(argv[0][1]) {
			default:
                                error(1,"invalid option %s",*argv);
			}
		++argv;
		--argc;
        }

	if (argc > 0)
		freopen(*argv, "r", stdin);


        /*
         *  Initialization complete; process commands.
         */
        errors = 0;
	yyparse();

        /*
         * Generate to configuration if input successful
         */
        if (errors != 0)
                error(1,"configuration not generated due to errors");
        else {
                genspec();
                gendirs();
                genconf();
                genmtab();
		geniotab();
		genheader();
                genconfigs();
                genmount();
                genspool();
        }
}

/*
 * All-purpose error routine.
 * Basically we just do a fprintf to stderr
 * A non-zero level indicates the error is fatal, program aborts.
 */
/* VARARGS */
error(level, arglist)
int level;
char *arglist;
{
        fflush(stdout);         /* synchronize stdout */
        errors += 1;
	fprintf(stderr, "%r", &arglist);
	putc('\n', stderr);
	if (level)
                exit(level);
}

