#
/*
 *              C compiler, part 2
 */

#include "c1.h"

#define	dbprint(op)	/**/

char    maprel[] {      EQUAL, NEQUAL, GREATEQ, GREAT, LESSEQ,
			LESS, GREATQP, GREATP, LESSEQP, LESSP
};

char    notrel[] {      NEQUAL, EQUAL, GREAT, GREATEQ, LESS,
			LESSEQ, GREATP, GREATQP, LESSP, LESSEQP
};

struct tconst czero { CON, INT, 0};
struct tconst cone  { CON, INT, 1};

struct tname sfuncr { NAME, STRUCT, STATIC, 0, 0, 0 };

struct table   *cregtab;

int     nreg    HIGHREG;
int     isn     10000;

main(argc, argv)
char *argv[];
{
	char *buf;

	dup2(1, 2);     /* send errors to standard output */
	if (argc<4) {
		error("Arg count");
		exit(1);
	}
	if((ascfp = fopen(argv[1], "r")) == NULL) {
		error("Missing temp file");
		exit(1);
	}
	if (freopen(argv[3], "w", stdout) == NULL) {
		error("Can't create %s", argv[3]);
		exit(1);
	}

	/* must get buffer storage before using sbrk */
	setbuf(stdout, malloc(BUFSIZ));
	buf = malloc(BUFSIZ);
	setbuf(ascfp, buf);
	funcbase = curbase = coremax = sbrk(0);
	getree();

	/* if any floats were used then generate the temporaries
	 * used in float->int and int->float conversions
	 */
	if (nfloat) {
		printf("cnop\t0,8\n");
		printf(".data\n");
		printf("$ftc:\n");
		printf("dc xl8'4E00000000000000'\n");
		printf("$ftp:\n");
		printf("dc xl8'0000000000000000'\n");
		printf(".text\n");
	}

	/*
	 * tack on the string file.
	 */
	fclose(ascfp);
	if ((ascfp = fopen(argv[2], "r")) == NULL) {
		error("Missing temp file");
		exit(1);
	}
	setbuf(ascfp, buf);
	printf(".data\n");
	getree();
	exit(nerror!=0);
}

/*
 * Given a tree, a code table, and a
 * count of available registers, find the code table
 * for the appropriate operator such that the operands
 * are of the right type and the number of registers
 * required is not too large.
 * Return a ptr to the table entry or 0 if none found.
 */

char *
match(atree, table, nrleft)
struct tnode *atree;
struct table *table;
{
	int op, d1, d2, dope, counter;
	struct tnode *p2;
	register struct tnode *p1, *tree;
	register struct optab *opt;

	if ((tree=atree)==0)
		return(0);
	if (table==lsptab)
		table = sptab;
	if ((op = tree->op)==0)
		return(0);
	dope = opdope[op];
	if ((dope&LEAF) == 0)
		p1 = tree->tr1;
	else
		p1 = tree;
	d1 = dcalc(p1, nrleft);
	if ((dope&BINARY)!=0) {
		p2 = tree->tr2;
		/*
		 * If a subtree starts off with a conversion operator,
		 * try for a match with the conversion eliminated.
		 */
		if (opdope[p1->op]&CNVRT && (opdope[p2->op]&CNVRT)==0
		 && p1->class!=REG && p2->class!=REG
		 && p1->type!=DOUBLE && p2->type!=DOUBLE
		 && p1->type!=FLOAT && p2->type!=FLOAT
		 && (opdope[p1->tr1->op]&CNVRT)==0) {
			tree->tr1 = p1->tr1;
			if (opt = match(tree, table, nrleft))
				return(opt);
			tree->tr1 = p1;
		} else if (opdope[p2->op]&CNVRT && (opdope[p1->op]&CNVRT)==0
		         && p1->class!=REG && p2->class!=REG
		         && p1->type!=DOUBLE && p2->type!=DOUBLE
		         && p1->type!=FLOAT && p2->type!=FLOAT
			 && (opdope[p2->tr1->op]&CNVRT)==0) {
			tree->tr2 = p2->tr1;
			if (opt = match(tree, table, nrleft))
				return(opt);
			tree->tr2 = p2;
		}
		d2 = dcalc(p2, nrleft);
	}
	for (; table->op!=op; table++)
		if (table->op==0)
			return(0);

	for (opt = table->tabp; opt->tabdeg1!=0; opt++) {
		counter++;
/*
 * the following code has been changed to correct an original "bug"
 *	before "%a*,n" wouldn't match, but that didn't matter since a*
 *	is also a on the 11 thanks to decent addressing modes
 */
		if (opt->tabdeg1 >= 0100){
			if (p1->op != STAR) continue;
			if (dcalc(p1->tr1, nrleft) > (opt->tabdeg1&077))
				continue;
		}
		else if (d1 > (opt->tabdeg1&077)) continue;
		if (notcompat(p1, opt->tabtyp1, op)) {
			continue;
		}
		if ((opdope[op]&BINARY)!=0 && p2!=0) {
			if (opt->tabdeg2 >= 0100){
				if (p2->op != STAR) continue;
				if (dcalc(p2->tr1, nrleft) > (opt->tabdeg2&077))
					continue;
			}
			else if (d2 > (opt->tabdeg2&077)) continue;
			if (notcompat(p2,opt->tabtyp2, 0))
				continue;
		}

                return(opt);
	}

	return(0);
}

/*
 * Given a tree, a code table, and a register,
 * produce code to evaluate the tree with the appropriate table.
 * Registers reg and up can be used.
 * If there is a value, it is desired that it appear in reg.
 * The routine returns the register in which the value actually appears.
 * This routine must work or there is an error.
 * If the table called for is cctab, sptab, or efftab,
 * and tree can't be done using the called-for table,
 * another try is made.
 * If the tree can't be compiled using cctab, regtab is
 * used and a "ltr" instruction is produced.
 * If the tree can't be compiled using sptab,
 * regtab is used and the register is pushed on the stack.
 * If the tree can't be compiled using efftab,
 * just use regtab.
 * Regtab must succeed or an "op not found" error results.
 *
 * A number of special cases are recognized, and
 * there is an interaction with the optimizer routines.
 */
rcexpr(atree, atable, reg)
struct tnode *atree;
struct table *atable;
{
	register r;
	int modf, nargs, recurf, savestk, strucsize;
	register struct tnode *tree;
	register struct table *table;

	table = atable;
	recurf = 0;
        if (reg<0) {
		recurf++;
		reg = ~reg;
		if (reg>=020) {
			reg =- 020;
			recurf++;
		}
	}
again:
	if ((tree = atree) == 0 || tree->op == 0)
		return(0);
	if (table == NOTAB) {
		/*
		 * storing a register variable onto the argument stack
		 */
		r = reg;
		goto fixup;
	}
	/*
	 * fieldselect(...) : in efftab mode,
	 * ignore the select, otherwise
	 * do the shift and mask.
	 */
	if (tree->op == FSELT) {
		if (table==efftab)
			atree = tree = tree->tr1;
		else {
			tree->op = FSEL;
			atree = tree = optim(tree);
		}
	}
	switch (tree->op)  {
	/*
	 * Structure assignments
	 */
	case STRASG:
		strasg(tree);
		return(0);

	/*
	 * An initializing expression
	 */
	case INIT:
		initflg++;
		tree = optim(tree);
		doinit(tree->type, tree->tr1);
		--initflg;
		return(0);

	/*
	 * Put the value of an expression in r0,
	 * for a switch or a return
	 */
	case RFORCE:
		tree = tree->tr1;
		if ((r=rcexpr(tree, regtab, reg)) != 0)
			movreg(r, 0, tree);
		return(0);

	/*
	 * sequential execution
	 */
	case SEQNC:
		rcexpr(tree->tr1, efftab, reg);
		atree = tree = tree->tr2;
		goto again;

	/*
	 * Handle a subroutine call. It has to be done
	 * here because if cexpr got called twice, the
	 * arguments might be compiled twice.
	 */
	case CALL:
		if (tree->type==STRUCT || tree->type==STRUCT+PTR)
			strucsize = rtrnsize;
		else
			strucsize = 0;
		r = 0;
		nargs = 0;
		modf = 0;
		if (tree->tr1->op == STAR)
			tree->tr1 = tree->tr1->tr1;
		if (tree->tr1->op!=NAME || tree->tr1->class!=EXTERN) {
			nargs++;
			nstack++;
		}
		tree = tree->tr2;
		savestk = stksize;
		if(tree->op) {
/*
 * argument tree must be searched left-to-right on 470
 * so we go recursive ... note that nargs isn't kept up
 * but that's OK, we don't need it anyway!
 */
			while (tree->op == COMMA){
				if (tree->tr2->type == STRUCT)
					r =+ ((tree->tr2->mask+ALIGN) & ~ALIGN);
				else
				        r =+ arlength(tree->tr2->type);
				tree = tree->tr1;
			}
			if (tree->type == STRUCT)
				r =+ ((tree->mask+ALIGN) & ~ALIGN);
			else
			        r =+ arlength(tree->type);
			if (strucsize > r)
				r = strucsize;
			if (r){
				printf("s\t%d,=f'%d'\n", STKP, r);
				dropsize =+ r;
	                        if (dropsize > 4095)
			                error("stack offset exceeds 4096");
				stksize = 0;
				comarg(atree->tr2);
			}
		}
		else if (strucsize) {
				r = strucsize;
				printf("s\t%d,=f'%d'\n", STKP, r);
				dropsize =+ r;
	                        if (dropsize > 4095)
			                error("stack offset exceeds 4096");
				stksize = 0;
		}
		tree = atree;
		tree->op = CALL2;
		if (tree->tr1->op==NAME && tree->tr1->class==EXTERN)
			tree->op = CALL1;
		if (cexpr(tree, regtab, reg)<0)
			error("compiler botch: call");
/*
 * pop goes the weasel stack
 */
		if (r) printf("la\t%d,%d(%d)\n", STKP, r, STKP);
		nstack =- nargs;
		dropsize =- r;
		stksize = savestk;

		if (strucsize)
			/*
			 * we're compiling a call to a function which returns a structure
			 */
			printf("lr\t2,0\n");

	        if (table==efftab || table==regtab)
		        return(0);
		r = 0;
		goto fixup;

	/*
	 * Longs need special treatment.
	 */
	case ASLSH:
	case ASRSH:
	case LSHIFT:
	case RSHIFT:
		if (tree->type==LONG || tree->type==UNLNG) {
	/*
			if (tree->tr2->op==ITOL)
				tree->tr2 = tree->tr2->tr1;
			else
				tree->tr2 = optim(tnode(LTOI,INT,tree->tr2));
			if (tree->op==ASLSH || tree->op==ASRSH)
				tree->op = ASLSHL;
			else
				tree->op = LLSHIFT;
	 */
		}
		break;

	/*
	 * Try to change * to shift.
	 */
	case TIMES:
	case ASTIMES:
		tree = pow2(tree);
		break;

	/*
	 * we must check for &reg errors here because
	 * pname doesn't pick them up on 470
	 */
	case AMPER:
		if (tree->tr1->op==NAME && tree->tr1->class==REG)
			regerr();
		break;

	}
	/*
	 * Try to find postfix ++ and -- operators that can be
	 * pulled out and done after the rest of the expression
	 */
	if (table!=cctab && table!=cregtab && recurf<2
	 && (opdope[tree->op]&LEAF)==0) {
		if (r=delay(&atree, table, reg)) {
			tree = atree;
			table = efftab;
			reg = r-1;
		}
	}
	/*
	 * Basically, try to reorder the computation
	 * so  reg = x+y  is done as  reg = x; reg =+ y
	 */
	if (recurf==0 && reorder(&atree, table, reg)) {
		if (table==cctab && atree->op==NAME)
			return(reg);
	}
	tree = atree;
	if (table==efftab && tree->op==NAME)
		return(reg);
	if ((tree->type&TYPE)==LONG ||
            (tree->type&TYPE)==UNLNG) {
	        if ((r=cexpr(tree, lngtab, reg))>=0)
		        goto fixup;
		else if ((r=cexpr(tree, table, reg))>=0)
			return(r);
		else if (table!=cctab||(opdope[tree->op]&RELAT)==0)
			if ((r=cexpr(tree, regtab, reg))>=0)
		                goto fixup;
	}
	else {
		if ((r=cexpr(tree, table, reg))>=0)
			return(r);
		if (table!=regtab && (table!=cctab||(opdope[tree->op]&RELAT)==0)) {
			if((r=cexpr(tree, regtab, reg))>=0) {
		fixup:
				modf = isfloat(tree);
			        if (stksize > 4095)
				        error("stack size exceeds 4096");
				if (table==sptab || table==lsptab) {
					if (tree->type==LONG || tree->type==UNLNG) {
			                        if ((stksize+4) > 4095)
				                        error("stack size exceeds 4096");
						printf("stm\t%d,%d,%d(%d)\n", r, r+1,
							stksize, STKP);
						nstack++;
					}
					else if (modf)
						printf("std\t%d,%d(%d)\n", (r==0) ? 0 : 2*(r-1),
							stksize, STKP);
					else printf("st\t%d,%d(%d)\n", r, stksize, STKP);
					nstack++;
				}
				if (table == NOTAB)
					printf("st\t%d,%d(%d)\n", r, stksize, STKP);
				if (table==cctab) {
					if (modf) printf("lt%cr\t%d,%d\n", modf, r, r);
					else printf("ltr\t%d,%d\n", r, r);
					}
				return(r);
			}
		}
	        /*
	         * There's a last chance for this operator
	         */
	        if (tree->op==LTOI) {
	                r = rcexpr(tree->tr1, lngtab, reg);
	                if (r >= 0) {
		                r++;
		                goto fixup;
	                }
	        }
	}
	if (tree->type == STRUCT)
		error("Illegal operation on structure");
	else if (tree->op>0 && tree->op<RFORCE && opntab[tree->op])
		error("No code table for op: %s", opntab[tree->op]);
	else
		error("No code table for op %d", tree->op);
	return(reg);
}

/*
 * Try to compile the tree with the code table using
 * registers areg and up.  If successful,
 * return the register where the value actually ended up.
 * If unsuccessful, return -1.
 *
 * Most of the work is the macro-expansion of the
 * code table.
 */
cexpr(atree, table, areg)
struct tnode *atree;
struct table *table;
{
	int c, r, savetmp;
	register struct tnode *p, *p1, *tree;
	struct table *ctable;
	struct tnode *p2;
	char *string;
	int reg, reg1, rreg, flag, opd;
	char *opt;
	static int charasg = 0;

	tree = atree;
	reg = areg;
	p1 = tree->tr2;
	c = tree->op;
	opd = opdope[c];
	/*
	 * When the value of a relational or a logical expression is
	 * desired, more work must be done.
	 */
	if ((opd&RELAT||c==LOGAND||c==LOGOR||c==EXCLA) &&
             (tree->tr1->type!=(LONG+PTR)) &&
/* compiler looped on this one if(l) */
             table!=cctab) {
		cbranch(tree, c=isn++, 1, reg);
		rcexpr(&czero, table, reg);
		branch(isn, 0);
		label(c, 0);
		rcexpr(&cone, table, reg);
		label(isn++, 0);
		return(reg);
	}
	if(c==QUEST) {
		if (table==cctab)
			return(-1);
		cbranch(tree->tr1, c=isn++, 0, reg);
		flag = nstack;
		rreg = rcexpr(p1->tr1, table, reg);
		if (rreg == 0) {
			movreg(rreg, reg, tree->tr2);
			rreg = reg;
		}
		nstack = flag;
		branch(r=isn++, 0);
		label(c, 0);
		reg = rcexpr(p1->tr2, table, rreg);
		if (rreg!=reg)
			movreg(reg, rreg, tree->tr2);
		label(r, 0);
		return(rreg);
	}
	reg = oddreg(tree, reg);
	reg1 = reg+1;
	/*
	 * long values take 2 registers.
	 */
	if ((tree->type==LONG || tree->type==UNLNG ||
            (opd&RELAT&&(tree->tr1->type==LONG ||
                         tree->tr1->type==UNLNG))) &&
             tree->op!=ITOL)
		reg1++;
	/*
	 * Leaves of the expression tree
	 */
	if ((r = chkleaf(tree, table, reg)) >= 0)
		return(r);
	/*
	 * x + (-1) is better done as x-1.
	 */

	if ((tree->op==PLUS||tree->op==ASPLUS) &&
	    (p1=tree->tr2)->op == CON && p1->value == -1) {
		p1->value = 1;
		tree->op =+ (MINUS-PLUS);
	}
	if (table==cregtab)
		table = regtab;
	/*
	 * The following peculiar code depends on the fact that
	 * if you just want the condition codes set, efftab
	 * will generate the right code unless the operator is
	 * postfix ++ or --. Unravelled, if the table is
	 * cctab and the operator is not special, try first
	 * for efftab;  if the table isn't, if the operator is,
	 * or the first match fails, try to match
	 * with the table actually asked for.
	 */
	r = nreg - reg;
	if (table!=cctab || c==INCAFT || c==DECAFT || (tree->type&TYPE)==LONG
	 || (tree->type&TYPE)==UNLNG || (opt = match(tree, efftab, r)) == 0)
		if ((opt=match(tree, table, r))==0)
			return(-1);
	string = opt->tabstring;
	p1 = tree->tr1;
	if (p1->op==FCON)
		printf(".data\n%cS%d:\ndc x'%8x%8x'\n.text\n",
			TMPLAB, p1->value, p1->fvalue);
	p2 = 0;
	if (opdope[tree->op]&BINARY) {
		p2 = tree->tr2;
		if (p2->op==FCON)
			printf(".data\n%cS%d:\ndc x'%8x%8x'\n.text\n",
				TMPLAB, p2->value, p2->fvalue);
	}
loop:
	/*
	 * The 0200 bit asks for a tab.
	 */
	if ((c = *string++) & 0200) {
		c =& 0177;
		putchar('\t');
	}
	switch (c) {

	case '\n':
		dbprint(tree->op);
		break;

	case '\0':
		if (!isfloat(tree))
			if (tree->op==DIVIDE||tree->op==ASDIV||tree->op==PTOI)
				reg++;
		return(reg);

	case '?':
		/*
		 * character to charater assignment - produce
		 * length for 'mvc' operation
		 */
		charasg = 1;
		goto loop;

	/* A1 */
	case 'A':
		p = p1;
		goto adr;

	/* A2 */
	case 'B':
		p = p2;
		goto adr;

	adr:
		c = 0;
		while (*string=='<') {
			c++;
			string++;
		}
		if (*string=='+') {
			c = 100;
			string++;
		}
		if (charasg) {
			charasg = 0;
			pname(p, -1);
		}
		else
		        pname(p, c);
		goto loop;

	/* I */
	case 'M':
		if ((c = *string)=='<')
			string++;
		else
			c = 0;
		prins(tree->op, tree->type, c, instab);
		goto loop;

	/* B1 */
	case 'C':
		if ((opd&LEAF) != 0)
			p = tree;
		else
			p = p1;
		goto pbyte;

	/* BF */
	case 'P':
		p = tree;
		goto pb1;

	/* BH */
	case 'W':
		p = tree;
		goto pb1;

	/* B2 */
	case 'D':
		p = p2;
	pbyte:
		if (p->type==CHAR)
			putchar(BYTENAME);
	pb1:
		if (p->type==SHORT || p->type==UNSHRT)
			putchar(HALFNAME);
		if (isfloat(p))
			putchar(isfloat(p));
		goto loop;

	/* Q1 */
	case 'Q':
		if ((opd&LEAF) != 0)
			p = tree;
		else
			p = p1;
	  shrtl:
		if (p->type == UNSHRT || (tree->op==STOL && tree->type==UNLNG))
			putchar('n');
		else
			while ((c = *string++) != '\n')
				;
		goto loop;

	/* Q2 */
	case 'L':
		p = p2;
		goto shrtl;

	/* QH */
	case '@':
		p = tree;
		goto shrtl;

	/* C1 */
	case 'E':
		printf("%d", p1->value);
		goto loop;

	/* C2 */
	case 'F':
		printf("%d", p2->value);
		goto loop;

	/* HX1 */
	case 'y':
		printf("%02.2x", (char) p1->value);
		goto loop;

	/* HX2 */
	case 'z':
		printf("%02.2x", (char) p2->value);
		goto loop;

	/* F */
	case 'G':
		p = p1;
		flag = 01;
		goto subtre;

	/* S */
	case 'K':
		p = p2;
		flag = 02;
		goto subtre;

	/* H */
	case 'H':
		p = tree;
		flag = 04;

	subtre:
		ctable = regtab;
		if (flag&04)
			ctable = cregtab;
		c = *string++ - 'A';
		if (*string=='!') {
			string++;
			c =| 020;       /* force right register */
		}
		if ((c&01)!=0) {
			p = p->tr1;
			if(collcon(p) && ctable!=sptab) {
				if (p->op==STAR)
					p = p->tr1;
				p = p->tr1;
			}
		}
		if ((c&02)!=0){
			savetmp = tmp;
			tmp = arlength(p->type);
			rreg = rcexpr(p, regtab, areg);
                        if ((tmpoff+dropsize+SAVEAREA) > 4095)
                                error("stack offset exceeds 4096");
			if (isfloat(p))
				printf("st%c\t%d,%d(%d)\n", isfloat(p), (rreg==0) ? 0 : 2*(rreg-1),
					tmpoff+dropsize+SAVEAREA, STKP);
			else if (p->type==LONG || p->type==UNLNG) {
                                if ((4+tmpoff+dropsize+SAVEAREA) > 4095)
                                        error("stack offset exceeds 4096");
				printf("stm\t%d,%d,%d(%d)\n", rreg, rreg+1,
					tmpoff+dropsize+SAVEAREA, STKP);
			}
			else printf("st\t%d,%d(%d)\n", rreg,
				tmpoff+dropsize+SAVEAREA, STKP);
			tmpoff =+ tmp;
			if (tmpoff > maxtmp) maxtmp = tmpoff;
			goto loop;
		}
		if ((c&04)!=0)
			ctable = cctab;
		if ((flag&01) && ctable==regtab && (c&01)==0
		  && (tree->op==DIVIDE||tree->op==MOD
		   || tree->op==ASDIV||tree->op==ASMOD))
			ctable = cregtab;
		if (table==lsptab && ctable==sptab)
			ctable = lsptab;
		if (c&010)
			r = reg1;
		else
			if (opdope[p->op]&LEAF || p->degree < 2)
				r = reg;
			else
				r = areg;
		rreg = rcexpr(p, ctable, r);
		if (ctable!=regtab && ctable!=cregtab)
			goto loop;
		if (c&010) {
			if (c&020 && rreg!=reg1)
				movreg(rreg, reg1, p);
			else
				reg1 = rreg;
		}
		else if (rreg!=reg)

			/*
			 * this ridiculously long if clause checks the
			 * conditions that determine whether the current
			 * register can be different than was asked for
			 *
			 * note that reg1 can't be used when this is allowed
			 */

			if ((c&020)==0 && (c&01)==0 && oddreg(tree, 0)==0 &&
			  tree->type!=LONG && tree->type!=UNLNG && (flag&04 ||
			  flag&01&&xdcalc(p2,nreg-rreg-1)<=(opt->tabdeg2&077) ||
			  flag&02&&xdcalc(p1,nreg-rreg-1)<=(opt->tabdeg1&077))){
				reg = rreg;
				reg1 = 99;
			} else
				movreg(rreg, reg, p);
		goto loop;

	/* FR */
	case 'Y':
		if (*string == '1') {
			string++;
			r = reg1;
		}
		else
			r = reg;
		if (r != 0) r = 2*(r-1);
		if (r > HIGHFLTREG)
			error("Register overflow: simplify expression");
		printf("%d", r);
		goto loop;

	/* R */
	case 'I':
		r = reg;
		if (*string=='-') {
			string++;
			r--;
		}
		goto preg;

	/* R1 */
	case 'J':
		r = reg1;
	preg:
		if (*string=='+') {
			string++;
			r++;
		}
		if (r > nreg)
			error("Register overflow: simplify expression");
		printf("%d", r);
		goto loop;

	/* #1 */
	case '#':
		/*
		 * matches pointer as first operand
		 * compiled into register
		 */
		p = p1->tr1;
		goto nmbr;

	/* #2 */
	case '"':
		/*
		 * matches pointer as second operand
		 * compiled into register
		 */
		p = p2->tr1;
		goto nmbr;

	case '~':
		p = p1;

	nmbr:
		if(collcon(p)) {
			if ((p = p->tr2)->op == CON) {
				printf("%d", p->value);
			} else if (p->op==AMPER)
				pname(p->tr1, 0);
		} else putchar('0');
		goto loop;

	/*
	 * pop a temporary from the stack
	 * note that the temporary is freed after use
	 * hence it can only be used once per code table entry
	 */
	case 'O':
		tmpoff =- tmp;
		printf("%d(%d)", tmpoff+dropsize+SAVEAREA, STKP);
		tmp = savetmp;
		goto loop;

	/*
	 * Certain adjustments for / % and PTOI
	 */
	case 'T':
		if (p1->type==UNSIGN || p1->type==UNSHRT || p1->type&XTYPE) {
			printf("srdl");
			goto loop;
		} else printf("srda");
		goto loop;

	/*
	 * a fudge for unsigned comparisons
	 * I'm very lazy
	 */
	case 'U':
		if (p1->type==UNSIGN || p2->type==UNSIGN ||
		    p1->type==UNSHRT || p2->type==UNSHRT ||
		    p1->type==UNLNG || p2->type==UNLNG ||
		    (p1->type&PTR) || (p2->type&PTR))
			putchar('l');
		goto loop;

	case 'V':
		switch(tree->op) {
		case PLUS:
		case ASPLUS:
		case INCBEF:
		case INCAFT:
			printf("bc\t12,");
			break;

		case MINUS:
		case ASMINUS:
		case NEG:
		case ITOL:
		case DECBEF:
		case DECAFT:
			printf("bc\t3,");
			break;

		default:
			while ((c = *string++)!='\n' && c!='\0');
			break;
		}
		goto loop;

	/*
	 * ZW - Mask used in field assignments
	 */
	case 'Z':
		printf("=x'%8x'", ~(tree->mask));
		goto loop;

	/*
	 * ZS - Mask used in short field assignments
	 */
	case 'N':
		printf("=x'%4x'", ~(tree->mask));
		goto loop;

	/*
	 * ZB - Mask used in byte field assignments
	 */
	case '|':
		printf("=x'%2x'", ~(tree->mask));
		goto loop;

	/*
	 * Relational on long values.
	 * Might bug out early. E.g.,
	 * (long<0) can be determined with only 1 test.
	 */
	case 'X':
		if (xlongrel(*string++ - '0'))
			return(reg);
		goto loop;
	}
	putchar(c);
	goto loop;
}

/*
 * This routine just calls sreorder (below)
 * on the subtrees and then on the tree itself.
 * It returns non-zero if anything changed.
 */
reorder(treep, table, reg)
struct tnode **treep;
struct table *table;
{
	register r, o;
	register struct tnode *p;

	p = *treep;
	o = p->op;
	if (opdope[o]&LEAF || o==LOGOR || o==LOGAND)
		return(0);
	if ((p->type&TYPE)==LONG || (p->type&TYPE)==UNLNG) {
	        while(sreorder(&p->tr1, lngtab, reg, 1))
		        ;
	        if (opdope[o]&BINARY)
		        while(sreorder(&p->tr2, lngtab, reg, 1))
			        ;
	}
	else {
	        while(sreorder(&p->tr1, regtab, reg, 1))
		        ;
	        if (opdope[o]&BINARY)
		        while(sreorder(&p->tr2, regtab, reg, 1))
			        ;
	}
	r = 0;
	if (table!=cctab)
	while (sreorder(treep, table, reg, 0))
		r++;
	*treep = optim(*treep);
	return(r);
}

/*
 * Basically this routine carries out two kinds of optimization.
 * First, it observes that "x + (reg = y)" where actually
 * the = is any assignment op is better done as "reg=y; x+reg".
 * In this case rcexpr is called to do the first part and the
 * tree is modified so the name of the register
 * replaces the assignment.
 * Moreover, expressions like "reg = x+y" are best done as
 * "reg = x; reg =+ y" (so long as "reg" and "y" are not the same!).
 */
sreorder(treep, table, reg, recurf)
struct tnode **treep;
struct table *table;
{
	register struct tnode *p, *p1;

	p = *treep;
	if (opdope[p->op]&LEAF)
		return(0);
	if (p->op==PLUS && recurf)
		if (reorder(&p->tr2, table, reg))
			*treep = p = optim(p);
	p1 = p->tr1;
	if (p->op==STAR || p->op==PLUS) {
		if (recurf && reorder(&p->tr1, table, reg))
			*treep = p = optim(p);
		p1 = p->tr1;
	}
	if (p1->op==NAME) switch(p->op) {
		case ASLSH:
		case ASRSH:
		case ASSIGN:
			if (p1->class != REG||p1->type==CHAR||isfloat(p->tr2))
				return(0);
			if (p->op==ASSIGN) switch (p->tr2->op) {
			case TIMES:
				if (!ispow2(p->tr2))
					break;
				p->tr2 = pow2(p->tr2);
			case PLUS:
			case MINUS:
			case AND:
			case ANDN:
			case OR:
			case EXOR:
			case LSHIFT:
			case RSHIFT:
				p1 = p->tr2->tr2;
				if (xdcalc(p1, 16) > 12
				 || p1->op==NAME
				 &&(p1->nloc==p->tr1->nloc
				  || p1->regno==p->tr1->nloc))
					return(0);
				p1 = p->tr2;
				p->tr2 = p1->tr1;
				if (p1->tr1->op!=NAME
				 || p1->tr1->class!=REG
				 || p1->tr1->nloc!=p->tr1->nloc) {
					if ((p->type&TYPE)==LONG || (p->type&TYPE)==UNLNG)
					        rcexpr(p, lngtab, reg);
					else
					        rcexpr(p, efftab, reg);
				}
				p->tr2 = p1->tr2;
				p->op = p1->op + ASPLUS - PLUS;
				*treep = p;
				return(1);
			}
			goto OK;

		case ASTIMES:
			if (!ispow2(p))
				return(0);
		case ASPLUS:
		case ASMINUS:
		case ASAND:
		case ASANDN:
		case ASOR:
		case ASXOR:
		case INCBEF:
		case DECBEF:
		OK:
			if (table==cctab||table==cregtab)
				reg =+ 020;
			rcexpr(optim(p), efftab, ~reg);
			*treep = p1;
			return(1);
	}
	return(0);
}

/*
 * Delay handles postfix ++ and --
 * It observes that "x + y++" is better
 * treated as "x + y; y++".
 * If the operator is ++ or -- itself,
 * it calls rcexpr to load the operand, letting
 * the calling instance of rcexpr to do the
 * ++ using efftab.
 * Otherwise it uses sdelay to search for inc/dec
 * among the operands.
 */
delay(treep, table, reg)
struct tnode **treep;
{
	register struct tnode *p, *p1;
	register r;

	p = *treep;
	if ((p->op==INCAFT||p->op==DECAFT)
	 && p->tr1->op==NAME) {
		return(1+rcexpr(p->tr1, table, reg));
	}
	p1 = 0;
	if (opdope[p->op]&BINARY) {
		if (p->op==LOGAND || p->op==LOGOR)
			return(0);
		p1 = sdelay(&p->tr2);
	}
	if (p1==0)
		p1 = sdelay(&p->tr1);
	if (p1) {
		r = rcexpr(optim(p), table, reg);
		*treep = p1;
		return(r+1);
	}
	return(0);
}

sdelay(ap)
struct tnode **ap;
{
	register struct tnode *p, *p1;

	p = *ap;
	if ((p->op==INCAFT||p->op==DECAFT) && p->tr1->op==NAME) {
		*ap = ncopy(p->tr1);
		return(p);
	}
	if (p->op==STAR || p->op==PLUS)
		if (p1=sdelay(&p->tr1))
			return(p1);
	if (p->op==PLUS)
		return(sdelay(&p->tr2));
	return(0);
}

/*
 * Copy a tree node for a register variable.
 * Used by sdelay because if *reg-- is turned
 * into *reg; reg-- the *reg will in turn
 * be changed to some offset class, accidentally
 * modifying the reg--.
 */
ncopy(ap)
struct tname *ap;
{
	register struct tname *p, *q;

	p = ap;
	if (p->class!=REG)
		return(p);
	q = getblk(sizeof(*p));
	q->op = p->op;
	q->type = p->type;
	q->class = p->class;
	q->offset = p->offset;
	q->nloc = p->nloc;
	return(q);
}

/*
 * If the tree can be immediately loaded into a register,
 * produce code to do so and return success.
 */
chkleaf(atree, table, reg)
struct tnode *atree;
{
	struct tnode lbuf;
	register struct tnode *tree;

	tree = atree;
	if (dcalc(tree, nreg-reg) > DINT)
		return(-1);
	lbuf.op = LOAD;
	lbuf.type = tree->type;
	lbuf.degree = tree->degree;
	lbuf.tr1 = tree;
	return(rcexpr(&lbuf, table, reg));
}

/*
 * compile a whole tree of arguments
 * do it recursively to force left-to-right parameter evaluation
 * this bogosity is made possible by the comma operator
 */

comarg(tree)
struct tnode *tree;
{
	register r, s, nbytes, r1;

	if (tree->op == STRASG) {
		nbytes = tree->mask;
		tree = tree->tr1;
		tree = strfunc(tree);
		if (tree->op!=NAME && tree->op!=STAR) {
			error("Unimplemented structure assignment");
			return(0);
		}
		tree = tnode(AMPER, STRUCT+PTR, tree);
		tree = optim(tree);
		r1 = rcexpr(tree, regtab, LOWREG);
		if (r1 != LOWREG)
			printf("lr\t%d,%d\n", LOWREG, r1);
		if (stksize > 4095)
			error("stack size exceeds 4096");
		printf("la\t%d,%d(%d)\n", LOWREG+1, stksize, STKP);
		stackem(nbytes, LOWREG+1, LOWREG);
		stksize =+ ((nbytes+ALIGN) & ~ALIGN);
		r =+ ((nbytes+ALIGN) & ~ALIGN);
		return(r);
	}
	else if (tree->op == COMMA){
		r = comarg(tree->tr1);
		tree = tree->tr2;
		if (tree->op == STRASG) {
			r = comarg(tree);
			return(r);
		}
		if (tree->op==NAME && tree->class==REG)
		        rcexpr(tree, NOTAB, tree->nloc);
		else
		        rcexpr(tree, sptab, LOWREG);
		s = arlength(tree->type);
		stksize =+ s;
		r =+ s;
	}
	else {
		if (tree->op==NAME && tree->class==REG)
		        rcexpr(tree, NOTAB, tree->nloc);
		else
		        rcexpr(tree, sptab, LOWREG);
		r = arlength(tree->type);
		stksize =+ r;
	}
	return(r);
}

struct tnode *
strfunc(atp)
struct tnode *atp;
{
	register struct tnode *tp;

	tp = atp;
	if (tp->op != CALL)
		return(tp);
	setype(tp, STRUCT+PTR);
	return(tnode(STAR, STRUCT, tp));
}

/*
 * Compile an initializing expression
 */
doinit(atype, atree)
struct tnode *atree;
{
	register struct tnode *tree;
	register int type;
	register char *s;
	float sfval;
	double fval;
	LTYPE lval;

	tree = atree;
	type = atype;
	s = "dc f'%d'\n";
	if (type==CHAR) {
		s = "dc x'%2x'\n";
		if (tree->type&XTYPE)
			goto illinit;
		type = INT;
	}
	if (type&XTYPE)
		type = INT;
	switch (type) {
	case INT:
	case UNSIGN:
		if (tree->op==FTOI) {
			if (tree->tr1->op!=FCON && tree->tr1->op!=SFCON)
				goto illinit;
			tree = tree->tr1;
			tree->value = tree->fvalue;
			tree->op = CON;
		} else if (tree->op==LTOI) {
			if (tree->tr1->op!=LCON)
				goto illinit;
			tree = tree->tr1;
			lval = tree->lvalue;
			tree->op = CON;
			tree->value = lval;
		}
		if (tree->op == CON)
			printf(s, tree->value);
		else if (tree->op==AMPER) {
			printf("dc a(");
			pbase(tree = tree->tr1);
			if (type = tree->offset) printf("+%d)\n", type);
			else printf(")\n");
		} else
			goto illinit;
		return;

	case UNSHRT:
	case SHORT:
		if (tree->op==FTOS || tree->op==FTOUS) {
			if (tree->tr1->op!=FCON && tree->tr1->op!=SFCON)
				goto illinit;
			tree = tree->tr1;
			tree->value = tree->fvalue;
			tree->op = CON;
		}
		else if (tree->op==LTOS ||tree->op==LTOUS) {
			if (tree->tr1->op!=LCON)
				goto illinit;
			tree = tree->tr1;
			lval = tree->lvalue;
			tree->op = CON;
			tree->value = lval;
		}
		else if (tree->op==ITOS || tree->op==ITOUS) {
			tree = tree->tr1;
		}
		if (tree->op == CON) {
			if (type==SHORT && (tree->value>MAXSHORT || tree->value < -(MAXSHORT+1)))
				goto illinit;
                        if (type==UNSHRT && tree->value>MAXUNSHRT)
				goto illinit;
			printf("dc h'%d'\n", tree->value);
		}
		else if (tree->op==AMPER) {
			printf("dc a(");
			pbase(tree = tree->tr1);
			if (type = tree->offset) printf("+%d)\n", type);
			else printf(")\n");
		} else
			goto illinit;
		return;

	case DOUBLE:
	case FLOAT:
		if (tree->op==ITOF) {
			if (tree->tr1->op==CON) {
				fval = tree->tr1->value;
			} else
				goto illinit;
		} else if (tree->op==FCON || tree->op==SFCON)
			fval = tree->fvalue;
		else if (tree->op==LTOF) {
			if (tree->tr1->op!=LCON)
				goto illinit;
			fval = tree->tr1->lvalue;
		} else
			goto illinit;
		if (type==FLOAT) {
			sfval = fval;
			printf("dc x'%8x'\n", sfval);
		} else
			printf("dc xl8'%8x%8x'\n", fval);
		return;

	case UNLNG:
	case LONG:
		if (tree->op==FTOL) {
			tree = tree->tr1;
			if (tree->op==SFCON)
				tree->op = FCON;
			if (tree->op!= FCON)
				goto illinit;
			lval = tree->fvalue;
		} else if (tree->op==ITOL) {
			if (tree->tr1->op != CON)
				goto illinit;
			if (type == UNLNG)
			        lval = tree->tr1->value;
			else
			        lval = tree->tr1->value;
		} else if (tree->op==LTOUL) {
		        if (tree->tr1->op==LCON)
			        lval = tree->tr1->lvalue;
			else if (tree->tr1->op != CON)
				goto illinit;
			else
			        lval = tree->tr1->value;
		} else if (tree->op==LCON)
			lval = tree->lvalue;
		else
			goto illinit;
		printf("dc xl8'%8x%8x'\n", lval);
		return;
	}
illinit:
	error("Illegal initialization");
}

movreg(r1, r0, tree)
struct tnode *tree;
{
	register char *s;
	register i;

	if (r0==r1)
		return;
	if (tree->type==LONG || tree->type==UNLNG) {
		s = "lr\t%d,%d\nlr\t%d,%d\n";
		if (r0 < r1)
			printf(s, r0+1,r1+1,r0,r1);
		else
			printf(s, r0,r1,r0+1,r1+1);
		return;
	}
	if ((i = isfloat(tree)) == 0) printf("lr\t%d,%d\n", r0, r1);
	else printf("l%cr\t%d,%d\n", i, r0, (r1==0) ? 0 : 2*(r1-1));
}

strasg(atp)
struct fasgn *atp;
{
	register struct tnode *tp;
	register nwords, nbytes;
	int i, diff, reg;

	nbytes = atp->mask;
	rtrnsize = (nbytes+ALIGN) & ~ALIGN;
	tp = atp->tr1;
	if (tp->op != ASSIGN) {
		if (tp->op==RFORCE) {	/* function return */

		        /*
		         * get the appropriate addresses
			 */
			if (tp->tr1->op==CALL || tp->tr1->op==CALL1 || tp->tr1->op==CALL2 || tp->tr1->op==MCALL)
				rcexpr(tp->tr1, regtab, LOWREG);
			else {
			        tp = tnode(AMPER, STRUCT+PTR, tp->tr1);
		                rcexpr(tp, regtab, LOWREG);
			}
		        printf("la\t%d,$len%d(%d)\n", LOWREG+1, fnum, STKP);
			stackem(nbytes, LOWREG+1, LOWREG);
		        printf("la\t0,$len%d(%d)\n", fnum, STKP);
			return;
		}
		if (tp->op==CALL || tp->op==CALL1 || tp->op==CALL2 || tp->op==MCALL) {
			rcexpr(tp, regtab, LOWREG);
			return;
		}
		if (tp->op == SEQNC) {
			rcexpr(tp, regtab, LOWREG);
			return;
		}
		error("Illegal structure operation");
		return;
	}
	tp->tr2 = strfunc(tp->tr2);
	if (nbytes==BPC)
		setype(tp, CHAR);
	else if (nbytes==BPS)
		setype(tp, SHORT);
	else if (nbytes==BPW)
		setype(tp, INT);
	else if (nbytes==BPL)
		setype(tp, LONG);
	else {
		if (tp->tr2->op == QUEST) {
                        /*
                         * check the operands of the COLON operator
                         */
			if ((tp->tr2->tr2->tr1->op!=NAME && tp->tr2->tr2->tr1->op!=STAR) ||
			   (tp->tr2->tr2->tr2->op!=NAME && tp->tr2->tr2->tr2->op!=STAR)) {
				error("unimplemented structure assignment");
				return;
			}
                }
		else if (tp->tr1->op!=NAME && tp->tr1->op!=STAR
		         || tp->tr2->op!=NAME && tp->tr2->op!=STAR) {
			        error("unimplemented structure assignment");
			        return;
		}
		if (tp->tr2->tr1->op == CALL || tp->tr2->tr1->op == MCALL ||
		    tp->tr2->tr1->op == CALL1 || tp->tr2->tr1->op == CALL2) {
			tp = tnode(STROP, INT, tp->tr1, tp->tr2->tr1);
			tp->tr1 = tnode(AMPER, STRUCT+PTR, tp->tr1);
		        reg = rcexpr(tp, regtab, LOWREG);
		}
		else {
			if (tp->tr2->tr1->op==SEQNC)
		                tp->tr2->tr1->tr2 = tnode(AMPER, STRUCT+PTR, tp->tr2->tr1->tr2);
			else if (tp->tr2->op!=QUEST)
		                tp->tr2 = tnode(AMPER, STRUCT+PTR, tp->tr2);
			if (tp->tr1->tr1->op==SEQNC)
		                tp->tr1 = tp->tr1->tr1;
			else if (tp->tr1->op!=QUEST)
		                tp->tr1 = tnode(AMPER, STRUCT+PTR, tp->tr1);

			tp = tnode(STROP, INT, tp->tr1, tp->tr2);
		        reg = rcexpr(tp, efftab, LOWREG);
		}
		stackem(nbytes, reg, reg+1);
		return;
	}
	rcexpr(tp, efftab, LOWREG);
}

setype(p, t)
register struct tnode *p;
register t;
{

	for (;; p = p->tr1) {
		p->type = t;
		if (p->op==AMPER)
			t = decref(t);
		else if (p->op==STAR)
			t = incref(t);
		else if (p->op==ASSIGN)
			setype(p->tr2, t);
		else if (p->op!=PLUS)
			break;
	}
}

stackem(nbytes, r1, r2)
int nbytes, r1, r2;
{
	register mult, diff, i, mvamt;

	mvamt = PAGESZE;
	if (nbytes <= 256)
		printf("mvc\t0(%d,%d),0(%d)\n", nbytes, r1, r2);
	else {
		mult = nbytes/256;
		diff = nbytes%256;
		if (nbytes <= mvamt) {
			for (i=0; i<mult; i++)
		                printf("mvc\t%d(256,%d),%d(%d)\n", i*256, r1, i*256, r2);
                        if (diff)
		                printf("mvc\t%d(%d,%d),%d(%d)\n", mult*256, diff, r1, mult*256, r2);
		}
		else {
	                printf("l\t1,=f'%d'\n", mult);
	                printf("%c%d:\n", TMPLAB, isn);
			printf("mvc\t0(256,%d),0(%d)\n", r1, r2);
			printf("la\t%d,256(%d)\n", r1, r1);
			printf("la\t%d,256(%d)\n", r2, r2);
	                printf("bct\t1,%c%d\n", TMPLAB, isn);
	               /*
	                *  put the stragglers on
	                */
			if (diff)
			        printf("mvc\t0(%d,%d),0(%d)\n", diff, r1, r2);
	                isn++;
		}
	}
}
