/
/ c code tables - compile to register
/
/ what wasn't in the "Tour" is that
/	F2, S2 mean don't put the result anywhere but in the desired R
/	this way returns from functions are moved from r0
/
/	T, and U are fudges for unsigned's
/		T is "srdl" for unsigned's, "srda" for normal operands
/		U is "l" for unsigned's and null for normal operands
/
/ the tables are aware that floating point registers are not saved
/ this means you can't compile two expressions into registers,
/	you have to put the first one on the stack
/

.data
regtab = .
	dc f'106';	dc a(cr106)	/ load
	dc f'16';	dc a(cr16)	/ field assignment
	dc f'27';	dc a(cr32)	/ autoi
	dc f'28';	dc a(cr71)	/ autod
	dc f'30';	dc a(cr70)	/ incbef
	dc f'31';	dc a(cr71)	/ decbef
	dc f'32';	dc a(cr32)	/ incaft
	dc f'33';	dc a(cr32)	/ decaft
	dc f'35';	dc a(cr35)	/ amper
	dc f'36';	dc a(cr36)	/ star - indirection
	dc f'37';	dc a(cr37)	/ negation
	dc f'38';	dc a(cr38)	/ complement
	dc f'98';	dc a(cr100)	/ call 1
	dc f'99';	dc a(cr100)	/ call 2
	dc f'100';	dc a(cr100)	/ call
	dc f'101';	dc a(cr100)	/ m call
	dc f'80';	dc a(cr80)	/ assign
	dc f'40';	dc a(cr40)	/ binary addition
	dc f'41';	dc a(cr40)	/ binary subtraction
	dc f'42';	dc a(cr42)	/ * times
	dc f'14';	dc a(cr43)	/ ptr->int
	dc f'43';	dc a(cr43)	/ / divide
	dc f'44';	dc a(cr43)	/ mod
	dc f'45';	dc a(cr46)	/ right shift
	dc f'46';	dc a(cr46)	/ left shift
	dc f'47';	dc a(cr47)	/ binary and
	dc f'48';	dc a(cr47)	/ binary or
	dc f'49';	dc a(cr47)	/ binary xor
	dc f'70';	dc a(cr70)	/ =+,
	dc f'71';	dc a(cr71)	/ =-,
	dc f'72';	dc a(cr72)	/ =*
	dc f'73';	dc a(cr73)	/ =/
	dc f'74';	dc a(cr74)	/ =mod
	dc f'75';	dc a(cr75)	/ =>>
	dc f'76';	dc a(cr75)	/ =<<
	dc f'77';	dc a(cr76)	/ =&
	dc f'78';	dc a(cr76)	/ =|
	dc f'79';	dc a(cr76)	/ =^
	dc f'102';	dc a(cr102)	/ goto
	dc f'109';	dc a(cr109)	/ int->char
	dc f'51';	dc a(cr51)	/ int->float
	dc f'52';	dc a(cr52)	/ float->int
	dc f'57';	dc a(cr57)	/ long->float
	dc f'111';	dc a(cr111)	/ float->short
	dc f'112';	dc a(cr112)	/ short->float
	dc f'113';	dc a(cr113)	/ long->short
	dc f'115';	dc a(cr115)	/ int->short
	dc f'116';	dc a(cr116)	/ short->int
	dc f'125';	dc a(cr125)	/ structure operation
	dc f'128';      dc a(cr128)     / int->unsigned short
	dc f'129';      dc a(cr129)     / unsigned short->int
	dc f'128';      dc a(cr111)     / float->unsigned short
	dc f'128';      dc a(cr112)     / unsigned short->float
	dc f'128';      dc a(cr113)     / long->unsigned short
	dc f'130';      dc a(cr111)     / float->unsigned short
	dc f'131';      dc a(cr112)     / unsigned short->float
	dc f'132';      dc a(cr113)     / long->unsigned short
	dc f'0'
.text

/
/ goto
/
cr102:
%r,n
	br	A1

%a,n
	b	A1

%n*,n
	F*
	b	#1(R)

/
/ function call
/
cr100:
%r,n
	lr	15,A1
	balr	14,15

%a,n
%a,nd
	l	15,A1
	balr	14,15

%n,n
%n,nd
	F
	lr	15,R
	balr	14,15

/
/ addressible
/
cr106:
%rb,n
%r,n
	lr	R,A1

%z,n
	sr	R,R

%zf,n
%zd,n
	sBFr	FR,FR

%ab,n
	sr	R,R
	ic	R,A1

%af,n
%ad,n
	lB1	FR,A1

%a,n
	lB1	R,A1
	Q1	R,=x'0000ffff'

/
/ field assign, value in reg.
/
cr16:
%r,r
	n	A1,ZW
	or	A1,A2
	lr	R,A1

%r,a
	n	A1,ZW
	o	A1,A2
	lr	R,A1

%r,n
	S
	n	A1,ZW
	or	A1,R
	lr	R,A1

%a,r
	l	R,A1
	n	R,ZW
	or	R,A2
	st	R,A1

%as,n
	S2
	lh	1,A1
	n	1,ZS
	or	R,1
	sth	R,A1

%ab,n
	S2
	sr	1,1
	ic	1,A1
	n	1,ZB
	or	R,1
	stc	R,A1

%a,n
	S2
	l	1,A1
	n	1,ZW
	or	R,1
	st	R,A1

%eb*,n
	S2
	F1*
	sr	1,1
	ic	1,#1(R1)
	n	1,ZB
	or	1,R
	stc	1,#1(R1)
	lr	R,1

%es*,n
	S2
	F1*
	lh	1,#1(R1)
	n	1,ZS
	or	1,R
	sth	1,#1(R1)
	lr	R,1

%e*,n
	S2
	F1*
	l	1,#1(R1)
	n	1,ZW
	or	1,R
	st	1,#1(R1)
	lr	R,1

%nb*,n
	SS
	F*
	sr	1,1
	ic	1,#1(R)
	n	1,ZB
	o	1,O
	stc	1,#1(R)
	lr	R,1

%ns*,n
	SS
	F*
	lh	1,#1(R)
	n	1,ZS
	o	1,O
	sth	1,#1(R)
	lr	R,1

%n*,n
	SS
	F*
	l	1,#1(R)
	n	1,ZW
	o	1,O
	st	1,#1(R)
	lr	R,1

/
/ ++,-- postfix
/
cr32:
%rb,n
	lr	R,A1
	I	A1,A2
	n	A1,=x'000000ff'

%r,n
	lr	R,A1
	I	A1,A2

%ab,n
	sr	R,R
	ic	R,A1
	lr	0,R
	I	0,A2
	stc	0,A1

%a,n
	lB1	R,A1
	Q1	R,=x'0000ffff'
	lr	0,R
	I	0,A2
	stB1	0,A1

%eb*,n
	F*
	sr	0,0
	ic	0,#1(R)
	lr	1,0
	I	1,A2
	stc	1,#1(R)
	lr	R,0

%e*,n
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	lr	1,0
	I	1,A2
	stB1	1,#1(R)
	lr	R,0

%nb*,n
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	lr	0,R
	I	0,A2
	stc	0,#1(1)

%n*,n
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	lr	0,R
	I	0,A2
	stB1	0,#1(1)

/
/ &unary
/
cr35:
%a,n
%af,n
%ad,n
%au,n
%at,n
%al,n
%av,n
	la	R,A1

/
/ *unary        indirection
/
cr36:
%rb,n
	sr	R,R
	ic	R,0(A1)

%r,n
	lB1	R,0(A1)
	Q1	R,=x'0000ffff'

%abp,n
	l	1,A1
	sr	R,R
	ic	R,0(1)

%aip,n
	l	R,A1
	lB1	R,0(R)
	Q1	R,=x'0000ffff'

%afp,n
%adp,n
	l	R,A1
	lBF	FR,0(R)

%ebp,n
	H1*
	sr	R,R
	ic	R,~(R1)

%nbp,n
	H*
	sr	1,1
	ic	1,~(R)
	lr	R,1

%nfp,n
%ndp,n
	H2*
	lBF	FR,~(R)

%n,n
	H*
	lBH	R,~(R)
	QH	R,=x'0000ffff'

/
/ - unary minus
/
cr37:
%n,n
	F
	lcr	R,R

%nd,n
	F
	lcBFr	FR,FR

/
/ ~  ones complement
/
cr38:
%n,n
	F
	x	R,=x'ffffffff'

/
/ = assignment
/
cr80:
%r,r
	lr	A1,A2
	lr	R,A1

%rbp,a
	l	A1,A2
	lr	R,A1

%rb,n
	S
	lr	A1,R
	n	A1,=x'000000ff'

%r,n
	S
	lr	A1,R

%a,n
	S
	stB1	R,A1

%ad,nd
%af,nf
	S
	stB1	FR,A1

%ad*,nd
	S2
	l	R,A1
	stB1	FR,0(R)

%e*,n
	S2
	F1*
	stB1	R,#1(R1)

%n*,e
	F*
	S1
	stB1	R1,#1(R)
	lr	R,R1

%n*,n
	FS*
	S2
	l	1,O
	stB1	R,#1(1)

%nf*,nf
%nd*,nd
	S2
	F2*
	stB1	FR,#1(R)

/
/ shifts
/
cr46:
%r,r
	lr	R,A1
	Il	R,0(A2)

%r,z
	lr	R,A1

%r,c
	lr	R,A1
	Il	R,C2

%r,e
	S1
	lr	R,A1
	Il	R,0(R1)

%r,n
	S2
	lr	1,R
	lr	R,A1
	Il	R,0(1)

%n,r
	F
	Il	R,0(A2)

%n,z
	F

%n,c
	F
	Il	R,C2

%ab,n
	S2
	lr	1,R
	sr	R,R
	ic	R,A1
	Il	R,0(1)

%a,n
	S2
	lr	1,R
	lB1	R,A1
	Q1	R,=x'0000ffff'
	Il	R,0(1)

%n,e
	F2
	S1
	Il	R,0(R1)

%n,n
	SS
	F2
	l	1,O
	Il	R,0(1)

/
/ +, -
/
cr40:
%r,r
	lr	R,A1
	Ir	R,A2

%r,z
	lr	R,A1

%r,ab
	S1
	lr	R,A1
	Ir	R,R1

%r,at
	S
	lr	1,R
	lr	R,A1
	Ir	R,1

%r,a
	lr	R,A1
	IB2	R,A2

%r,e
	S1
	lr	R,A1
	Ir	R,R1

%r,n
	S2
	lr	1,R
	lr	R,A1
	Ir	R,1

%n,r
	F
	Ir	R,A2

%n,z
	F

%n,at
	F2
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	R,1

%n,as
%n,aw
	F
	IB2	R,A2

%nf,af
%nd,ad
	F
	IB2	FR,A2

%n,et*
	F2
	S1*
	lB2	1,#2(R1)
	Q2	1,=x'0000ffff'
	Ir	R,1

%n,es*
%n,ew*
	F2
	S1*
	IB2	R,#2(R1)

%nd,ed*
	F2
	S2*
	IB2	FR,#2(R)

%n,e
	F2
	S1
	Ir	R,R1

%n,n
	SS
	F
	I	R,O

%nf,nf
%nd,nd
	SS
	F2
	IB2	FR,O

/
/ &, |, ^  -- binary and, or, xor
/
cr47:
%r,r
	lr	R,A1
	Ir	R,A2

%r,a*
%r,ab*
%r,ab
	S1
	lr	R,A1
	Ir	R,R1

%r,as
%r,at
	lr	R,A1
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	R,1

%r,a
	lr	R,A1
	I	R,A2

%r,e
	S1
	lr	R,A1
	Ir	R,R1

%r,n
	S2
	lr	1,R
	lr	R,A1
	Ir	R,1

%n,r
	F
	Ir	R,A2

%n,z
	F

%n,as
%n,at
	F
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	R,1

%n,aw
	F
	I	R,A2

%n,es*
%n,et*
	F2
	S1*
	lB2	1,#2(R1)
	Q2	1,=x'0000ffff'
	Ir	R,1

%n,ew*
	F2
	S1*
	I	R,#2(R1)

%n,e
	F2
	S1
	Ir	R,R1

%n,n
	SS
	F
	I	R,O

/
/ * -- R must be odd & this will clobber the even register R-  multiply
/
cr42:
%r,r
	lr	R,A1
	mr	R-,A2

%r,ab
%r,a*
	S2
	mr	R-,A1

%r,as
%r,at
	lr	R,A1
	lB2	1,A2
	Q2	1,=x'0000ffff'
	mr	R-,1

%r,a
	lr	R,A1
	m	R-,A2

%r,n
	S2
	mr	R-,A1

%n,r
	F2
	mr	R-,A2

%n,as
%n,at
	F2
	lB2	1,A2
	Q2	1,=x'0000ffff'
	mr	R-,1

%n,aw
	F2
	m	R-,A2

%n,ns*
%n,nt*
	SS*
	F2
	l	1,O
	lB2	1,#2(1)
	Q2	1,=x'0000ffff'
	mr	R-,1

%n,nw*
	SS*
	F2
	l	1,O
	m	R-,#2(1)

%n,n
	SS
	F2
	m	R-,O

%nd,ad
%nf,af
	F
	mB2	FR,A2

%nf,nf*
%nd,nd*
	F2
	S2*
	mB2	FR,#2(R)

%nd,nd
%nf,nf
	SS
	F
	mB2	FR,O

/
/ R must be even.  divide and mod
/
cr43:
%r,r
	lr	R,A1
	T	R,32
	dr	R,A2

%r,ab
%r,a*
	S2
	lr	1,R
	lr	R,A1
	T	R,32
	dr	R,1

%r,as
%r,at
	lr	R,A1
	lB2	1,A2
	Q2	1,=x'0000ffff'
	srda	R,32
	dr	R,1

%r,a
	lr	R,A1
	T	R,32
	d	R,A2

%r,e
	S2
	lr	1,R
	lr	R,A1
	T	R,32
	dr	R,1

%r,ns
%r,nt
%r,nw
	S2
	lr	1,R
	lr	R,A1
	T	R,32
	dr	R,1

%n,r
	F2
	T	R,32
	dr	R,A2

%n,as
%n,at
	F2
	lB2	1,A2
	Q2	1,=x'0000ffff'
	srda	R,32
	dr	R,1

%n,aw
	F2
	T	R,32
	d	R,A2

%n,es*
%n,et*
	F2
	S1*
	lB2	0,#2(R1)
	Q2	0,=x'0000ffff'
	srda	R,32
	dr	R,0

%n,ew*
	F2
	S1*
	l	0,#2(R1)
	T	R,32
	dr	R,0

%n,e
	F2
	S1
	lr	0,R1
	T	R,32
	dr	R,0

%nf,af
%nd,ad
	F
	dB2	FR,A2

%nf,ef*
%nd,ed*
	F2
	S2*
	dB2	FR,#2(R)

%n,n
	SS
	F2
	T	R,32
	d	R,O

%nf,nf
%nd,nd
	SS
	F
	dB2	FR,O


/
/ =*
/
cr72:
%r,r
	lr	R,A1
	mr	R-,A2
	lr	A1,R

%r,ab
%r,a*
	S1
	lr	R,A1
	mr	R-,R1
	lr	A1,R

%r,as
%r,at
	lr	R,A1
	lB2	1,A2
	Q2	1,=x'0000ffff'
	mr	R-,1
	lr	A1,R

%r,a
	lr	R,A1
	m	R-,A2
	lr	A1,R

%r,n
	S
	mr	R-,A1
	lr	A1,R

%aw*,n
	S2
	l	1,A1
	m	R-,#1(1)
	st	R,#1(1)

%ab,n
	S2
	sr	0,0
	ic	0,A1
	mr	R-,0
	stc	R,A1

%as,n
%at,n
	S2
	lB1	1,A1
	Q1	1,=x'0000ffff'
	mr	R-,1
	stB1	R,A1

%a,n
	S2
	m	R-,A1
	st	R,A1

%nb*,n
	FS*
	S2
	l	1,O
	sr	0,0
	ic	0,#1(1)
	mr	R-,0
	stc	R,#1(1)

%ns*,n
%nt*,n
	FS*
	S2
	l	1,O
	lB1	0,#1(1)
	Q1	0,=x'0000ffff'
	mr	R-,0
	stB1	R,#1(1)

%n*,n
	FS*
	S2
	l	1,O
	m	R-,#1(1)
	st	R,#1(1)

%ad,ad
	F
	mB2	FR,A2
	stB1	FR,A1

%ad,nd
	S
	mB1	FR,A1
	stB1	FR,A1

%nd*,nd
	S2
	F2*
	mB1	FR,#1(R)
	stB1	FR,#1(R)


/
/ =/; R must be odd on integers
/
cr73:
%r,r
	lr	0,A1
	T	0,32
	dr	0,A2
	lr	A1,1
	lr	R+,1

%r,ab
	sr	0,0
	ic	0,A2
	T	0,32
	dr	0,A1
	lr	A1,1
	lr	R+,1

%r,as
%r,at
	lr	0,A1
	lB2	R,A2
	Q2	R,=x'0000ffff'
	T	0,32
	dr	0,R
	lr	A1,1
	lr	R+,1

%r,aw
	lr	0,A1
	T	0,32
	d	0,A2
	lr	A1,1
	lr	R+,1

%r,n
	S2
	lr	0,A1
	T	0,32
	dr	0,R
	lr	A1,1
	lr	R+,1

%n*,r
	F2
	lr	0,A2
	T	0,32
	dr	0,R
	stB1	1,#1(R)

%ab,n
	S2
	sr	0,0
	ic	0,A1
	T	0,32
	dr	0,R
	stc	1,A1
	lr	R+,1

%a,n
	S2
	lB1	0,A1
	Q1	0,=x'0000ffff'
	T	0,32
	dr	0,R
	stB1	1,A1
	lr	R+,1

%nb*,n
	SS
	F*
	sr	0,0
	ic	0,#1(R)
	T	0,32
	d	0,O
	stc	1,#1(R)
	lr	R+,1

%n*,n
	SS
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	T	0,32
	d	0,O
	stB1	1,#1(R)
	lr	R+,1

%ad,ad
	F
	dB2	FR,A2
	stB1	FR,A1

%ad,nd
	SS
	F
	dB2	FR,O
	stB1	FR,A1

%ed*,nd
	S1
	F2*
	lB1	FR,#1(R)
	dBFr	FR,FR1
	stB1	FR,#1(R)

%nd*,ad
	F2*
	lB1	FR,#1(R)
	dB2	FR,A2
	stB1	FR,#1(R)

%nd*,nd
	SS
	F2*
	lB1	FR,#1(R)
	dB2	FR,O
	stB1	FR,#1(R)

/
/ =mod;	 R must be odd on integers
/
cr74:
%r,r
	lr	0,A1
	T	0,32
	dr	0,A2
	lr	A1,0
	lr	R,0

%r,ab
%r,a*
	S2
	lr	0,A1
	T	0,32
	dr	0,R
	lr	A1,0
	lr	R,0

%r,as
%r,at
	lr	0,A1
	lB2	R,A2
	Q2	R,=x'0000ffff'
	T	0,32
	dr	0,R
	lr	A1,0
	lr	R,0

%r,a
	lr	0,A1
	T	0,32
	d	0,A2
	lr	A1,0
	lr	R,0

%r,n
	S2
	lr	0,A1
	T	0,32
	dr	0,R
	lr	A1,0

%ab,n
	S2
	sr	0,0
	ic	0,A1
	T	0,32
	dr	0,R
	stc	0,A1
	lr	R,0

%a,n
	S2
	lB1	0,A1
	Q1	0,=x'0000ffff'
	T	0,32
	dr	0,R
	stB1	0,A1
	lr	R,0

%eb*,n
	S2
	F1*
	sr	0,0
	ic	0,#1(R1)
	T	0,32
	dr	0,R
	stc	0,#1(R1)
	lr	R,0

%e*,n
	S2
	F1*
	lB1	0,#1(R1)
	Q1	0,=x'0000ffff'
	T	0,32
	dr	0,R
	stB1	0,#1(R1)
	lr	R,0

%nb*,n
	SS
	F*
	sr	0,0
	ic	0,#1(R)
	T	0,32
	d	0,O
	stc	0,#1(R)
	lr	R,0

%n*,n
	SS
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	T	0,32
	d	0,O
	stB1	0,#1(R)
	lr	R,0

/
/ =<<, =>>
/
cr75:
%r,r
	Il	A1,0(A2)
	lr	R,A1

%r,c
	Il	A1,C2
	lr	R,A1

%r,n
	S2
	Il	A1,0(R)
	lr	R,A1

%ab,r
%a,r
	F
	Il	R,0(A2)
	stB1	R,A1

%ab,c
%a,c
	F
	Il	R,C2
	stB1	R,A1

%ab,e
	S1
	sr	R,R
	ic	R,A1
	Il	R,0(R1)
	stc	R,A1

%ab,n
	S2
	sr	1,1
	ic	1,A1
	Il	1,0(R)
	stc	1,A1
	lr	R,1

%a,e
	S1
	lB1	R,A1
	Q1	R,=x'0000ffff'
	Il	R,0(R1)
	stB1	R,A1

%a,n
	S2
	lB1	1,A1
	Q1	1,=x'0000ffff'
	Il	1,0(R)
	stB1	1,A1
	lr	R,1

%nb*,r
	F*
	sr	1,1
	ic	1,#1(R)
	Il	1,0(A2)
	stc	1,#1(R)
	lr	R,1

%nb*,c
	F*
	sr	1,1
	ic	1,#1(R)
	Il	1,C2
	stc	1,#1(R)
	lr	R,1

%n*,r
	F*
	lB1	1,#1(R)
	Q1	1,=x'0000ffff'
	Il	1,0(A2)
	stB1	1,#1(R)
	lr	R,1

%n*,c
	F*
	lB1	1,#1(R)
	Q1	1,=x'0000ffff'
	Il	1,C2
	stB1	1,#1(R)
	lr	R,1

%eb*,n
	S2
	F1*
	sr	1,1
	ic	1,#1(R1)
	Il	1,0(R)
	stc	1,#1(R1)
	lr	R,1

%e*,n
	S2
	F1*
	lB1	1,#1(R1)
	Q1	1,=x'0000ffff'
	Il	1,0(R)
	stB1	1,#1(R1)
	lr	R,1

%nb*,n
	SS
	F*
	sr	0,0
	ic	0,#1(R)
	l	1,O
	Il	0,0(1)
	stc	0,#1(R)
	lr	R,0

%n*,n
	SS
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	l	1,O
	Il	0,0(1)
	stB1	0,#1(R)
	lr	R,0

/
/ =+
/
cr70:
%rb,r
	Ir	A1,A2
	n	A1,=x'000000ff'
	lr	R,A1

%r,r
	Ir	A1,A2
	lr	R,A1

%r,ab
	S
	Ir	A1,R
	lr	R,A1

%r,at
	S
	Ir	A1,R
	lr	R,A1

%r,a
	IB2	A1,A2
	lr	R,A1

%r,n
	S
	Ir	A1,R
	lr	R,A1

%ab,n
	S
	sr	1,1
	ic	1,A1
	Ir	R,1
	stc	R,A1

%at,n
	S2
	lB1	1,A1
	Q1	1,=x'0000ffff'
	Ir	R,1
	stB1	R,A1

%a,n
	S
	IB1	R,A1
	stB1	R,A1

%af,nf
%ad,nd
	S
	IB1	FR,A1
	stB1	FR,A1

%eb*,r
	F*
	sr	0,0
	ic	0,#1(R)
	Ir	0,A2
	stc	0,#1(R)
	lr	R,0

%eb*,ab
	S2
	F1*
	sr	0,0
	ic	0,#1(R1)
	Ir	R,0
	stc	R,#1(R1)

%eb*,at
	F*
	sr	0,0
	ic	0,#1(R)
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	0,1
	lr	R,0

%eb*,a
	F*
	sr	0,0
	ic	0,#1(R)
	IB2	0,A2
	stc	0,#1(R)
	lr	R,0

%e*,r
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	Ir	0,A2
	stB1	0,#1(R)
	lr	R,0

%e*,ab
	S2
	F1*
	lB1	0,#1(R1)
	Q1	0,=x'0000ffff'
	Ir	0,R
	stB1	0,#1(R1)
	lr	R,0

%e*,at
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	0,1
	stB1	0,#1(R)
	lr	R,0

%e*,a
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	IB2	0,A2
	stB1	0,#1(R)
	lr	R,0

%ef*,af
%ed*,ad
	F2*
	lB1	FR,#1(R)
	IB2	FR,A2
	stB1	FR,#1(R)

%eb*,n
	S2
	F1*
	sr	0,0
	ic	0,#1(R1)
	Ir	R,0
	stc	R,#1(R1)

%et*,n
	S2
	F1*
	lB1	1,#1(R1)
	Q1	1,=x'0000ffff'
	Ir	R,1
	stB1	R,#1(R1)

%e*,n
	S2
	F1*
	IB1	R,#1(R1)
	stB1	R,#1(R1)

%ef*,nf
%ed*,nd
	S2
	F2*
	IB1	FR,#1(R)
	stB1	FR,#1(R)

%nb*,r
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	Ir	R,A2
	stc	R,#1(1)

%nb*,ab
	FS*
	S2
	l	1,O
	sr	0,0
	ic	0,#1(1)
	Ir	R,0
	stc	R,#1(1)

%nb*,at
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	lB2	0,A2
	Q2	0,=x'0000ffff'
	Ir	R,0
	stc	R,#1(1)

%nb*,a
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	IB2	R,A2
	stc	R,#1(1)

%n*,r
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	Ir	R,A2
	stB1	R,#1(1)

%n*,ab
	FS*
	S2
	l	1,O
	IB1	R,#1(1)
	stB1	R,#1(1)

%n*,at
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	lB2	0,A2
	Q2	0,=x'0000ffff'
	Ir	R,0
	stB1	R,#1(1)

%n*,a
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	IB2	R,A2
	stB1	R,#1(1)

%nb*,n
	FS*
	S2
	l	1,O
	sr	0,0
	ic	0,#1(1)
	Ir	R,0
	stc	R,#1(1)

%nt*,n
	FS*
	S2
	l	1,O
	lB1	0,#1(1)
	Q1	0,=x'0000ffff'
	Ir	R,0
	stB1	R,#1(1)

%n*,n
	FS*
	S2
	l	1,O
	IB1	R,#1(1)
	stB1	R,#1(1)

%nd*,ad
%nf*,af
	F2*
	lB1	FR,#1(R)
	IB2	FR,A2
	stB1	FR,#1(R)

%nd*,nd
%nf*,nf
	S2
	F2*
	IB1	FR,#1(R)
	stB1	FR,#1(R)

/
/ =-
/
cr71:
%rb,r
	sr	A1,A2
	n	A1,=x'000000ff'
	lr	R,A1

%r,r
	sr	A1,A2
	lr	R,A1

%rb,n
	S
	sr	A1,R
	n	A1,=x'000000ff'
	lr	R,A1

%r,ab
	S2
	sr	A1,R
	lr	R,A1

%r,at
	S
	sr	A1,R
	lr	R,A1

%r,a
	sB2	A1,A2
	lr	R,A1

%r,n
	S
	sr	A1,R
	lr	R,A1

%ab,r
%a,r
	F
	sr	R,A2
	stB1	R,A1

%ab,n
	S2
	sr	1,1
	ic	1,A1
	Ir	R,1
	lcr	R,R
	stc	R,A1

%a,at
	lB1	R,A1
	Q1	R,=x'0000ffff'
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	R,1
	stB1	R,A1

%a,a
	lB1	R,A1
	Q1	R,=x'0000ffff'
	IB2	R,A2
	stB1	R,A1

%at,n
	S2
	lB1	1,A1
	Q1	1,=x'0000ffff'
	Ir	R,1
	lcr	R,R
	stB1	R,A1

%a,n
	S
	IB1	R,A1
	lcr	R,R
	stB1	R,A1

%ad,ad
	lB1	FR,A1
	IB2	FR,A2
	stB1	FR,A1

%ad,nd
	S
	IB1	FR,A1
	lcBFr	FR,FR
	stB1	FR,A1

%eb*,r
	F*
	sr	0,0
	ic	0,#1(R)
	Ir	0,A2
	stc	0,#1(R)
	lr	R,0

%eb*,ab
	S2
	F1*
	sr	0,0
	ic	0,#1(R1)
	Ir	0,R
	stc	0,#1(R1)
	lr	R,0

%eb*,at
	F*
	sr	0,0
	ic	0,#1(R)
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	0,1
	stc	0,#1(R)
	lr	R,0

%eb*,a
	F*
	sr	0,0
	ic	0,#1(R)
	IB2	0,A2
	stc	0,#1(R)
	lr	R,0

%eb*,n
	S2
	F1*
	sr	0,0
	ic	0,#1(R1)
	Ir	0,R
	stc	0,#1(R1)
	lr	R,0

%e*,r
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	Ir	0,A2
	stB1	0,#1(R)
	lr	R,0

%e*,ab
	S2
	F1*
	IB1	R,#1(R1)
	lcr	R,R
	stB1	R,#1(R1)

%e*,at
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	0,1
	stB1	0,#1(R)
	lr	R,0

%e*,a
	F1*
	lB1	R,#1(R1)
	Q1	R,=x'0000ffff'
	IB2	R,A2
	stB1	R,#1(R1)

%et*,n
	S2
	F1*
	lB1	1,#1(R1)
	Q1	1,=x'0000ffff'
	Ir	R,1
	lcr	R,R
	stB1	R,#1(R1)

%e*,n
	S2
	F1*
	IB1	R,#1(R1)
	lcr	R,R
	stB1	R,#1(R1)

%nb*,r
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	Ir	R,A2
	stc	R,#1(1)

%nb*,ab
	FS*
	S2
	l	1,O
	sr	0,0
	ic	0,#1(1)
	Ir	0,R
	stc	0,#1(1)
	lr	R,0

%nb*,at
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	lB2	0,A2
	Q2	0,=x'0000ffff'
	Ir	R,0
	stc	R,#1(1)

%nb*,a
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	IB2	R,A2
	stc	R,#1(1)

%nb*,n
	FS*
	S2
	l	1,O
	sr	0,0
	ic	0,#1(1)
	Ir	0,R
	stc	0,#1(1)
	lr	R,0

%n*,r
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	Ir	R,A2
	stB1	R,#1(1)

%n*,ab
	FS*
	S2
	l	1,O
	IB1	R,#1(1)
	lcr	R,R
	stB1	R,#1(1)

%n*,at
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	lB2	0,A2
	Q2	0,=x'0000ffff'
	Ir	R,0
	stB1	R,#1(1)

%n*,a
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	IB2	R,A2
	stB1	R,#1(1)

%nt*,n
	FS*
	S2
	l	1,O
	lB1	0,#1(1)
	Q1	0,=x'0000ffff'
	Ir	R,0
	lcr	R,R
	stB1	R,#1(1)

%n*,n
	FS*
	S2
	l	1,O
	IB1	R,#1(1)
	lcr	R,R
	stB1	R,#1(1)

%nd*,ad
	F2*
	lB1	FR,#1(R)
	IB2	FR,A2
	stB1	FR,#1(R)

%nd*,nd
	S2
	F2*
	IB1	FR,#1(R)
	lcBFr	FR,FR
	stB1	FR,#1(R)


/
/  =&, =|, =^
/
cr76:
%rb,r
	Ir	A1,A2
	n	A1,=x'000000ff'
	lr	R,A1

%r,r
	Ir	A1,A2
	lr	R,A1

%r,ab
	S
	Ir	A1,R
	lr	R,A1

%r,as
%r,at
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	A1,1
	lr	R,A1

%r,aw
	I	A1,A2
	lr	R,A1

%r,n
	S
	Ir	A1,R
	lr	R,A1

%ab,n
	S
	sr	1,1
	ic	1,A1
	Ir	R,1
	stc	R,A1

%as,n
%at,n
	S
	lB1	1,A1
	Q1	1,=x'0000ffff'
	Ir	R,1
	stB1	R,A1

%aw,n
	S
	I	R,A1
	st	R,A1

%eb*,r
	F*
	sr	0,0
	ic	0,#1(R)
	Ir	0,A2
	stc	0,#1(R)
	lr	R,0

%eb*,as
%eb*,at
	F*
	sr	0,0
	ic	0,#1(R)
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	0,1
	stc	0,#1(R)
	lr	R,0

%eb*,aw
	F*
	sr	0,0
	ic	0,#1(R)
	I	0,A2
	stc	0,#1(R)
	lr	R,0

%e*,r
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	Ir	0,A2
	stB1	0,#1(R)
	lr	R,0

%e*,as
%e*,at
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	0,1
	stB1	0,#1(R)
	lr	R,0

%e*,aw
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	I	0,A2
	stB1	0,#1(R)
	lr	R,0

%eb*,n
	S2
	F1*
	sr	0,0
	ic	0,#1(R1)
	Ir	R,0
	stc	R,#1(R1)

%es*,n
%et*,n
	S2
	F1*
	lB1	1,#1(R1)
	Q1	1,=x'0000ffff'
	Ir	R,1
	stB1	R,#1(R1)

%ew*,n
	S2
	F1*
	I	R,#1(R1)
	st	R,#1(R1)

%nb*,r
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	Ir	R,A2
	stc	R,#1(1)

%nb*,as
%nb*,at
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	lB2	0,A2
	Q2	0,=x'0000ffff'
	Ir	R,0
	stc	R,#1(1)

%nb*,aw
	F*
	lr	1,R
	sr	R,R
	ic	R,#1(1)
	I	R,A2
	stc	R,#1(1)

%n*,r
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	Ir	R,A2
	stB1	R,#1(1)

%n*,as
%n*,at
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	lB2	0,A2
	Q2	0,=x'0000ffff'
	Ir	R,0
	stB1	R,#1(1)

%n*,aw
	F*
	lr	1,R
	lB1	R,#1(1)
	Q1	R,=x'0000ffff'
	I	R,A2
	stB1	R,#1(1)

%nb*,n
	FS*
	S2
	l	1,O
	sr	0,0
	ic	0,#1(1)
	Ir	R,0
	stc	R,#1(1)

%ns*,n
%nt*,n
	FS*
	S2
	l	1,O
	lB1	0,#1(1)
	Q1	0,=x'0000ffff'
	Ir	R,0
	stB1	R,#1(1)

%n*,n
	FS*
	S2
	l	1,O
	I	R,#1(1)
	st	R,#1(1)

/
/ int -> float
/
cr51:
%r,n
	lr	R,A1
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%z,n
	sdr	FR,FR

%ab,n
	sr	R,R
	ic	R,A1
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%au,n
	l	R,A1
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000000000000'

%a,n
	l	R,A1
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%nb*,n
	F*
	sr	1,1
	ic	1,#1(R)
	lr	R,1
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%nu*,n
	F*
	l	R,#1(R)
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000000000000'

%n*,n
	F*
	l	R,#1(R)
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%nu,n
	F
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000000000000'

%n,n
	F
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

/
/ float, double -> int
/
cr52:
%nd,n
	F
	aw	FR,=xl8'4e00000080000000'
	std	FR,$ftp
	l	R,$ftp+4
	x	R,=x'80000000'

/
/ long->float
/
cr57:
%nl*,nf
%nl*,nd
%nv*,nf
%nv*,nd
	F*
	s	13,=f'8'
	lm	0,1,0(R)
	stm	0,1,0(13)
	l	15,=v(I)
	balr	14,15
	la	13,8(13)
	ldr	FR,0

%nl,nf
%nl,nd
%nv,nf
%nv,nd
	F
	s	13,=f'8'
	stm	R,R+,0(13)
	l	15,=v(I)
	balr	14,15
	la	13,8(13)
	ldr	FR,0

/
/ int->char
/
cr109:
%n,n
	F
	n	R,=x'000000ff'

/
/ float->short
/
cr111:
%zf,n
%zd,n
	sr	R,R

%af,n
%ad,n
	lB1	FR,A1
	aw	FR,=xl8'4e00000080000000'
	std	FR,$ftp
	l	R,$ftp+4
	x	R,=x'80000000'

%nf*,n
%nd*,n
	F*
	lB1	FR,#1(R)
	aw	FR,=xl8'4e00000080000000'
	std	FR,$ftp
	l	R,$ftp+4
	x	R,=x'80000000'

%nf,n
%nd,n
	F
	aw	FR,=xl8'4e00000080000000'
	std	FR,$ftp
	l	R,$ftp+4
	x	R,=x'80000000'

/
/ short->float
/ unsigned short->float
/
cr112:
%z,nf
%z,nd
	sdr	FR,FR

%at,nf
%at,nd
	lB1	R,A1
	Q1	R,=x'0000ffff'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%a,nf
%a,nd
	lB1	R,A1
	Q1	R,=x'0000ffff'
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%nt*,nf
%nt*,nd
	F*
	lB1	R,#1(R)
	Q1	R,=x'0000ffff'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%n*,nf
%n*,nd
	F*
	lB1	R,#1(R)
	Q1	R,=x'0000ffff'
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%nt,nf
%nt,nd
	F
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

%n,nf
%n,nd
	F
	x	R,=x'80000000'
	st	R,$ftc+4
	ld	FR,$ftc
	sd	FR,=xl8'4e00000080000000'

/
/ long->short
/ long->unsigned short
/
cr113:
%zl,n
%zv,n
	sr	R,R

%al,n
%av,n
	l	R,A1+

%nl*,n
%nv*,n
	F*
	l	R,4+#1(R)

%nl,n
%nv,n
	F
	lr	R,R+

/
/ int->short
/
cr115:
%r,n
	lr	R,A1
	sll	R,16
	sra	R,16

%z,n
	sr	R,R

%c,n
	F

%n,n
	F
	sll	R,16
	sra	R,16

/
/ short->int
/
cr116:
%z,n
	sr	R,R

%a,n
	lB1	R,A1
	Q1	R,=x'0000ffff'

%n*,n
	F*
	lB1	R,#1(R)
	Q1	R,=x'0000ffff'

%n,n
	F

/
/ unsigned short->int
/
cr129:
%z,n
	sr	R,R

%a,n
	lB1	R,A1
	n       R,=x'0000ffff'

%n*,n
	F*
	lB1	R,#1(R)
	n       R,=x'0000ffff'

%n,n
	F

/
/ structure operation
/
cr125:
%e,e
	F2
	S12

%n,n
	SS
	F2
	l	R1,O

/
/ int->unsigned short
/
cr128:
%r,n
	lr	R,A1
	n       R,=x'0000ffff'

%z,n
	sr	R,R

%n,n
	F
	n       R,=x'0000ffff'

/
/ c code tables-- set condition codes
/

.data
cctab = .
	dc f'60';	dc a(cc60)	/ ==
	dc f'61';	dc a(cc60)	/ |=
	dc f'62';	dc a(cc60)	/ <=
	dc f'63';	dc a(cc60)	/ <
	dc f'64';	dc a(cc60)	/ >=
	dc f'65';	dc a(cc60)	/ >
	dc f'66';	dc a(cc60)	/ <p
	dc f'67';	dc a(cc60)	/ <=p
	dc f'68';	dc a(cc60)	/ >p
	dc f'69';	dc a(cc60)	/ >=p
	dc f'0'
.text

/
/ relationals
/
cc60:
%r,r
	cUr	A1,A2

%r,ab
%r,a*
	S
	cUr	A1,R

%r,as
	lB2	1,A2
	cUr	A1,1

%r,at
	lB2	1,A2
	n	1,=x'0000ffff'
	lr	0,A1
	n	0,=x'0000ffff'
	cUr	0,1

%r,a
	cU	A1,A2

%r,n
	S
	cUr	A1,R

%a,r
%e*,r
	F
	cUr	R,A2

%ab,c
	cli	A1,x'HX2'

%eb*,c
	F*
	cli	#1(R),x'HX2'

%n,r
	F
	cUr	R,A2

%n,z
	F
	ltr	R,R

%nf,z
%nd,z
%nf,zf
%nd,zd
	F
	ltBFr	FR,FR

%n,as
	F
	lB2	1,A2
	cUr	R,1

%n,at
	F
	lB2	1,A2
	n	1,=x'0000ffff'
	n	R,=x'0000ffff'
	cUr	R,1

%n,aw
	F
	cU	R,A2

%nd,ad
	F
	cB2	FR,A2

%n,es*
	F2
	S1*
	lB2	1,#2(R1)
	cUr	R,1

%n,et*
	F2
	S1*
	lB2	1,#2(R1)
	n	1,=x'0000ffff'
	n	R,=x'0000ffff'
	cUr	R,1

%n,ew*
	F2
	S1*
	cU	R,#2(R1)

%nf,ef*
%nd,ed*
	F2
	S2*
	cB2	FR,#2(R)

%n,e
	F2
	S1
	cUr	R,R1

%n,n
	SS
	F
	cU	R,O

%nf,nf
%nd,nd
	SS
	F
	cB2	FR,O

%al,r
	l	1,A1
	ltr	1,1
	X0
	l	1,A1+
	clr	1,A2
	X1

%al,c
%al,au
	l	1,A1
	ltr	1,1
	X0
	l	1,A1+
	cl	1,A2
	X1

%al,al
	l	1,A1
	c	1,A2
	X0
	l	1,A1+
	cl	1,A2+
	X1

%nl*,z
	F*
	l	1,#1(R)
	ltr	1,1
	X0
	l	1,4+#1(R)
	ltr	1,1
	X1

%nl*,r
	F*
	l	1,#1(R)
	ltr	1,1
	X0
	l	1,4+#1(R)
	clr	1,A2
	X1

%nl*,c
%nl*,au
	F*
	l	1,#1(R)
	ltr	1,1
	X0
	l	1,4+#1(R)
	cl	1,A2
	X1

%nl*,al
	F*
	l	1,#1(R)
	c	1,A2
	X0
	l	1,4+#1(R)
	cl	1,A2+
	X1

%nl,z
	F
	ltr	R,R
	X0
	ltr	R+,R+
	X1

%nl,r
	F
	ltr	R,R
	X0
	clr	R+,A2
	X1

%nl,c
%nl,au
	F
	ltr	R,R
	X0
	cl	R+,A2
	X1

%nl,al
	F
	c	R,A2
	X0
	cl	R+,A2+
	X1

%nl*,nl*
	SS*
	F*
	l	R+,O
	l	1,#1(R)
	c	1,#2(R+)
	X0
	l	1,4+#1(R)
	cl	1,4+#2(R+)
	X1

%nl,nl*
	SS*
	F
	l	1,O
	c	R,#2(1)
	X0
	cl	R+,4+#2(1)
	X1

%av,av
	l	1,A1
	cl	1,A2
	X0
	l	1,A1+
	cl	1,A2+
	X1

%nv*,av
	F*
	l	1,#1(R)
	cl	1,A2
	X0
	l	1,4+#1(R)
	cl	1,A2+
	X1

%nv,av
	F
	cl	R,A2
	X0
	cl	R+,A2+
	X1

%nv*,nv*
	SS*
	F*
	l	R+,O
	l	1,#1(R)
	cl	1,#2(R+)
	X0
	l	1,4+#1(R)
	cl	1,4+#2(R+)
	X1

%nv,nv*
	SS*
	F
	l	1,O
	cl	R,#2(1)
	X0
	cl	R+,4+#2(1)
	X1

%nv,nv
	SS
	F
	lm	0,1,O
	clr	R,0
	X0
	clr	R+,1
	X1

/
/ c code tables - compile for side effects
/

.data
efftab = .
	dc f'80';	dc a(ci80)	/ assign
	dc f'30';	dc a(ci70)	/ incbef
	dc f'31';	dc a(ci71)	/ decbef
	dc f'32';	dc a(ci32)	/ incaft
	dc f'33';	dc a(ci32)	/ decaft
	dc f'70';	dc a(ci70)	/ =+
	dc f'71';	dc a(ci71)	/ =-
	dc f'77';	dc a(ci76)	/ =&
	dc f'78';	dc a(ci76)	/ =|
	dc f'79';	dc a(ci76)	/ =^
	dc f'0'
.text

/
/ assignment
/
ci80:
%r,r
	lr	A1,A2

%rbp,a
	lB2	A1,A2

%rb,ab
	sr	A1,A1
	ic	A1,A2

%rb,a
	l	A1,A2
	n	A1,=x'000000ff'

%rb,n
	S
	lr	A1,R
	n	A1,=x'000000ff'

%r,ab
	sr	A1,A1
	ic	A1,A2

%r,a
	lB2	A1,A2
	Q2	A1,=x'0000ffff'

%r,ab*
	l	R,A2
	sr	A1,A1
	ic	A1,0(R)

%r,aw*
	l	R,A2
	l	A1,0(R)

%a,r
	stB1	A2,A1

%e*,r
	F*
	stB1	A2,#1(R)

%ab,c
	mvi	A1,x'HX2'

%eb*,c
	F*
	mvi	#1(R),x'HX2'

%ab,ab
	mvc	?A1,A2

%ab*,ab*
	l	R,A1
	l	R1,A2
	mvc	0(1,R),0(R1)

/
/ ++,-- postfix
/
ci32:
%rb,n
	I	A1,A2
	n	A1,=x'000000ff'

%r,n
	I	A1,A2

%ab,n
	sr	0,0
	ic	0,A1
	I	0,A2
	stc	0,A1

%a,n
	lB1	0,A1
	Q1	0,=x'0000ffff'
	I	0,A2
	stB1	0,A1

/
/ =+
/
ci70:
%rb,r
	Ir	A1,A2
	n	A1,=x'000000ff'

%r,r
	Ir	A1,A2

%r,ab
	S
	Ir	A1,R

%r,at
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	A1,1

%r,a
	IB2	A1,A2

%r,n
	S
	Ir	A1,R

/
/ =-
/
ci71:
%rb,r
	sr	A1,A2
	n	A1,=x'000000ff'

%r,r
	sr	A1,A2

%rb,n
	S
	sr	A1,R
	n	A1,=x'000000ff'

%r,ab
	S2
	sr	A1,R

%r,at
	lB2	1,A2
	Q2	1,=x'0000ffff'
	sr	A1,1

%r,a
	sB2	A1,A2

%r,n
	S
	sr	A1,R

/
/ =&, =|, =^
/
ci76:
%rb,r
	Ir	A1,A2
	n	A1,=x'000000ff'

%r,r
	Ir	A1,A2

%r,ab
	S
	Ir	A1,R

%r,as
%r,at
	lB2	1,A2
	Q2	1,=x'0000ffff'
	Ir	A1,1

%r,a
	I	A1,A2

%r,n
	S
	Ir	A1,R

/
/ c code tables - expression to -(sp)
/

.data
sptab = .
	dc f'0'

.data
lngtab = .
	dc f'106';	dc a(cl106)	/ load
	dc f'27';	dc a(cl32)	/ autoi
	dc f'28';	dc a(cl71)	/ autod
	dc f'30';	dc a(cl70)	/ incbef
	dc f'31';	dc a(cl71)	/ decbef
	dc f'32';	dc a(cl32)	/ incaft
	dc f'33';	dc a(cl32)	/ decaft
	dc f'35';	dc a(cl35)	/ amper
	dc f'36';	dc a(cl36)	/ star - indirection
	dc f'37';	dc a(cl37)	/ negation
	dc f'38';	dc a(cl38)	/ complement
	dc f'98';	dc a(cl100)	/ call 1
	dc f'99';	dc a(cl100)	/ call 2
	dc f'100';	dc a(cl100)	/ call
	dc f'101';	dc a(cl100)	/ m call
	dc f'80';	dc a(cl80)	/ assign
	dc f'40';	dc a(cl40)	/ binary addition
	dc f'41';	dc a(cl40)	/ binary subtraction
	dc f'82';	dc a(cl82)	/ * times - long
	dc f'83';	dc a(cl82)	/ / divide - longs
	dc f'84';	dc a(cl82)	/ mod - longs
	dc f'45';	dc a(cl46)	/ right shift
	dc f'46';	dc a(cl46)	/ left shift
	dc f'47';	dc a(cl47)	/ binary and
	dc f'48';	dc a(cl47)	/ binary or
	dc f'49';	dc a(cl47)	/ binary xor
	dc f'70';	dc a(cl70)	/ =+,
	dc f'71';	dc a(cl71)	/ =-,
	dc f'86';	dc a(cl86)	/ =* - longs
	dc f'87';	dc a(cl86)	/ =/ - longs
	dc f'88';	dc a(cl86)	/ =mod - longs
	dc f'75';	dc a(cl75)	/ =>>
	dc f'76';	dc a(cl75)	/ =<<
	dc f'77';	dc a(cl76)	/ =&
	dc f'78';	dc a(cl76)	/ =|
	dc f'79';	dc a(cl76)	/ =^
	dc f'56';	dc a(cl56)	/ float->long
	dc f'58';	dc a(cl58)	/ int->long
	dc f'59';	dc a(cl59)	/ long->int
	dc f'114';	dc a(cl114)	/ short->long
	dc f'126';	dc a(cl126)	/ long->unsigned long
	dc f'0'
.text

/
/ function call
/
cl100:
%a,nl
%a,nv
	l	15,A1
	balr	14,15

%n,nl
%n,nv
	F
	lr	15,R
	balr	14,15

/
/ addressible
/
cl106:
%ql,n
%qv,n
	l	R,A1
	l	R+,A1+

%al,n
%av,n
	lm	R,R+,A1

/
/ ++,-- postfix
/
cl32:
%al,n
%av,n
	lm	R,R+,A1
	lr	1,R+
	lr	0,R
	Il	1,A2
	V0f
	I	0,=f'1'
	0:
	stm	0,1,A1

%nl*,n
%nv*,n
	F*
	l	R+,4+#1(R)
	lr	1,R+
	l	0,#1(R)
	Il	1,A2
	V0f
	I	0,=f'1'
	0:
	st	1,4+#1(R)
	lr	1,R
	l	R,#1(1)
	st	0,#1(1)

/
/ &unary
/
cl35:
%al,n
%av,n
	la	R,A1

/
/ *unary        indirection
/
cl36:
%alp,n
%avp,n
	l	R,A1
	lm	R,R+,0(R)

%nlp,n
%nvp,n
	H*
	lm	R,R+,~(R)

/
/ - unary minus
/
cl37:
%nv,n
	F
	x	R,=x'ffffffff'
	x	R+,=x'ffffffff'
	al	R+,=f'1'
	bc	12,0f
	al	R,=f'1'
	0:

%nl,n
	F
	x	R,=x'ffffffff'
	x	R+,=x'ffffffff'
	al	R+,=f'1'
	bc	12,0f
	a	R,=f'1'
	0:

/
/ ~  ones complement
/
cl38:
%nl,n
%nv,n
	F
	x	R+,=x'ffffffff'
	x	R,=x'ffffffff'

/
/ = assignment
/
cl80:
%al,nl
%av,nv
	S
	stm	R,R+,A1

%al*,nl
%av*,nv
	S2
	l	1,A1
	stm	R,R+,#1(1)

%nl*,nl
%nv*,nv
	FS*
	S2
	l	1,O
	stm	R,R+,#1(1)

/
/ shifts
/
cl46:
%ql,r
%qv,r
	l	0,A1
	l	1,A1+
	Idl	0,0(A2)
	lr	R,0
	lr	R+,1

%al,r
%av,r
	lm	0,1,A1
	Idl	0,0(A2)
	lr	R,0
	lr	R+,1

%ql,c
%qv,c
	l 	0,A1
	l	1,A1+
	Idl	0,C2
	lr	R,0
	lr	R+,1

%al,c
%av,c
	lm 	0,1,A1
	Idl	0,C2
	lr	R,0
	lr	R+,1

%nl,r
%nv,r
	F
	lr	0,R
	lr	1,R+
	Idl	0,0(A2)
	lr	R,0
	lr	R+,1

%nl,c
%nv,c
	F
	lr	0,R
	lr	1,R+
	Idl	0,C2
	lr	R,0
	lr	R+,1

%nl,a
%nv,a
	F2
	lr	0,R
	lr	1,R+
	l	R,A2
	Idl	0,0(R)
	lr	R,0
	lr	R+,1

%nl,n
%nv,n
	SS
	F
	lr	0,R
	lr	1,R+
	l	R,O
	Idl	0,0(R)
	lr	R,0
	lr	R+,1

%nl,nl
%nv,nv
	SS
	F
	lr	0,R
	lr	1,R+
	la	R,O
	l	R,4(R)
	Idl	0,0(R)
	lr	R,0
	lr	R+,1

/
/ +, -
/
cl40:
%nv,r
	F2
	lr	0,A2
	T	0,32
	Ilr	R+,1
	V0f
	Il	R,=f'1'
	0:
	Ilr	R,0

%nv,av
	F
	Il	R+,A2+
	V0f
	Il	R,=f'1'
	0:
	Il	R,A2

%nv,nv
	SS
	F
	la	1,O
	Il	R+,4(1)
	V0f
	Il	R,=f'1'
	0:
	Il	R,0(1)

%nl,r
	F2
	lr	0,A2
	T	0,32
	Ilr	R+,1
	V0f
	I	R,=f'1'
	0:
	Ir	R,0

%nl,al
	F
	Il	R+,A2+
	V0f
	I	R,=f'1'
	0:
	I	R,A2

%nl,nl
	SS
	F
	la	1,O
	Il	R+,4(1)
	V0f
	I	R,=f'1'
	0:
	I	R,0(1)

/
/ &, |, ^  -- binary and, or, xor
/
cl47:
%nl,al
%nv,av
	F2
	I	R+,A2+
	I	R,A2

%nl,nl*
%nv,nv*
	SS*
	F2
	l	1,O
	I	R+,4+#2(1)
	I	R,#2(1)

%nl,nl
%nv,nv
	SS
	F
	la	1,O
	I	R,0(1)
	I	R+,4(1)

/
/ =<<, =>>
/
cl75:
%al,r
%av,r
	lm	0,1,A1
	Idl	0,0(A2)
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,c
%av,c
	lm	0,1,A1
	Idl	0,C2
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,ab
%av,ab
	S2
	lm	0,1,A1
	Idl	0,0(R)
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,a
%av,a
	lm	0,1,A1
	lB2	R,A2
	Q2	R,=x'0000ffff'
	Idl	0,0(R)
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,al
%av,av
	lm	0,1,A1
	l	R,A2+
	Idl	0,0(R)
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,e
%av,e
	S1
	lm	0,1,A1
	Idl	0,0(R1)
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,n
%av,n
	S2
	lm	0,1,A1
	Idl	0,0(R)
	stm	0,1,A1
	lr	R,0
	lr	R+,1

%al,nl
%av,nl
	S2
	lm	0,1,A1
	Idl	0,0(R+)
	stm	0,1,A1
	lr	R+,1
	lr	R,0

%nl*,r
%nv*,r
	F*
	lm	0,1,#1(R)
	Idl	0,0(A2)
	stm	0,1,#1(R)
	lr	R+,1
	lr	R,0

%nl*,c
%nv*,c
	F*
	lm	0,1,#1(R)
	Idl	0,C2
	stm	0,1,#1(R)
	lr	R+,1
	lr	R,0

%nl*,n
%nv*,n
	SS
	F*
	lm	0,1,#1(R)
	l	R+,O
	Idl	0,0(R+)
	stm	0,1,#1(R)
	lr	R,0
	lr	R+,1

%nl*,e
%nv*,e
	F*
	S1
	lm	0,1,#1(R)
	Idl	0,0(R1)
	stm	0,1,#1(R)
	lr	R,0
	lr	R+,1

%nl*,nl
%nv*,nv
	SS
	F*
	lm	0,1,#1(R)
	l	R+,4+O
	Idl	0,0(R+)
	stm	0,1,#1(R)
	lr	R,0
	lr	R+,1

/
/ =+
/
cl70:
%av,nv
	S
	Il	R,A1
	Il	R+,A1+
	V0f
	Il	R,=f'1'
	0:
	stm	R,R+,A1

%nv*,av
	F*
	lr	1,R
	lm	R,R+,#1(1)
	Il	R,A2
	Il	R+,A2+
	V0f
	Il	R,=f'1'
	0:
	stm	R,R+,#1(1)

%nv*,nv
	FS*
	S2
	l	1,O
	Il	R,#1(1)
	Il	R+,4+#1(1)
	V0f
	Il	R,=f'1'
	0:
	stm	R,R+,#1(1)


%al,nl
	S
	I	R,A1
	Il	R+,A1+
	V0f
	I	R,=f'1'
	0:
	stm	R,R+,A1

%nl*,al
	F*
	lr	1,R
	lm	R,R+,#1(1)
	I	R,A2
	Il	R+,A2+
	V0f
	I	R,=f'1'
	0:
	stm	R,R+,#1(1)

%nl*,nl
	FS*
	S2
	l	1,O
	I	R,#1(1)
	Il	R+,4+#1(1)
	V0f
	I	R,=f'1'
	0:
	stm	R,R+,#1(1)


/
/ =-
/
cl71:
%av,nv
	S2
	Il	R,A1
	Il	R+,A1+
	V0f
	Il	R,=f'1'
	0:
	x	R,=x'ffffffff'
	x	R+,=x'ffffffff'
	al	R+,=f'1'
	bc	12,1f
	al	R,=f'1'
	1:
	stm	R,R+,A1

%nv*,av
	F*
	lr	1,R
	lm	R,R+,#1(1)
	Il	R,A2
	Il	R+,A2+
	V0f
	Il	R,=f'1'
	0:
	stm	R,R+,#1(1)

%nv*,nv
	SS
	F*
	lm	0,1,#1(R)
	Il	0,O
	Il	1,4+O
	V0f
	Il	0,=f'1'
	0:
	stm	0,1,#1(R)
	lr	R,0
	lr	R+,1

%al,nl
	S2
	I	R,A1
	Il	R+,A1+
	V0f
	I	R,=f'1'
	0:
	x	R,=x'ffffffff'
	x	R+,=x'ffffffff'
	al	R+,=f'1'
	bc	12,1f
	a	R,=f'1'
	1:
	stm	R,R+,A1

%nl*,al
	F*
	lr	1,R
	lm	R,R+,#1(1)
	I	R,A2
	Il	R+,A2+
	V0f
	I	R,=f'1'
	0:
	stm	R,R+,#1(1)

%nl*,nl
	SS
	F*
	lm	0,1,#1(R)
	I	0,O
	Il	1,4+O
	V0f
	I	0,=f'1'
	0:
	stm	0,1,#1(R)
	lr	R,0
	lr	R+,1

/
/  =&, =|, =^
/
cl76:
%al,nl
%av,nv
	S
	I	R,A1
	I	R+,A1+
	stm	R,R+,A1

%nl*,al
%nv*,av
	F*
	lr	1,R
	lm	R,R+,#1(1)
	I	R,A2
	I	R+,A2+
	stm	R,R+,#1(1)

%nl*,nl
%nv*,nv
	FS*
	S2
	l	1,O
	I	R,#1(1)
	I	R+,4+#1(1)
	stm	R,R+,#1(1)


/
/ *, /, remainder for longs
/
cl82:
%nl*,nl
%nv*,nv
	SS
	F*
	s	13,=f'16'
	lm	0,1,16+O
	stm	0,1,8(13)
	lm	0,1,#1(R)
	stm	0,1,0(13)
	l	15,I
	balr	14,15
	la	13,16(13)
	lr	R,0
	lr	R+,1

%nl,nl
%nv,nv
	FS
	S2
	s	13,=f'16'
	stm	R,R+,8(13)
	lm	0,1,16+O
	stm	0,1,0(13)
	l	15,I
	balr	14,15
	la	13,16(13)
	lr	R,0
	lr	R+,1

/
/ =*, =/, =rem for longs
/
cl86:
%al,nl
%av,nv
	S2
	s	13,=f'16'
	stm	R,R+,8(13)
	l	0,16+A1
	st	0,0(13)
	l	0,16+A1+
	st	0,4(13)
	l	15,I
	balr	14,15
	la	13,16(13)
	lr	R+,1
	lr	R,0
	stm	0,1,A1

%nl*,nl
%nv*,nv
	SS
	F*
	s	13,=f'16'
	lm	0,1,16+O
	stm	0,1,8(13)
	l	0,#1(R)
	st	0,0(13)
	l	0,4+#1(R)
	st	0,4(13)
	l	15,I
	balr	14,15
	la	13,16(13)
	stm	0,1,#1(R)
	lr	R,0
	lr	R+,1

/
/ float->long
/
cl56:
%nf*,nl
%nd*,nl
%nf*,nv
%nd*,nv
	F2*
	s	13,=f'8'
	lB1	FR,0(R)
	stB1	FR,0(13)
	l	15,=v(I)
	balr	14,15
	la	13,8(13)
	lr	R,0
	lr	R+,1

%nf,nl
%nd,nl
%nf,nv
%nd,nv
	F
	s	13,=f'8'
	stB1	FR,0(13)
	l	15,=v(I)
	balr	14,15
	la	13,8(13)
	lr	R,0
	lr	R+,1

/
/ int -> long
/
cl58:
%nu,n
	F12
	sr	R,R

%r,n
	lr	0,A1
	T	0,32
	lr	R,0
	lr	R+,1

%ab,n
	sr	0,0
	ic	0,A1
	T	0,32
	lr	R,0
	lr	R+,1

%aw,n
	l	0,A1
	T	0,32
	lr	R,0
	lr	R+,1

%nb*,n
	F*
	sr	0,0
	ic	0,#1(R)
	T	0,32
	lr	R,0
	lr	R+,1

%n*,n
	F*
	l	0,#1(R)
	T	0,32
	lr	R,0
	lr	R+,1

%n,n
	F
	lr	0,R
	T	0,32
	lr	R,0
	lr	R+,1

/
/ long->int
/
cl59:
%al,n
%av,n
	l	R,A1+

%nl*,n
%nv*,n
	F*
	l	R,4+#1(R)

/
/ short->long
/
cl114:
%z,nl
%z,nv
	sr	R+,R+
	sr	R,R

%a,nl
%a,nv
	lB1	0,A1
	Q1	0,=x'0000ffff'
	T	0,32
	lr	R,0
	lr	R+,1

%n*,nl
%n*,nv
	F*
	lB1	0,#1(R)
	Q1	0,=x'0000ffff'
	T	0,32
	lr	R,0
	lr	R+,1

%n,nl
%n,nv
	F
	lr	0,R
	T	0,32
	lr	R,0
	lr	R+,1

/
/ long->unsigned long
/
cl126:
%nv,nl
%nl,nv
	F

.text

entry	regtab
entry	efftab
entry	cctab
entry	sptab
entry	lngtab
