/* HARD ADDRESSES */

#define SVCNPSW 0x60    /* page zero location of svc new psw */
#define NORSVCN 0xa0    /* where omak saves the norway svc handler (loc 160) */
#define SVPSW   0xb0    /* where tlbsim saves the svc handler (loc 176) */

/* Constants */

#define NULL    -1
#define START   0
#define BPSVC   0x0a48
#define DAT     0x04000000

/* Instruction lengths */

#define BPW     4
#define BPHW    2
#define INSLEN  0xc0

/* DAT defines for 64k segments and 2k pages */

#define PGSIZE  2048
#define PGMSK   0x0000f800
#define DISPMSK 0x000007ff
#define PGSHFT  11
#define TLBSIZE 32

/* Instruction classes */

#define RR      1
#define RX      2
#define RS      3
#define S       4
#define SI      5
#define SS      6

/* Macros */

#define GPR(a) (gpr[a] & 0xffffff)

/* instruction table structure */

struct instype {
	int type;
	int len;
};

/* tlb table structure */

struct tlb {
	int key;
	int hit;
	int miss;
};

/* 470 instruction structure */

struct cons_ins {
	int opcode : 8;
	int r1 : 4;
	int r2 : 4;
	int base1 : 4;
	int disp1 : 12;
};

/* SS-type instruction opcode structure */

struct store_op {
	int sopcode : 16;
};

/* SS-type instruction second operand structure */

struct ssoperand {
	int base2 : 4;
	int disp2 : 12;
};
 
/* Branch instruction opcodes */
 
#define BALR 0x05
#define BCTR 0x06
#define BCR  0x07
#define BAL  0x45
#define BCT  0x46
#define BC   0x47
#define LPSW 0x82

/* Selected instruction opcodes */

#define MVCL 0x0e
#define LA   0x41
#define EX   0x44
#define STM  0x90
#define LM   0x98
#define MVC  0xd2
#define CLC  0xd5
#define XC   0xd7
#define TRT  0xdd
#define PTLB 0xb20d
