#define NULL 0

/*
 * Put name=val into the environment
 * Replaces any existing name=xxx
 */
putenv(name, val)
char *name, *val;
{
	extern char **environ;
	static char **myenviron = NULL;
	char **ep, **nep, **ne;
	char *malloc(), *sbrk();
	extern char end[];
	int nenv = 0;

	if(environ != NULL)
                for(ep = environ; *ep != NULL; nenv++, ep++) {
			if(nvmatch(name, *ep)) {
				if(*ep > end && *ep < sbrk(0))
					free(*ep);      /* only free it if it was malloced */
				if(val != NULL) {
                                        *ep = malloc(strlen(name) + strlen(val) + 2);
                                        strcpy(*ep, name);
                                        strcat(*ep, "=");
                                        strcat(*ep, val);
                                        return;
				} else {
					do *ep = *(ep+1);
					while(*++ep != NULL);
					return;
				}
			}
		}
	if(val == NULL)
		return;
	ne = nep = (char **)malloc((nenv+2)*sizeof(char *));
	if(environ != NULL)
                for(ep = environ; *ep != NULL;)
                        *nep++ = *ep++;
	*nep = malloc(strlen(name) + strlen(val) + 2);
	strcpy(*nep, name);
	strcat(*nep, "=");
	strcat(*nep, val);
	*++nep = NULL;
	if(environ != NULL && environ == myenviron)
		free((char *)myenviron);
	environ = myenviron = ne;
}

/*
 *	s1 is either name, or name=value
 *	s2 is name=value
 *	if names match, return value of s2, else NULL
 *	used for environment searching: see getenv
 */
static char *
nvmatch(s1, s2)
register char *s1, *s2;
{

	while (*s1 == *s2++)
		if (*s1++ == '=')
			return(s2);
	if (*s1 == '\0' && *(s2-1) == '=')
		return(s2);
	return(NULL);
}
