/
/ Function:
/   STRNCAT finds null in s1,
/    copies at most n characters from s2 starting there,
/    returns --> s1.
/
/ Calling Sequence:
/   strncat(s1, s2, n)  char *s1, *s2; int n;
/
	entry   strncat
	using   strncat,15
strncat:
	lr	r0,sp
	s	sp,=f'64'
	stm	0,15,0(sp)
	st	0,52(,sp)
	lr	r12,sp

	l       r5,64(,sp)          / Get s1 address
	l       r4,=v(_strtabl)     / Get trt table address
0:
	trt     0(256,r5),0(r4)     / Scan for null
	bc      8,1f                / CC=0?  No null found
	lr      r5,r1               / Else reset r5 to point to end
	b       2f                  / Go do the concat
1:
	la      r5,256(r5)          / Increment address
	b       0b                  / Continue scan
2:
	l       r6,68(,sp)          / Get s2 address
	l       r7,72(,sp)          / Get max length
	ltr     r7,r7               / Zero or negative length ?
	bnp     5f                  / Yes, nothing to concatenate
	la      r8,256              / Get initial length
3:
	cr      r7,r8               / length > 256 ?
	bh      6f                  / yes, skip
	lr      r8,r7               / set length to remaining length
6:
	lr      r9,r8               / decrement for stupid instructions
	bctr    r9,0
	ex      r9,xtrt             / Scan for null
	bc      8,4f                / CC=0?  No null found
	sr      r1,r6               / Else calc length remaining to move
	ex      r1,xmvc             / Execute move
	b       5f                  / Return
4:
	ex      r9,xmvc             / Move into s1
	ar      r5,r8               / Increment addresses
	ar      r6,r8
	sr      r7,r8               / decrement remaining length
	bnz     3b                  / yes, Continue scan
	mvi     0(r5),0             / terminate with null
5:
	l       r0,64(,sp)          / Point to s1
	lm      r1,r15,4(r12)       / and return
	br      r14

xmvc:   mvc     0(,r5),0(r6)        / Model mvc 0(0,r5),0(r6)
xtrt:   trt     0(,r6),0(r4)        / Model trt - Scan for null
