         MACRO                                                          STA00010
&LABEL   STACK &WHAT,&L,&H                                              STA00020
.*  PUTS A LINE ONTO THE CMS INPUT STACK                                STA00030
         LCLC  &LEN,&HOW                                                STA00040
&LEN     SETC  '&L'                                                     STA00050
&HOW     SETC  '&H'                                                     STA00060
         AIF   ('&HOW' NE '').LEN                                       STA00070
&HOW     SETC  'LIFO'                                                   STA00080
.LEN     AIF   ('&LEN' NE '').DOIT                                      STA00090
&LEN     SETC  'L''&WHAT'                                               STA00100
.DOIT    ANOP                                                           STA00110
&LABEL   CNOP  4,8                                                      STA00120
         BAL   1,STK&SYSNDX                                             STA00130
         DC    CL8'ATTN'                                                STA00140
         DC    CL4'&HOW'                                                STA00150
         DC    AL1(&LEN)                                                STA00160
         DC    AL3(&WHAT)                                               STA00170
STK&SYSNDX     SVC            202                                       STA00180
         MEND                                                           STA00190
         SPACE 3                                                        STA00200
         MACRO                                                          STA00210
&LAB     ONOFF &BYTE,&FLAG                                              STA00220
&LAB     LA    R4,&BYTE                                                 STA00230
         LA    R5,1                                                     STA00240
         LA    R6,ONOFF                                                 STA00250
         DIAG  R4,R6,DGEXT                                              STA00260
         TM    ONOFF,&FLAG                                              STA00270
         BZ    OFF                                                      STA00280
         B     ON                                                       STA00290
         MEND                                                           STA00300
         MACRO                                                          STA00310
&LAB     MOVE  &WHAT,&LEN                                               STA00320
&LAB     MVC   0(&LEN,R11),&WHAT                                        STA00330
         LA    R11,&LEN+1(,R11)                                         STA00340
         MEND                                                           STA00350
         MACRO                                                          STA00360
&NAME    ITEM  &ARGS                                                    STA00370
         GBLA  &ARGCNT                                                  STA00380
&ARGCNT  SETA  &ARGS                                                    STA00390
         USING &NAME,R9                                                 STA00400
&NAME    DS    0H                                                       STA00410
         MEND                                                           STA00420
         MACRO                                                          STA00430
&LAB     OUT                                                            STA00440
         GBLA  &ARGCNT                                                  STA00450
         AIF   (&ARGCNT EQ 0).RET                                       STA00460
&LAB     LA    R1,8*&ARGCNT.(,R1)                                       STA00470
         BR    R8                                                       STA00480
         MEXIT                                                          STA00490
.RET     ANOP                                                           STA00500
&LAB     BR    R8                                                       STA00510
         LTORG                                                          STA00520
         MEND                                                           STA00530
         MACRO                                                          STA00540
&LAB     VMCOPY      &WHAT                                              STA00550
         LCLC  &X                                                       STA00560
&X       SETC  'L'''.'&WHAT'                                            STA00570
&LAB     LA    R4,&WHAT                                                 STA00580
         LA    R5,&X                                                    STA00590
         DIAG  R4,R11,DGEXT                                             STA00600
         LA    R11,1+&X.(,R11)                                          STA00610
         BR    R8                                                       STA00620
         MEND                                                           STA00630
         MACRO                                                          STA00640
&LAB     LINEDIT &WHICH                                                 STA00650
&LAB     LA    R4,&WHICH                                                STA00660
         LA    R5,1                                                     STA00670
         DIAG  R4,R11,DGEXT                                             STA00680
         CLI   0(R11),X'00'                                             STA00690
         BE    OFF                                                      STA00700
         LA    R11,2(,R11)                                              STA00710
         BR    R8                                                       STA00720
         MEND                                                           STA00730
         EJECT                                                          STA00740
STACK    CSECT                                                          STA00750
         STM   R14,R12,12(R13)     SAVE REGS                            STA00760
         USING STACK,R15                                                STA00770
         LA    R14,SAVE       OUR SAVE AREA                             STA00780
         ST    R14,8(,R13)    CHAIN FWD                                 STA00790
         ST    R13,4(,R14)    CHAIN BACK                                STA00800
         LR    R13,R14                                                  STA00810
         DROP  R15                                                      STA00820
         USING SAVE,R13                                                 STA00830
         B     GO                                                       STA00840
SAVE     DS    18D                                                      STA00850
GO       LA    R1,8(,R1)      SKIP MODULE NAME                          STA00860
         LA    R11,BUF        GET OUTPUT BUF PTR                        STA00870
         MVI   0(R11),C' '    CLEAR BUFFER                              STA00880
         MVC   1(L'BUF-1,R11),0(R11)                                    STA00890
* PER PARAMETER LOOP                                                    STA00900
PLOOP    CLI   0(R1),X'FF'    LAST PARM ?                               STA00910
         BE    RET            YES,RETURN                                STA00920
         LA    R2,CMDTAB      FIND FIRST COMMAND NAME                   STA00930
* PER COMMAND LOOP                                                      STA00940
CLOOP    CLI   0(R2),X'FF'    LAST COMMAND?                             STA00950
         BE    BADCMD         YES, UNKNOWN COMMAND                      STA00960
         CLC   0(8,R1),0(R2)  FOUND COMMAND?                            STA00970
         BNE   NEXTC          NOPE, TRY NEXT                            STA00980
         L     R9,8(,R2)      GET COMMAND ADDR                          STA00990
         LA    R1,8(,R1)      BUMP ARG PTR                              STA01000
         BALR  R8,R9          GO DO COMMAND                             STA01010
         B     PLOOP          NEXT PARM                                 STA01020
NEXTC    LA    R2,12(,R2)     BUMP TO NEXT ENTRY                        STA01030
         B     CLOOP          TRY NEXT                                  STA01040
BADCMD   MVI   0(R11),C'?'    INDICATE BAD COMMAND                      STA01050
         LA    R11,2(,R11)                                              STA01060
         LA    R1,8(,R1)      TRY NEXT                                  STA01070
         B     PLOOP                                                    STA01080
         SPACE                                                          STA01090
* SNAPPY ANSWERS                                                        STA01100
UNKN3    LA    R1,8(,R1)                                                STA01110
UNKN2    LA    R1,8(,R1)                                                STA01120
UNKN1    LA    R1,8(,R1)                                                STA01130
UNKNOWN  MVI   0(R11),C'?'    UNKNOWN ITEM                              STA01140
         LA    R11,2(,R11)    BUMP OUT PTR                              STA01150
         BR    R8             END COMMAND                               STA01160
         SPACE                                                          STA01170
YES1     LA    R1,8(,R1)                                                STA01180
YES      MOVE  =C'YES',3                                                STA01190
         BR    R8             RETURN                                    STA01200
         SPACE                                                          STA01210
NO1      LA    R1,8(,R1)                                                STA01220
NO       MOVE  =C'NO',2                                                 STA01230
         BR    R8             RETURN                                    STA01240
ON       MOVE  =C'ON',2                                                 STA01250
         BR    R8             RETURN                                    STA01260
OFF      MOVE  =C'OFF',3                                                STA01270
         BR    R8             RETURN                                    STA01280
         SPACE                                                          STA01290
* FORMAT A NUMBER                                                       STA01300
NUMBER   ST    R2,12(,R13)    SAVE A REG                                STA01310
         MVI   NEGFLAG,0      INIT FLAG                                 STA01320
         LTR   R0,R0          NEGATIVE NUMBER?                          STA01330
         BNM   NUMBERA        NO, BRANCH                                STA01340
         MVI   NEGFLAG,1         YES, SET FLAG                          STA01350
         LPR   R0,R0          MAKE IT POSITIVE                          STA01360
NUMBERA  CVD   R0,DOUBLE      GET DECIMAL                               STA01370
         MVC   0(8,R11),=X'4020202020202121'  PIC(ZZZZZZ9)              STA01380
         ED    0(8,R11),DOUBLE+4     7 DIGITS POSSIBLE                  STA01390
         TM    NEGFLAG,1         WAS NUMBER NEGATIVE                    STA01400
         BZ    NUMBERD        NO, SKIP CRUD                             STA01410
         LR    R2,R11         FIND OUTPUT NUM BEGINNING                 STA01420
NUMBERB  CLI   1(R2),C' '     BEGINNING OF NUMBER?                      STA01430
         BNE   NUMBERC        YES, BRANCH                               STA01440
         LA    R2,1(,R2)      TRY NEXT                                  STA01450
         B     NUMBERB        GO BACK                                   STA01460
NUMBERC  MVI   0(R2),C'-'     MOVE IN MINUS SIGN                        STA01470
NUMBERD  LA    R11,9(,R11)                                              STA01480
         L     R2,12(,R13)    RESTORE REG                               STA01490
         BR    R7             RETURN                                    STA01500
         SPACE                                                          STA01510
* FORMAT A HEX NUMBER AND LEAVE IT IN HEXOUT                            STA01520
FMTHEX   STM   R2,R6,12(R13)  SAVE SOME REGS                            STA01530
         LR    R3,R0          GET ARG                                   STA01540
         LA    R4,HEXOUT      GET OUTPUT ADDR                           STA01550
         LA    R5,8           DIGIT COUNT                               STA01560
FMTHXLP  SR    R2,R2          ZEROFY R2                                 STA01570
         SLDL  R2,4           GET NEXT HEX DIGIT VALUE                  STA01580
         LA    R6,HEXCHARS(R2)     GET ADDR OF CHAR                     STA01590
         MVC   0(1,R4),0(R6)  MOVE CHAR                                 STA01600
         LA    R4,1(,R4)      BUMP OUTPUT                               STA01610
         BCT   R5,FMTHXLP     DO IT AGAIN                               STA01620
         LM    R2,R6,12(R13)  RESTORE REGS                              STA01630
         BR    R7             RETURN                                    STA01640
HEXCHARS DC    C'0123456789ABCDEF' HEX CHARACTERS                       STA01650
         SPACE                                                          STA01660
* GET A DECIMAL NUMBER FROM PARM LIST                                   STA01670
GETNUM   STM   R2,R4,12(R13)  SAVE REGS                                 STA01680
         LR    R2,R1          GET PARM PTR                              STA01690
         LA    R3,8           GET COUNT                                 STA01700
         SR    R0,R0          ZERO ACCUM                                STA01710
         SR    R4,R4          FOR IC                                    STA01720
         MVI   NEGFLAG,0      INIT FLAG                                 STA01730
         CLI   0(R2),C'-'     NEGATIVE NUMBER?                          STA01740
         BNE   GETNMLP        NO, GET NUMBER                            STA01750
         MVI   NEGFLAG,1      YES, SET FLAG                             STA01760
         LA    R2,1(,R2)      SKIP MINUS SIGN                           STA01770
         BCTR  R3,0           DECREASE COUNT                            STA01780
GETNMLP  CLI   0(R2),C' '     END OF NUMBER?                            STA01790
         BE    GETNMF         YES, BRANCH                               STA01800
         IC    R4,0(,R2)      GET CHAR                                  STA01810
         IC    R4,HEXTAB(R4)     GET NUMERIC EQUIV                      STA01820
         CL    R4,=F'10'      VALID DECIMAL DIGIT?                      STA01830
         BNL   HORRIBLE       NO, BRANCH                                STA01840
         MH    R0,=H'10'      SHIFT PREV NUM                            STA01850
         AR    R0,R4          ADD IN THIS DIGIT                         STA01860
         LA    R2,1(,R2)      POINT AT NEXT DIGIT                       STA01870
         BCT   R3,GETNMLP     GO BACK FOR MORE                          STA01880
GETNMF   LM    R2,R4,12(R13)  RESTORE REGS                              STA01890
         TM    NEGFLAG,1      NEGATIVE NUMBER?                          STA01900
         BZR   R7             NO, RETURN                                STA01910
         LNR   R0,R0          YES, NEGATE                               STA01920
         BR    R7             RETURN                                    STA01930
         SPACE                                                          STA01940
* GET A HEX NUMBER FROM PARM LIST                                       STA01950
GETHEX   STM   R2,R4,12(R13)  SAVE REGS                                 STA01960
         SR    R0,R0          ZIP ACCUM                                 STA01970
         LR    R2,R1          GET START OF NUMBER                       STA01980
         LA    R3,8           GET MAX DIGITS                            STA01990
         SR    R4,R4          ZERO FOR IC                               STA02000
GETHXLP  CLI   0(R2),C' '     END OF NUMBER?                            STA02010
         BE    GETHXF         YES, GET OUT                              STA02020
         IC    R4,0(,R2)      GET CHAR                                  STA02030
         IC    R4,HEXTAB(R4)  GET HEX EQUIV                             STA02040
         C     R4,=F'16'      BAD CHAR?                                 STA02050
         BNL   HORRIBLE       YES, GIVE ERROR                           STA02060
         SLL   R0,4           SHIFT PREVIOUS DIGITS                     STA02070
         OR    R0,R4          PUT IN THIS DIGIT                         STA02080
         LA    R2,1(,R2)      BUMP TO NEXT DIGIT                        STA02090
         BCT   R3,GETHXLP     DO NEXT                                   STA02100
GETHXF   LM    R2,R4,12(R13)  SAVE REGS                                 STA02110
         BR    R7             RETURN                                    STA02120
HEXTAB   DC    256X'FF'                                                 STA02130
         ORG   HEXTAB+C'A'                                              STA02140
         DC    X'0A0B0C0D0E0F'                                          STA02150
         ORG   HEXTAB+C'0'                                              STA02160
         DC    X'00010203040506070809'                                  STA02170
         ORG   ,                                                        STA02180
         SPACE                                                          STA02190
* MAIN RETURN                                                           STA02200
RET      STACK BUF            STACK OUTPUT LINE                         STA02210
RETURN   L     R13,4(,R13)    GO AWAY HAPPY                             STA02220
         RETURN (14,12),RC=0   BYE !                                    STA02230
HORRIBLE WRTERM 'INVALID ARGUMENTS TO STACK MODULE'                     STA02240
         B     RETURN                                                   STA02250
         EJECT                                                          STA02260
* DATA AREAS                                                            STA02270
CMDTAB   DS    0F                                                       STA02280
         DC    CL8'LITERAL',A(LITERAL)  MOVE ARG TO OUTPUT              STA02290
         DC    CL8'HEX',A(HEX)     DECIMAL TO HEX                       STA02300
         DC    CL8'DECIMAL',A(DECIMAL)  HEX TO DECIMAL                  STA02310
         DC    CL8'PRODUCT',A(PRODUCT)  PRODUCT                         STA02320
         DC    CL8'QUOTIENT',A(QUOTIENT)                                STA02330
         DC    CL8'REMAINDE',A(MOD)     REMAINDER                       STA02340
         DC    CL8'RANDOM',A(RANDOM)                                    STA02350
* CP STUFF                                                              STA02360
         DC    CL8'DATE',A(DATE)   DATE IN FORM MM/DD/YY                STA02370
         DC    CL8'TIME',A(TIME)    TIME IN FORM HH:MM:SS               STA02380
         DC    CL8'USERID',A(USERID)    USERID                          STA02390
         DC    CL8'QSTORE',A(USERID)      "                             STA02400
         DC    CL8'USTORE',A(USERID)      "                             STA02410
         DC    CL8'ACCOUNT',A(SUBID)    SUBID                           STA02420
         DC    CL8'SUBID',A(SUBID)   "                                  STA02430
         DC    CL8'DIST',A(DIST)   DISTRIBUTION CODE                    STA02440
         DC    CL8'DEST',A(DIST)                                        STA02450
         DC    CL8'MSG',A(MSG)     CP SET MSG                           STA02460
         DC    CL8'WNG',A(WNG)     CP SET WNG                           STA02470
         DC    CL8'ACNT',A(ACNT)   CP SET ACNT                          STA02480
         DC    CL8'IMSG',A(IMSG)   CP SET IMSG                          STA02490
         DC    CL8'LINEDIT',A(LINEDIT)  CP SET LINEDIT                  STA02500
         DC    CL8'RUN',A(RUN)     CP SET RUN                           STA02510
         DC    CL8'ISAM',A(ISAM)   CP SET ISAM                          STA02520
         DC    CL8'ECMODE',A(ECMODE)    CP SET ECMODE                   STA02530
         DC    CL8'PAGEX',A(PAGEX) CP SET PAGEX                         STA02540
         DC    CL8'AUTOPOLL',A(AUTOPOLL)     CP SET AUTOPOLL            STA02550
         DC    CL8'NOTRANS',A(NOTRANS)  CP SET NOTRANS                  STA02560
         DC    CL8'EMSG',A(EMSG)   CP SET EMSG                          STA02570
         DC    CL8'ASSIST',A(ASSIST)    CP SET ASSIST                   STA02580
         DC    CL8'TIMER',A(TIMER$) CP SET TIMER                        STA02590
         DC    CL8'CPUID',A(CPUID) CP SET CPUID                         STA02600
         DC    CL8'CHAN',A(CHAN)   CP DEF CHAN                          STA02610
         DC    CL8'MODE',A(MODE)     CP TERM MODE                       STA02620
         DC    CL8'LINEND',A(LINEND)    CP TERM LINEND                  STA02630
         DC    CL8'LINEDEL',A(LINEDEL)  CP TERM LINEDEL                 STA02640
         DC    CL8'CHARDEL',A(CHARDEL)  CP TERM CHARDEL                 STA02650
         DC    CL8'ESCAPE',A(ESCAPE)    CP TERM ESCAPE                  STA02660
         DC    CL8'LINESIZE',A(LSIZE)   CONSOLE LINESIZE                STA02670
         DC    CL8'STORAGE',A(STORAGE)  STORAGE IN K-BYTES              STA02680
         DC    CL8'DISCON',A(DISCON)    DISCONNECTED (YES/NO)           STA02690
         DC    CL8'PUNFILES',A(PUNFILES)                                STA02700
         DC    CL8'PRTFILES',A(PRTFILES)                                STA02710
         DC    CL8'TDISK',A(TDISK)                                      STA02720
         DC    CL8'DEVTYPE',A(DVTYPE)                                   STA02730
         DC    CL8'GRAF',A(GRAF)                                        STA02740
         DC    CL8'DASD',A(DASD)                                        STA02750
         DC    CL8'TAPES',A(TAPES)                                      STA02760
         DC    CL8'LINES',A(LINES)                                      STA02770
         DC    CL8'UR',A(UR)                                            STA02780
* CMS STUFF                                                             STA02790
         DC    CL8'BLIP',A(BLIP)                                        STA02800
         DC    CL8'IMPEX',A(IMPEX)                                      STA02810
         DC    CL8'IMPCP',A(IMPCP)                                      STA02820
         DC    CL8'ABBREV',A(ABBREV)                                    STA02830
         DC    CL8'RELPAGE',A(RELPAGE)                                  STA02840
         DC    CL8'AUTOREAD',A(AUTOREAD)                                STA02850
         DC    CL8'REDTYPE',A(REDTYPE)                                  STA02860
         DC    CL8'PROTECT',A(PROTECT)                                  STA02870
         DC    CL8'DOS',A(DOS)                                          STA02880
         DC    CL8'DOSVSAM',A(VSAMDOS)                                  STA02890
         DC    CL8'UPSI',A(GETUPSI)                                     STA02900
         DC    CL8'OPTION',A(OPTION)                                    STA02910
         DC    CL8'DOSPART',A(DOSPART)                                  STA02920
         DC    CL8'SUBSET',A(SUBSET)                                    STA02930
         DC    CL8'RDYMSG',A(RDYMSG)                                    STA02940
         DC    CL8'LDRTBLS',A(LDRTBLS)                                  STA02950
         DC    CL8'MACLIB',A(MACLIB)    MACLIB LIST                     STA02960
         DC    CL8'MACLIBS',A(MACLIB)                                   STA02970
         DC    CL8'TXTLIB',A(TXTLIB)    TXTLIB LIST                     STA02980
         DC    CL8'TXTLIBS',A(TXTLIB)                                   STA02990
         DC    CL8'DOSLIB',A(DOSLIB)    DOSLIB LIST                     STA03000
         DC    CL8'DOSLIBS',A(DOSLIB)                                   STA03010
         DC    CL8'FST',A(FSTINFO) RECFM,LRECL,#RECS                    STA03020
         DC    CL8'QUALIFY',A(QUALIFY)                                  STA03030
         DC    CL8'QFILEDEF',A(QFILEDEF)                                STA03040
         DC    CL8'QDLBL',A(QDLBL)                                      STA03050
         DC    CL8'DADDR',A(DADDR)                                      STA03060
         DC    CL8'DMODE',A(DMODE)                                      STA03070
         DC    CL8'LABEL',A(LABEL)                                      STA03080
         DC    CL8'SYSNAMES',A(SYSNAMES)                                STA03090
         DC    F'-1'                                                    STA03100
DOUBLE   DS    D                                                        STA03110
DATETIME DS    4D             DATE AND TIME FROM CP                     STA03120
EXTID    DS    CL24           EXTENDED IDENT WORK AREA                  STA03130
SFB      DS    12D            SPACE FOR SPOOL FILE BLOCK                STA03140
DIAG24   DS    0F             SPACE FOR DIAGNOSE 24 RESULT              STA03150
VDVTYPC  DS    X                                                        STA03160
VDVTYPE  DS    X                                                        STA03170
VDVSTAT  DS    X                                                        STA03180
VDVFLAG  DS    X                                                        STA03190
RDVTYPC  DS    X                                                        STA03200
RDVTYPE  DS    X                                                        STA03210
RDVMDL   DS    X                                                        STA03220
RDVFTR   DS    X                                                        STA03230
RDVLLEN  EQU   RDVFTR                                                   STA03240
FSCB     DC    11F'0'         SPACE FOR A FSCB                          STA03250
ONOFF    DS    C                                                        STA03260
NEGFLAG  DS    C                                                        STA03270
HEXOUT   DS    D                                                        STA03280
BUF      DS    CL132          THE BUFFER THAT ATE CHICAGO               STA03290
         LTORG                                                          STA03300
         EJECT                                                          STA03310
* INDIVIDUAL ITEM ROUTINES                                              STA03320
         SPACE                                                          STA03330
* 'LITERAL' - COPY NEXT ARG TO OUTPUT                                   STA03340
LITERAL  ITEM  1                                                        STA03350
         MOVE  0(R1),8        MOVE STRING                               STA03360
         OUT                                                            STA03370
         SPACE                                                          STA03380
* 'HEX' - DECIMAL TO HEX CONVERSION                                     STA03390
HEX      ITEM  1                                                        STA03400
         BAL   R7,GETNUM      GET DECIMAL                               STA03410
         BAL   R7,FMTHEX      FORMAT TO HEX                             STA03420
         MOVE  HEXOUT,8       MOVE TO OUTPUT                            STA03430
         OUT                                                            STA03440
         SPACE                                                          STA03450
* 'DECIMAL' - HEX TO DECIMAL CONVERSION                                 STA03460
DECIMAL  ITEM  1                                                        STA03470
         BAL   R7,GETHEX      GET HEX NUMBER                            STA03480
         BAL   R7,NUMBER      OUTPUT DECIMAL NUMBER                     STA03490
         OUT                                                            STA03500
         SPACE                                                          STA03510
* 'PRODUCT' - PRODUCT OF 2 NUMBERS                                      STA03520
PRODUCT  ITEM  1                                                        STA03530
         BAL   R7,GETNUM      GET FIRST NUMBER                          STA03540
         LR    R3,R0          MOVE TO MULT REG                          STA03550
         LA    R1,8(,R1)      BUMP TO NEXT ARG                          STA03560
         BAL   R7,GETNUM      GET SECOND NUMBER                         STA03570
         MR    R2,R0          MULTIPLY                                  STA03580
         LR    R0,R3          PASS PRODUCT AS ARG                       STA03590
         BAL   R7,NUMBER      FORMAT AND OUTPUT NUMBER                  STA03600
         OUT                                                            STA03610
         SPACE                                                          STA03620
* 'QUOTIENT' - QUOTIENT OF 2 NUMBERS                                    STA03630
QUOTIENT ITEM  1                                                        STA03640
         BAL   R7,GETNUM      GET FIRST NUMBER                          STA03650
         LR    R2,R0          MOVE TO DOUBLE REG                        STA03660
         SRDA  R2,32          SIGN EXTEND                               STA03670
         LA    R1,8(,R1)      NEXT ARG                                  STA03680
         BAL   R7,GETNUM      GET SECOND NUMBER                         STA03690
         LTR   R0,R0          IS DIVISOR ZERO?                          STA03700
         BZ    UNKN1          YES, ERROR                                STA03710
         DR    R2,R0          DIVIDE                                    STA03720
         LR    R0,R3          PASS QUOTIENT                             STA03730
         BAL   R7,NUMBER                                                STA03740
         OUT                                                            STA03750
         SPACE                                                          STA03760
* 'REMAINDER' - REMAINDER OF A DIVIDED BY B                             STA03770
MOD      ITEM  1                                                        STA03780
         BAL   R7,GETNUM      GET FIRST NUMBER                          STA03790
         LR    R2,R0          MOVE TO DOUBLE REG                        STA03800
         SRDA  R2,32          SIGN EXTEND                               STA03810
         LA    R1,8(,R1)      NEXT ARG                                  STA03820
         BAL   R7,GETNUM      GET SECOND NUMBER                         STA03830
         LTR   R0,R0          IS DIVISOR ZERO?                          STA03840
         BZ    UNKN1          YES, ERROR                                STA03850
         DR    R2,R0          DIVIDE                                    STA03860
         LR    R0,R2          PASS REMAINDER                            STA03870
         BAL   R7,NUMBER      FORMAT AND OUTPUT NUMBER                  STA03880
         OUT                                                            STA03890
         SPACE                                                          STA03900
* 'RANDOM' - RANDOM INTEGER BETWEEN 1 AND N                             STA03910
RANDOM   ITEM  1                                                        STA03920
         STCK  DOUBLE           GET CLOCK VALUE                         STA03930
         LM    R2,R3,DOUBLE     LOAD INTO REG PAIR                      STA03940
         SRDA  R2,12          SHIFT OUT UNUSED BITS                     STA03950
         SR    R2,R2          CLEAR HIGH BITS                           STA03960
         BAL   R7,GETNUM      GET MAX VAL                               STA03970
         LTR   R0,R0          IS ARG POSITIVE?                          STA03980
         BNP   UNKN1          NO, BRANCH                                STA03990
         DR    R2,R0          DIVIDE (REM IN R2)                        STA04000
         A     R2,=F'1'                                                 STA04010
         LR    R0,R2          PASS ARG                                  STA04020
         BAL   R7,NUMBER      OUTPUT                                    STA04030
         OUT                                                            STA04040
         EJECT                                                          STA04050
* CP INFORMATION                                                        STA04060
         USING VMBLOK,0       FOR VMBLOK OFFSETS                        STA04070
         SPACE                                                          STA04080
* 'DATE' - DATE IN FORM MM/DD/YY                                        STA04090
DATE     ITEM  0                                                        STA04100
         LA    R4,DATETIME    ADDRESS WORK AREA                         STA04110
         DIAG  R4,0,DGTMR   PSUEDO-TIMER DIAGNOSE                       STA04120
         MOVE  DATETIME,8     MOVE DATE                                 STA04130
         OUT                                                            STA04140
         SPACE                                                          STA04150
* 'TIME' - TIME IN FORM HH:MM:SS                                        STA04160
TIME     ITEM  0                                                        STA04170
         LA    R4,DATETIME    WORK AREA                                 STA04180
         DIAG  R4,0,DGTMR   PSUEDO-TIMER DIAGNOSE                       STA04190
         MOVE  DATETIME+8,8   MOVE TIME                                 STA04200
         OUT                                                            STA04210
         SPACE                                                          STA04220
* 'USERID', 'USTORE', OR 'QSTORE' - VM USERID                           STA04230
USERID   ITEM  0                                                        STA04240
         LA    R4,EXTID       WORK AREA                                 STA04250
         LA    R5,L'EXTID     AND LENGTH                                STA04260
         DIAG  R4,R5,DGID  EXTENDED IDENT DIAGNOSE                      STA04270
         MOVE  EXTID+16,8     MOVE USERID                               STA04280
         OUT                                                            STA04290
         SPACE                                                          STA04300
* 'ACCOUNT', 'SUBID' - PRINCETON SUBID OR VM ACCOUNT NUMBER             STA04310
SUBID    ITEM  0                                                        STA04320
         VMCOPY VMACNT                                                  STA04330
         SPACE                                                          STA04340
* 'DIST' - DISTRIBUTION CODE                                            STA04350
DIST     ITEM  0                                                        STA04360
         VMCOPY VMDIST                                                  STA04370
         SPACE                                                          STA04380
* REPLIES OF ON OR OFF                                                  STA04390
MSG      ITEM  0              CP SET MSG                                STA04400
         ONOFF VMMLEVEL,VMMSGON                                         STA04410
WNG      ITEM  0              CP SET WNG                                STA04420
         ONOFF VMMLEVEL,VMWNGON                                         STA04430
ACNT     ITEM  0              CP SET ACNT                               STA04440
         ONOFF VMMLEVEL,VMMACCON                                        STA04450
IMSG     ITEM  0              CP SET IMSG                               STA04460
         ONOFF VMMLVL2,VMMIMSG                                          STA04470
LINEDIT  ITEM  0              CP SET LINEDIT                            STA04480
         ONOFF VMMLEVEL,VMMLINED                                        STA04490
RUN      ITEM  0              CP SET RUN                                STA04500
         ONOFF VMOSTAT,VMCFRUN                                          STA04510
ISAM     ITEM  0              CP SET ISAM                               STA04520
         ONOFF VMPSTAT,VMISAM                                           STA04530
ECMODE   ITEM  0              CP SET ECMODE                             STA04540
         ONOFF VMPSTAT,VMV370R                                          STA04550
PAGEX    ITEM  0              CP SET PAGEX                              STA04560
         ONOFF VMPSTAT,VMPAGEX                                          STA04570
AUTOPOLL ITEM  0              CP SET AUTOPOLL                           STA04580
         ONOFF VMFSTAT,VMFAUTO                                          STA04590
NOTRANS  ITEM  0              CP SET NOTRANS (FOR V=R USERS)            STA04600
         ONOFF VMPSTAT,VMNOTRAN                                         STA04610
         SPACE                                                          STA04620
* 'EMSG' - CP SET EMSG ON/OFF/TEXT/CODE                                 STA04630
EMSG     ITEM  0                                                        STA04640
         LA    R4,VMMLEVEL    FLAG BYTE OFFSET                          STA04650
         LA    R5,1           LENGTH                                    STA04660
         LA    R6,ONOFF       WORK BYTE ADDR                            STA04670
         DIAG  R4,R6,DGEXT  EXTRACT BYTE                                STA04680
         TM    ONOFF,VMMCODE+VMMTEXT                                    STA04690
         BO    ON                                                       STA04700
         BZ    OFF                                                      STA04710
         TM    ONOFF,VMMCODE  ONLY CODE ?                               STA04720
         BO    EMSGCODE       YES, BRANCH                               STA04730
         MOVE  =C'TEXT',4     MUST BE TEXT                              STA04740
         BR    R8             RETURN                                    STA04750
EMSGCODE MOVE  =C'CODE',4     MUST BE CODE                              STA04760
         OUT                                                            STA04770
         SPACE                                                          STA04780
* 'ASSIST' - CP SET ASSIST OFF/(ON SVC/NOSVC)                           STA04790
ASSIST   ITEM  0                                                        STA04800
         LA    R4,VMMCR6      BYTE OFFSET                               STA04810
         LA    R5,1           AND LENGTH                                STA04820
         LA    R6,ONOFF       WORK BYTE                                 STA04830
         DIAG  R4,R6,DGEXT  EXTRACT                                     STA04840
         TM    ONOFF,VMMFE    ASSIST ON ?                               STA04850
         BZ    OFF            NO, GIVE OFF                              STA04860
         LA    R4,VMESTAT     GET VMESTAT BYTE                          STA04870
         LA    R5,1           LENGTH                                    STA04880
         LA    R6,ONOFF                                                 STA04890
         DIAG  R4,R6,DGEXT  EXTRACT                                     STA04900
         TM    ONOFF,VMMICSVC SVC ASSIST ?                              STA04910
         BO    ONSVC          YES, BRANCH                               STA04920
         MOVE  =C'ON NOSVC',8 MOVE RESULT                               STA04930
         BR    R8             RETURN                                    STA04940
ONSVC    MOVE  =C'ON SVC',6   MOVE RESULT                               STA04950
         OUT   ,              RETURN                                    STA04960
         SPACE                                                          STA04970
* 'TIMER' - CP SET TIMER ON/OFF/REAL                                    STA04980
TIMER$   ITEM  0                                                        STA04990
         LA    R4,VMTLEVEL    GET VMTLEVEL                              STA05000
         LA    R5,1                                                     STA05010
         LA    R6,ONOFF                                                 STA05020
         DIAG  R4,R6,DGEXT  EXTRACT                                     STA05030
         TM    ONOFF,VMRON    REAL TIMER?                               STA05040
         BO    TIMEREAL       YES, BRANCH                               STA05050
         TM    ONOFF,VMTON    ON?                                       STA05060
         BO    ON             YES, BRANCH TO ON                         STA05070
         B     OFF            NO, BRANCH TO OFF                         STA05080
TIMEREAL MOVE  =C'REAL',4     SAY 'REAL'                                STA05090
         OUT                                                            STA05100
         SPACE                                                          STA05110
* 'CPUID' - CP SET CPUID                                                STA05120
CPUID    ITEM  0                                                        STA05130
         STIDP DOUBLE         GET CPUID                                 STA05140
         L     R0,DOUBLE      GET SERIAL                                STA05150
         BAL   R7,FMTHEX      FORMAT IT                                 STA05160
         MOVE  HEXOUT+2,6     MOVE 6 DIGIT SERIAL NUMBER                STA05170
         OUT                                                            STA05180
         SPACE                                                          STA05190
* 'CHAN' - CP DEF CHAN SEL/BMX                                          STA05200
CHAN     ITEM  0                                                        STA05210
         LA    R4,VMFSTAT     EXTRACT VMFSTAT                           STA05220
         LA    R5,1                                                     STA05230
         LA    R6,ONOFF                                                 STA05240
         DIAG  R4,R6,DGEXT  .                                           STA05250
         TM    ONOFF,VMFBMX   BMX?                                      STA05260
         BO    CHANBMX        YES, BRANCH                               STA05270
         MOVE  =C'SEL',3      SELECTOR                                  STA05280
         BR    R8             RETURN                                    STA05290
CHANBMX  MOVE  =C'BMX',3      BMX                                       STA05300
         OUT                                                            STA05310
         SPACE                                                          STA05320
* 'MODE' - CP TERM MODE CP/VM                                           STA05330
MODE     ITEM  0                                                        STA05340
         LA    R4,VMMLEVEL    EXTRACT VMMLEVEL BYTE                     STA05350
         LA    R5,1                                                     STA05360
         LA    R6,ONOFF       INTO ONOFF                                STA05370
         DIAG  R4,R6,DGEXT                                              STA05380
         TM    ONOFF,VMMCPENV CP?                                       STA05390
         BO    MODECP         YES, BRANCH                               STA05400
         MOVE  =C'VM',2    VM                                           STA05410
         BR    R8             RETURN                                    STA05420
MODECP   MOVE  =C'CP',2       CP                                        STA05430
         OUT                                                            STA05440
         SPACE                                                          STA05450
* 'LINESIZE' - CP TERM LINESIZE                                         STA05460
LSIZE    ITEM  0                                                        STA05470
         L     R4,=F'-1'      INDICATE CONSOLE                          STA05480
         DIAG  R4,R5,DGDVINFO  GET DEVICE INFO                          STA05490
         N     R6,=F'255'     EXTRACT LINESIZE                          STA05500
         LR    R0,R6          PASS ARG                                  STA05510
         BAL   R7,NUMBER      FORMAT NUMBER                             STA05520
         OUT                                                            STA05530
         SPACE                                                          STA05540
* 'LINEND' - CP TERM LINEND                                             STA05550
LINEND   ITEM  0                                                        STA05560
         LINEDIT VMTLEND                                                STA05570
         SPACE                                                          STA05580
* 'LINEDEL' - CP TERM LINEDEL                                           STA05590
LINEDEL  ITEM  0                                                        STA05600
         LINEDIT VMTLDEL                                                STA05610
         SPACE                                                          STA05620
* 'CHARDEL' - CP TERM CHARDEL                                           STA05630
CHARDEL  ITEM  0                                                        STA05640
         LINEDIT VMTCDEL                                                STA05650
         SPACE                                                          STA05660
* 'ESCAPE' - CP TERM ESCAPE                                             STA05670
ESCAPE   ITEM  0                                                        STA05680
         LINEDIT VMTESCP                                                STA05690
         SPACE                                                          STA05700
* 'STORAGE' - STORAGE IN K-BYTES                                        STA05710
STORAGE  ITEM  0                                                        STA05720
         DIAG  R0,0,DGSTOR   GET BYTES OF STORAGE                       STA05730
         SRL   R0,10          DIVIDE BY 1K                              STA05740
         BAL   R7,NUMBER      OUTPUT NUMBER                             STA05750
         OUT   ,              RETURN                                    STA05760
         SPACE                                                          STA05770
DISCON   ITEM  0                                                        STA05780
         LA    R4,VMOSTAT     EXTRACT VMOSTAT BYTE                      STA05790
         LA    R5,1                                                     STA05800
         LA    R6,ONOFF                                                 STA05810
         DIAG  R4,R6,DGEXT                                              STA05820
         TM    ONOFF,VMDISC   DISCONNECTED?                             STA05830
         BO    YES            YES, GIVE YES                             STA05840
         B     NO             NO, GIVE NO                               STA05850
         SPACE                                                          STA05860
* 'PUNFILES' - GIVE FILE IDS OF PUNCH FILES IN READER                   STA05870
PUNFILES ITEM  0                                                        STA05880
         LA    R3,8           CODE FOR PUNCH FILES                      STA05890
         B     RDRFILES       GO  TO COMMON ROUTINE                     STA05900
         SPACE                                                          STA05910
* 'PRTFILES' - GIVE FILE IDS OF PRINTER FILES IN READER                 STA05920
PRTFILES ITEM  0                                                        STA05930
         LA    R3,4           CODE FOR PRINTER FILES                    STA05940
         SPACE                                                          STA05950
* COMMON ROUTINE FOR READER FILES                                       STA05960
RDRFILES BALR  R9,0           GET ADDRESSABILITY                        STA05970
         USING *,R9           TELL ASSEMBLER                            STA05980
         LA    R4,SFB         GET WORK BLOCK ADDR                       STA05990
         USING SFBLOK,R4      ADDRESS IT                                STA06000
         LA    R2,X'00C'      READER ADDRESS                            STA06010
FILELP   DIAG  R4,R2,DGSPOOL  GET SPOOL FILE INFO                       STA06020
         BNZR  R8             RETURN IF BAD CC                          STA06030
         LH    R0,SFBFILID    GET FILE ID                               STA06040
         BAL   R7,NUMBER      FORMAT IT                                 STA06050
         B     FILELP         GO BACK FOR MORE                          STA06060
         SPACE                                                          STA06070
* 'TDISK' - YES IF ARG IS TEMP DISK, NO OTHERWISE                       STA06080
TDISK    ITEM  1                                                        STA06090
         BAL   R7,GETHEX      GET DISK ADDR                             STA06100
         DIAG  R0,R2,DGDVINFO  GET DEV INFO                             STA06110
         BNZ   NO1            BRANCH IF DEV NOT FOUND                   STA06120
         STM   R2,R3,DIAG24   SAVE IT                                   STA06130
         TM    VDVTYPC,CLASDASD    DASD?                                STA06140
         BZ    NO1            NO, BRANCH                                STA06150
         TM    VDVFLAG,VDEVTDSK    TDISK?                               STA06160
         BO    YES1           YES, SAY YES                              STA06170
         B     NO1            NO, SAY NO                                STA06180
         SPACE                                                          STA06190
* 'GRAF' - GRAPHIC CLASS DEVICE NUMBERS                                 STA06200
GRAF     ITEM  0                                                        STA06210
         LA    R6,CLASGRAF    LOAD CLASS CODE                           STA06220
         B     DEVICES        GOTO COMMON                               STA06230
         SPACE                                                          STA06240
* 'DASD' - DASD CLASS DEVICE NUMBERS                                    STA06250
DASD     ITEM  0                                                        STA06260
         LA    R6,CLASDASD    LOAD CLASS CODE                           STA06270
         B     DEVICES        GOTO COMMON                               STA06280
         SPACE                                                          STA06290
* 'TAPES' - TAPE CLASS DEVICE NUMBERS                                   STA06300
TAPES    ITEM  0                                                        STA06310
         LA    R6,CLASTAPE    LOAD CLASS CODE                           STA06320
         B     DEVICES        GOTO COMMON                               STA06330
         SPACE                                                          STA06340
* 'LINES' - TERMINAL CLASS DEVICE NUMBERS                               STA06350
LINES    ITEM  0                                                        STA06360
         LA    R6,CLASTERM    LOAD CLASS CODE                           STA06370
         B     DEVICES        GOTO COMMON                               STA06380
         SPACE                                                          STA06390
* 'UR' - UNIT RECORD CLASS DEVICE NUMBERS                               STA06400
UR       ITEM  0                                                        STA06410
         LA    R6,CLASURI+CLASURO  LOAD CLASS CODE                      STA06420
         B     DEVICES        GOTO COMMON                               STA06430
         SPACE                                                          STA06440
* COMMON ROUTINE FOR DEVICE CLASSES                                     STA06450
DEVICES  BALR  R9,0           GET ADDRESSABILITY                        STA06460
         USING *,R9           TELL ASSEMBLER                            STA06470
         SR    R2,R2          ZERO UNIT ADDR                            STA06480
NXTCHAN  TCH   0(R2)          DOES CHAN EXIST?                          STA06490
         BC    CC3,BMPCHAN    NO, DO NEXT CHAN                          STA06500
         LA    R3,256         DEVICES/CHANNEL                           STA06510
NXTDEV   DIAG  R2,R4,DGDVINFO GET DEV INFO                              STA06520
         BC    CC3,BMPDEV     NO, DO NEXT                               STA06530
         STM   R4,R5,DIAG24   SAVE INFO                                 STA06540
         EX    R6,DEVTM       RIGHT CLASS?                              STA06550
         BZ    BMPDEV         NO, NEXT DEV                              STA06560
         LR    R0,R2          YES, PASS ADDR                            STA06570
         BAL   R7,FMTHEX      FORMAT ADDR                               STA06580
         MOVE  HEXOUT+5,3     AND OUTPUT IT                             STA06590
BMPDEV   LA    R2,1(,R2)      BUMP DEV ADDR                             STA06600
         BCT   R3,NXTDEV      DO NEXT                                   STA06610
         B     BMPCHAN2       NEXT CHANNEL                              STA06620
BMPCHAN  LA    R2,256(,R2)    SKIP CHAN                                 STA06630
BMPCHAN2 N     R2,=A(X'00000F00')                                       STA06640
         BNZ   NXTCHAN        BACK FOR MORE                             STA06650
         OUT                                                            STA06660
DEVTM    TM    VDVTYPC,*-*                                              STA06670
         SPACE                                                          STA06680
* 'DEVTYPE' - VIRTUAL DEVICE TYPE                                       STA06690
DVTYPE   ITEM  1                                                        STA06700
         BAL   R7,GETHEX      GET UNIT ADDR                             STA06710
         DIAG  R0,R2,DGDVINFO  GET DEV INFO                             STA06720
         BC    1,UNKN1        BRANCH IF NO VIRT DEV                     STA06730
         STM   R2,R3,DIAG24   SAVE IT                                   STA06740
         LA    R2,CLASSTBL                                              STA06750
CLASSLP  CLC   4(1,R2),VDVTYPC     FOUND CLASS?                         STA06760
         BE    CLASSF         YES, BRANCH                               STA06770
         LA    R2,8(,R2)      BUMP TBL ENTRY                            STA06780
         B     CLASSLP        TRY NEXT                                  STA06790
CLASSF   L     R2,0(,R2)      GET TYPE TBL PTR                          STA06800
TYPELP   CLI   0(R2),X'FF'    LAST ENTRY?                               STA06810
         BE    UNKN1          UNKNOWN TYPE                              STA06820
         CLC   0(1,R2),VDVTYPE     FOUND TYPE?                          STA06830
         BE    TYPEF          YES, BRANCH                               STA06840
         LA    R2,9(,R2)      GET NEXT TYPE                             STA06850
         B     TYPELP                                                   STA06860
TYPEF    MOVE  1(R2),8        MOVE IN TYPE                              STA06870
         OUT                                                            STA06880
CLASSTBL DC    A(TERMTYPE),AL1(CLASTERM)                                STA06890
         DC    A(GRAFTYPE),AL1(CLASGRAF)                                STA06900
         DC    A(URITYPE),AL1(CLASURI)                                  STA06910
         DC    A(UROTYPE),AL1(CLASURO)                                  STA06920
         DC    A(TAPETYPE),AL1(CLASTAPE)                                STA06930
         DC    A(DASDTYPE),AL1(CLASDASD)                                STA06940
         DC    A(SPECTYPE),AL1(CLASSPEC)                                STA06950
TERMTYPE EQU   *                                                        STA06960
         DC    AL1(TYP2700),CL8'2700'                                   STA06970
         DC    AL1(TYPTTY),CL8'TTY'                                     STA06980
         DC    AL1(TYPIBM1),CL8'IBM1'                                   STA06990
         DC    AL1(TYP2741),CL8'2741'                                   STA07000
         DC    AL1(TYP1050),CL8'1050'                                   STA07010
         DC    AL1(TYPUNDEF),CL8'UNDEF'                                 STA07020
         DC    AL1(TYPBSC),CL8'BSC'                                     STA07030
         DC    AL1(TYP3210),CL8'3210'                                   STA07040
         DC    X'FF'                                                    STA07050
GRAFTYPE EQU   *                                                        STA07060
         DC    AL1(TYP2250),CL8'2250'                                   STA07070
         DC    AL1(TYP2260),CL8'2260'                                   STA07080
         DC    AL1(TYP2265),CL8'2265'                                   STA07090
         DC    AL1(TYP3066),CL8'3066'                                   STA07100
         DC    AL1(TYP1053),CL8'1053'                                   STA07110
         DC    AL1(TYP3277),CL8'3277'                                   STA07120
         DC    AL1(TYP3284),CL8'3284'                                   STA07130
         DC    X'FF'                                                    STA07140
URITYPE  EQU   *                                                        STA07150
         DC    AL1(TYP2501),CL8'2501'                                   STA07160
         DC    AL1(TYP2540R),CL8'2540R'                                 STA07170
         DC    AL1(TYP3505),CL8'3505'                                   STA07180
         DC    AL1(TYP1442R),CL8'1442R'                                 STA07190
         DC    AL1(TYP2520R),CL8'2520R'                                 STA07200
         DC    AL1(TYPTIMER),CL8'TIMER'                                 STA07210
         DC    AL1(TYP2495),CL8'2495'                                   STA07220
         DC    AL1(TYP2671),CL8'2671'                                   STA07230
         DC    AL1(TYP1017),CL8'1017'                                   STA07240
         DC    X'FF'                                                    STA07250
UROTYPE  EQU   *                                                        STA07260
         DC    AL1(TYP2540P),CL8'2540P'                                 STA07270
         DC    AL1(TYP3525),CL8'3525'                                   STA07280
         DC    AL1(TYP1442P),CL8'1442P'                                 STA07290
         DC    AL1(TYP2520P),CL8'2520P'                                 STA07300
         DC    AL1(TYP1403),CL8'1403'                                   STA07310
         DC    AL1(TYP3211),CL8'3211'                                   STA07320
         DC    AL1(TYP3203),CL8'3203'                                   STA07330
         DC    AL1(TYP1443),CL8'1443'                                   STA07340
         DC    AL1(TYP1018),CL8'1018'                                   STA07350
         DC    X'FF'                                                    STA07360
TAPETYPE EQU   *                                                        STA07370
         DC    AL1(TYP2401),CL8'2401'                                   STA07380
         DC    AL1(TYP2415),CL8'2415'                                   STA07390
         DC    AL1(TYP2420),CL8'2420'                                   STA07400
         DC    AL1(TYP3420),CL8'3420'                                   STA07410
         DC    AL1(TYP3410),CL8'3410'                                   STA07420
         DC    X'FF'                                                    STA07430
DASDTYPE EQU   *                                                        STA07440
         DC    AL1(TYP2311),CL8'2311'                                   STA07450
         DC    AL1(TYP2314),CL8'2314'                                   STA07460
         DC    AL1(TYP3330),CL8'3330'                                   STA07470
         DC    AL1(TYP3350),CL8'3350'                                   STA07480
         DC    AL1(TYP2305),CL8'2305'                                   STA07490
         DC    AL1(TYP3340),CL8'3340'                                   STA07500
         DC    X'FF'                                                    STA07510
SPECTYPE EQU   *                                                        STA07520
         DC    AL1(TYPCTCA),CL8'CTCA'                                   STA07530
         DC    AL1(TYP3704),CL8'370X'                                   STA07540
         DC    AL1(TYPUNSUP),CL8'UNSUP'                                 STA07550
         DC    X'FF'                                                    STA07560
         EJECT                                                          STA07570
* CMS INFORMATION                                                       STA07580
         USING NUCON,0                                                  STA07590
         SPACE                                                          STA07600
* 'BLIP' - SET BLIP                                                     STA07610
BLIP     ITEM  0                                                        STA07620
         L     R2,AEXTSECT    GET EXTERNAL INTR DATA                    STA07630
         USING EXTSECT,R2     ADDRESS IT                                STA07640
         CLI   TIMCHAR,X'00'  BLIP OFF?                                 STA07650
         BE    OFF            YES, BRANCH                               STA07660
         MOVE  TIMCHAR,8      NO, MOVE IT                               STA07670
         DROP  R2                                                       STA07680
         OUT                                                            STA07690
         SPACE                                                          STA07700
* 'IMPEX' - SET IMPEX                                                   STA07710
IMPEX    ITEM  0                                                        STA07720
         TM    OPTFLAGS,NOIMPEX    IMPEX OFF?                           STA07730
         BO    OFF                                                      STA07740
         B     ON                                                       STA07750
         SPACE                                                          STA07760
* 'IMPCP' - SET IMPCP                                                   STA07770
IMPCP    ITEM  0                                                        STA07780
         TM    OPTFLAGS,NOIMPCP    IMPCP OFF?                           STA07790
         BO    OFF                                                      STA07800
         B     ON                                                       STA07810
         SPACE                                                          STA07820
* 'ABBREV' - SET ABBREV                                                 STA07830
ABBREV   ITEM  0                                                        STA07840
         TM    OPTFLAGS,NOABBREV   ABBREV OFF?                          STA07850
         BO    OFF                                                      STA07860
         B     ON                                                       STA07870
         SPACE                                                          STA07880
* 'RELPAGE' - SET RELPAGE                                               STA07890
RELPAGE  ITEM  0                                                        STA07900
         TM    OPTFLAGS,NOPAGREL   RELPAGE OFF?                         STA07910
         BO    OFF                                                      STA07920
         B     ON                                                       STA07930
         SPACE                                                          STA07940
* 'AUTOREAD' - SET AUTOREAD                                             STA07950
AUTOREAD ITEM  0                                                        STA07960
         TM    OPTFLAGS,NOVMREAD   AUTOREAD OFF?                        STA07970
         BO    OFF                                                      STA07980
         B     ON                                                       STA07990
         SPACE                                                          STA08000
* 'REDTYPE' - SET REDTYPE                                               STA08010
REDTYPE  ITEM  0                                                        STA08020
         TM    MSGFLAGS,REDERRID   REDTYPE ON?                          STA08030
         BO    ON                                                       STA08040
         B     OFF                                                      STA08050
         SPACE                                                          STA08060
* 'PROTECT' - SET PROTECT                                               STA08070
PROTECT  ITEM  0                                                        STA08080
         TM    PROTFLAG,PRFPOFF    PROTECT OFF?                         STA08090
         BO    OFF                                                      STA08100
         B     ON                                                       STA08110
         SPACE                                                          STA08120
* 'DOS' - SET DOS                                                       STA08130
DOS      ITEM  0                                                        STA08140
         TM    DOSFLAGS,DOSMODE    DOS ON?                              STA08150
         BO    ON                                                       STA08160
         B     OFF                                                      STA08170
         SPACE                                                          STA08180
* 'DOSVSAM' - SET DOS (VSAM                                             STA08190
VSAMDOS  ITEM  0                                                        STA08200
         TM    DOSFLAGS,DOSVSAM    VSAM ACTIVE?                         STA08210
         BO    ON                                                       STA08220
         B     OFF                                                      STA08230
         SPACE                                                          STA08240
* 'SYSNAMES' - SHARED SYSTEM NAMES                                      STA08250
SYSNAMES ITEM  0                                                        STA08260
         L     R2,ASYSNAMS    GET POINTER                               STA08270
         MOVE  0(R2),8        CMSSEG                                    STA08280
         MOVE  8(R2),8        CMSVSAM                                   STA08290
         MOVE  16(R2),8       CMSAMS                                    STA08300
         MOVE  24(R2),8       CMSDOS                                    STA08310
         OUT                                                            STA08320
         SPACE                                                          STA08330
* 'UPSI' - SET UPSI                                                     STA08340
GETUPSI  ITEM  0                                                        STA08350
         L     R2,ABGCOM      GET USER COMRG ADDR                       STA08360
         USING BGCOM,R2       ADDRESS IT                                STA08370
         IC    R2,UPSI        GET UPSI BYTE                             STA08380
         DROP  R2                                                       STA08390
         SLL   R2,24          MOVE UPSI TO HIGH BYTE                    STA08400
         LA    R3,8           BIT COUNT                                 STA08410
UPSILP   LTR   R2,R2          BIT ON?                                   STA08420
         BM    UPSI1          YES, BRANCH                               STA08430
         MVI   0(R11),C'0'    MOVE IN ZERO                              STA08440
         B     UPSINXT        BUMP TO NEXT BIT                          STA08450
UPSI1    MVI   0(R11),C'1'    MOVE IN ONE                               STA08460
UPSINXT  SLL   R2,1           GET NEXT BIT                              STA08470
         LA    R11,1(,R11)    BUMP OUTPUT PTR                           STA08480
         BCT   R3,UPSILP      DO NEXT                                   STA08490
         LA    R11,1(,R11)    SKIP A SPACE                              STA08500
         OUT                                                            STA08510
         SPACE                                                          STA08520
* 'OPTION' - GIVE DOS COMPILER OPTIONS                                  STA08530
OPTION   ITEM  0                                                        STA08540
         L     R2,ABGCOM      GET BGCOM ADDR                            STA08550
         USING BGCOM,R2       ADDRESS IT                                STA08560
         LA    R3,OPTTAB      GET OPTION TABLE ADDR                     STA08570
OPTLP    CLI   0(R3),X'FF'    LAST ENTRY?                               STA08580
         BE    OPTOUT         YES, LEAVE                                STA08590
         IC    R4,0(,R3)      GET BIT MASK                              STA08600
         EX    R4,OPTTM       IS BIT ON?                                STA08610
         BZ    OPTN           NO, BRANCH                                STA08620
         MOVE  1(R3),8        MOVE IN YES VALUE                         STA08630
         LA    R3,17(,R3)     NEXT ENTRY                                STA08640
         B     OPTLP          GO BACK                                   STA08650
OPTN     MOVE  9(R3),8        MOVE IN NO VALUE                          STA08660
         LA    R3,17(,R3)     NEXT ENTRY                                STA08670
         B     OPTLP                                                    STA08680
OPTOUT   TM    JCSW4,OPTDUMP   DUMP?                                    STA08690
         BZ    NODUMP         NO                                        STA08700
         MOVE  =C'DUMP',4      YES                                      STA08710
         BR    R8             RETURN                                    STA08720
NODUMP   MOVE  =C'NODUMP',6   NODUMP                                    STA08730
         OUT                                                            STA08740
OPTTM    TM    JCSW3,*-*       BIT TEST                                 STA08750
OPTDUMP  EQU   X'40'          IN JCSW4                                  STA08760
OPTTAB   DC    X'80',CL8'DECK',CL8'NODECK'                              STA08770
         DC    X'40',CL8'LIST',CL8'NOLIST'                              STA08780
         DC    X'20',CL8'LISTX',CL8'NOLISTX'                            STA08790
         DC    X'10',CL8'SYM',CL8'NOSYM'                                STA08800
         DC    X'08',CL8'XREF',CL8'NOXREF'                              STA08810
         DC    X'04',CL8'ERRS',CL8'NOERRS'                              STA08820
         DC    X'02',CL8'48C',CL8'60C'                                  STA08830
         DC    X'FF'                                                    STA08840
         SPACE                                                          STA08850
* 'DOSPART' - SET DOSPART                                               STA08860
DOSPART  ITEM  0                                                        STA08870
         LH    R0,DOSKPART    GET DOSPART VALUE                         STA08880
         LTR   R0,R0          NULL?                                     STA08890
         BZ    OFF            YES, SAY OFF                              STA08900
         BAL   R7,NUMBER      FORMAT NUMBER                             STA08910
         OUT                                                            STA08920
* 'SUBSET' - YES IF IN CMS SUBSET, NO OTHERWISE                         STA08930
SUBSET   ITEM  0                                                        STA08940
         TM    SUBFLAG,SUBACT SUBSET ACTIVE?                            STA08950
         BO    YES                                                      STA08960
         B     NO                                                       STA08970
         SPACE                                                          STA08980
* 'RDYMSG' - SET RDYMSG                                                 STA08990
RDYMSG   ITEM  0                                                        STA09000
         TM    MSGFLAGS,NORDYTIM   SMSG?                                STA09010
         BO    SMSG           YES, BRANCH                               STA09020
         MOVE  =C'LMSG',4     SAY LMSG                                  STA09030
         BR    R8             RETURN                                    STA09040
SMSG     MOVE  =C'SMSG',4     SAY SMSG                                  STA09050
         OUT                                                            STA09060
         SPACE                                                          STA09070
* 'LDRTBLS' - SET LDRTBLS                                               STA09080
LDRTBLS  ITEM  0                                                        STA09090
         SR    R0,R0          GET HIGH BYTE OF ALDRTBLS                 STA09100
         IC    R0,ALDRTBLS    COUNT OF LOADER TABLE PAGES               STA09110
         BAL   R7,NUMBER      FORMAT IT                                 STA09120
         OUT                                                            STA09130
         SPACE                                                          STA09140
* 'MACLIB' - Q MACLIB                                                   STA09150
MACLIB   ITEM  0                                                        STA09160
         LA    R2,MACLIBL     GET MACLIB LIST ADDR                      STA09170
         B     LIBS           GO TO COMMON ROUTINE                      STA09180
         SPACE                                                          STA09190
* 'TXTLIB' - Q TXTLIB                                                   STA09200
TXTLIB   ITEM  0                                                        STA09210
         LA    R2,TXTLIBS     GET TXTLIB LIST ADDR                      STA09220
         B     LIBS           GO TO COMMON ROUTINE                      STA09230
         SPACE                                                          STA09240
* 'DOSLIB' - Q DOSLIB                                                   STA09250
DOSLIB   ITEM  0                                                        STA09260
         LA    R2,DOSLIBL     GET DOSLIB LIST ADDR                      STA09270
         SPACE                                                          STA09280
* COMMON LIBRARY ROUTINE                                                STA09290
LIBS     BALR  R9,0           GET ADDRESSIBILITY                        STA09300
         USING *,R9                                                     STA09310
LIBLOOP  CLI   0(R2),X'FF'    LAST LIB?                                 STA09320
         BER   R8             YES, RETURN                               STA09330
         MOVE  0(R2),8        MOVE LIBRARY NAME                         STA09340
         LA    R2,8(,R2)      BUMP LIB PTR                              STA09350
         B     LIBLOOP                                                  STA09360
         SPACE                                                          STA09370
* 'FST' - GIVE RECFM, LRECL, AND # RECORDS FOR FILE                     STA09380
FSTINFO  ITEM  3                                                        STA09390
         LA    R3,FSCB        ADDRESS FSCB                              STA09400
         USING FSCBD,R3                                                 STA09410
         CLI   0(R1),X'FF'    FILENAME GIVEN?                           STA09420
         BE    HORRIBLE        NO, BRANCH                               STA09430
         MVC   FSCBFN(8),0(R1)     GET FILENAME                         STA09440
         CLI   8(R1),X'FF'    FILETYPE GIVEN?                           STA09450
         BE    HORRIBLE        NO, BRANCH                               STA09460
         MVC   FSCBFT(8),8(R1)     GET FILETYPE                         STA09470
         CLI   16(R1),X'FF'   FILEMODE GIVEN?                           STA09480
         BE    HORRIBLE       NO, BRANCH                                STA09490
         MVC   FSCBFM(2),16(R1)    GET FILEMODE                         STA09500
         LR    R2,R1          SAVE R1 OVER MACRO CALL                   STA09510
         FSSTATE FSCB=FSCB    FIND FILE                                 STA09520
         LR    R4,R1          SAVE FST PTR                              STA09530
         LR    R1,R2          RESTORE R1                                STA09540
         LTR   R15,R15        FILE FOUND?                               STA09550
         BNZ   UNKN3        NO, BRANCH                                  STA09560
         USING FSTD,R4        ADDRESS FST                               STA09570
         MOVE  FSTRECFM,1     GET RECFM                                 STA09580
         L     R0,FSTLRECL    GET LRECL                                 STA09590
         BAL   R7,NUMBER      FORMAT IT                                 STA09600
         LH    R0,FSTRECCT    GET # RECORDS                             STA09610
         BAL   R7,NUMBER      FORMAT IT                                 STA09620
         DROP  R3                                                       STA09630
         DROP  R4                                                       STA09640
         OUT                                                            STA09650
         SPACE                                                          STA09660
* 'QUALIFY' - GIVE FIRST FILE MATCHING FILE ID WITH STARS               STA09670
QUALIFY  ITEM  3                                                        STA09680
         LA    R3,FSCB        GET FSCB ADDR                             STA09690
         USING FSCBD,R3       TELL ASSEMBLER                            STA09700
         CLI   0(R1),X'FF'    FILENAME?                                 STA09710
         BE    HORRIBLE       NO, ERROR                                 STA09720
         CLI   8(R1),X'FF'    FILETYPE?                                 STA09730
         BE    HORRIBLE                                                 STA09740
         CLI   16(R1),X'FF'   FILEMODE?                                 STA09750
         BE    HORRIBLE                                                 STA09760
         MVC   FSCBFN(8),0(R1)     SAVE NAME                            STA09770
         MVC   FSCBFT(8),8(R1)     SAVE TYPE                            STA09780
         MVC   FSCBFM(2),16(R1)    SAVE MODE                            STA09790
         LR    R2,R1          SAVE R1 ACROSS MACRO                      STA09800
         FSSTATE FSCB=FSCB                                              STA09810
         LR    R4,R1 SAVE FSTD PTR                                      STA09820
         LR    R1,R2          RESTORE R1                                STA09830
         LTR   R15,R15        FILE FOUND?                               STA09840
         BNZ   UNKN3          NO, QUESTION MARK                         STA09850
         USING FSTD,R4                                                  STA09860
         MOVE  FSTFNAME,8     OUTPUT NAME                               STA09870
         MOVE  FSTFTYPE,8     AND TYPE                                  STA09880
         MOVE  FSTFMODE,2     AND MODE                                  STA09890
         DROP  R3                                                       STA09900
         DROP  R4                                                       STA09910
         OUT                                                            STA09920
         SPACE                                                          STA09930
* 'QFILEDEF' - YES IF FILEDEF EXISTS, NO OTHERWISE                      STA09940
QFILEDEF ITEM  1                                                        STA09950
         CLI   0(R1),X'FF'    FILEDEF NAME GIVEN?                       STA09960
         BE    HORRIBLE       NO, BRANCH                                STA09970
         L     R2,FCBFIRST    GET FIRST FCB PTR                         STA09980
         USING FCBSECT,R2     ADDRESS FCB                               STA09990
         LH    R3,FCBNUM      GET NUMBER OF FCBS                        STA10000
         LTR   R3,R3          ANY FILEDEFS IN EFFECT?                   STA10010
         BZ    NO1            SAY NO                                    STA10020
QFDLP    CLC   FCBDD(8),0(R1) FOUND RIGHT FCB?                          STA10030
         BE    YES1           YES, SAY YES                              STA10040
         L     R2,FCBNEXT     GET NEXT FCB PTR                          STA10050
         BCT   R3,QFDLP       TRY AGAIN                                 STA10060
         B     NO1            SAY NO                                    STA10070
         SPACE                                                          STA10080
* 'QDLBL' - YES IF DLBL EXISTS, NO OTHERWISE                            STA10090
QDLBL    ITEM  1                                                        STA10100
         CLI   0(R1),X'FF'    ANY ARG?                                  STA10110
         BE    HORRIBLE       NO, BRANCH                                STA10120
         L     R2,DOSFIRST    GET FIRST DOSCB PTR                       STA10130
         USING DOSSECT,R2     ADDRESS IT                                STA10140
         LH    R3,DOSNUM      GET # OF DOSCBS                           STA10150
         LTR   R3,R3          ANY?                                      STA10160
         BZ    NO1            NO, SAY NO                                STA10170
QDLLP    CLC   DOSDD(8),0(R1) FOUND IT?                                 STA10180
         BE    YES1           YES, SAY YES                              STA10190
         L     R2,DOSNEXT     GET NEXT DOSCB                            STA10200
         BCT   R3,QDLLP       GO BACK                                   STA10210
         B     NO1            SAY NO                                    STA10220
         SPACE                                                          STA10230
* 'DADDR' - FIND DISK ADDR GIVEN MODE                                   STA10240
DADDR    ITEM  1                                                        STA10250
         L     R2,AIADT       GET FIRST ADT PTR                         STA10260
         L     R2,0(,R2)                                                STA10270
         USING ADTSECT,R2     ADDRESS ADT                               STA10280
DADDRLP  LTR   R2,R2          LAST ADT?                                 STA10290
         BZ    UNKN1          YES, UNKNOWN                              STA10300
         CLC   ADTM(1),0(R1)  RIGHT MODE?                               STA10310
         BE    DADDRF         YES, FOUND IT                             STA10320
         L     R2,ADTPTR      GET NEXT ADT                              STA10330
         B     DADDRLP        TRY AGAIN                                 STA10340
DADDRF   L     R2,ADTDTA      GET DEVSECT ADDR                          STA10350
         USING DEVSECT,R2     ADDRESS IT                                STA10360
         LH    R0,DEVADDR     GET DEVICE ADDR                           STA10370
         DROP  R2             FORGET DEVSECT                            STA10380
         BAL   R7,FMTHEX      FORMAT IT                                 STA10390
         MOVE  HEXOUT+5,3     MOVE DEVICE ADDR                          STA10400
         OUT                                                            STA10410
         SPACE                                                          STA10420
* 'DMODE' - FIND DISK MODE GIVEN ADDRESS                                STA10430
DMODE    ITEM  1                                                        STA10440
         BAL   R7,GETHEX      GET DEVICE ADDR                           STA10450
         L     R2,AIADT       GET FIRST ADT                             STA10460
         L     R2,0(,R2)                                                STA10470
         USING ADTSECT,R2     ADDRESS IT                                STA10480
DMODELP  LTR   R2,R2          LAST ADT?                                 STA10490
         BZ    UNKN1          YES, UNKNOWN                              STA10500
         L     R3,ADTDTA      GET DEVSECT ADDR                          STA10510
         USING DEVSECT,R3     ADDRESS IT                                STA10520
         CH    R0,DEVADDR     FOUND IT?                                 STA10530
         BE    DMODEF         YES, BRANCH                               STA10540
         DROP  R3                                                       STA10550
         L     R2,ADTPTR      GET NEXT ADT                              STA10560
         B     DMODELP        TRY AGAIN                                 STA10570
DMODEF   MVC   0(1,R11),ADTM  MOVE IN PRIMARY MODE LETTER               STA10580
         LA    R11,1(,R11)    BUMP OUTPTR                               STA10590
         CLI   ADTMX,C' '     EXTENSION-OF ?                            STA10600
         BE    DMODEOUT       NO, BRANCH                                STA10610
         MVI   0(R11),C'/'    MOVE IN SLASH                             STA10620
         MVC   1(1,R11),ADTMX MOVE IN EXTENSION-OF LETTER               STA10630
         LA    R11,2(,R11)    BUMP OUTPUT                               STA10640
DMODEOUT LA    R11,1(,R11)    BUMP OUTPUT                               STA10650
         OUT                                                            STA10660
         SPACE                                                          STA10670
* 'LABEL' - FIND LABEL GIVEN MODE LETTER                                STA10680
LABEL    ITEM  1                                                        STA10690
         L     R2,AIADT       GET FIRST ADR                             STA10700
         L     R2,0(,R2)                                                STA10710
         USING ADTSECT,R2     ADDRESS IT                                STA10720
LABELLP  LTR   R2,R2          ANY MORE ADTS?                            STA10730
         BZ    UNKN1          NO, UNKNOWN                               STA10740
         CLC   0(1,R1),ADTM   RIGHT MODE?                               STA10750
         BE    LABELF         YES, BRANCH                               STA10760
         L     R2,ADTPTR      GET NEXT ADT                              STA10770
         B     LABELLP        TRY AGAIN                                 STA10780
LABELF   MOVE  ADTID,6        MOVE OUT LABEL                            STA10790
         DROP  R2             FORGET ADT                                STA10800
         OUT                                                            STA10810
* END OF ITEM ROUTINES                                                  STA10820
         EJECT                                                          STA10830
         REGEQU                                                         STA10840
         NUCON                                                          STA10850
         EXTSECT                                                        STA10860
         BGCOM                                                          STA10870
         FSCBD                                                          STA10880
         FSTD                                                           STA10890
         CMSCB                                                          STA10900
         DOSCB                                                          STA10910
         ADT                                                            STA10920
         DEVSECT                                                        STA10930
         COPY SPOOL                                                     STA10940
         COPY  DEVTYPES                                                 STA10950
         COPY  VBLOKS                                                   STA10960
         COPY  VMBLOK                                                   STA10970
CC3      EQU   1                                                        STA10980
* DIAGNOSE CODES                                                        STA10990
DGEXT    EQU   X'0110'                                                  STA11000
DGID     EQU   X'0000'                                                  STA11010
DGTMR    EQU   X'000C'                                                  STA11020
DGDVINFO EQU   X'0024'                                                  STA11030
DGSTOR   EQU   X'0060'                                                  STA11040
DGSPOOL  EQU   X'0014'                                                  STA11050
         END                                                            STA11060
