/* CP diagnose interface routines */

/* Release a page */
/**/    /*ARGSUSED*/
/**/    d_relpage(addr) char *addr; {}
/*/
	entry   d_relpage
d_relpage:
	using   .,r15
	l       r1,0(,sp)
	diag    r1,r1,x'0010'
	br      r14
/*/

/* Issue a CP command and pass back the return code */
/**/    /*ARGSUSED*/
/**/    d_cpcmd(buf, len) char *buf; int len; { return(0); }
/*/
	entry   d_cpcmd
d_cpcmd:
	using   .,r15
	l       r1,0(,sp)       /buf
	l       r0,4(,sp)       /len
	diag    r1,r0,x'0008'
	br      r14     / return code in r0
/*/

/* Get the VM extended ID */
/**/    /*ARGSUSED*/
/**/    d_extid(buf, len) struct extid *buf; {}
/*/
	entry   d_extid
d_extid:
	lm      r0,r1,0(sp)
	diag    r0,r1,x'0000'
	br      r14
/*/

/* Get the VM user ID */
/**/    /*ARGSUSED*/
/**/    d_vmuser(buf) char *buf; {}
/*/
	entry   d_vmuser
d_vmuser:
	using   .,r15
	s       sp,=f'4'        / save r2
	st      r2,0(,sp)
	l       r2,=a(extid)
	la      r0,24
	diag    r2,r0,x'0000'
	l       r1,4(,sp)       / buf
	mvc     0(8,r1),16(r2)  / userid
	l       r2,0(,sp)       / restore r2
	a       sp,=f'4'
	br      r14
.data
extid:  ds      3d
.text
/*/

/* Determine if a disk is read/write or read-only */
/**/    /*ARGSUSED*/
/**/    d_rwdasd(dev) int dev; { return(0); }
/*/
	entry   d_rwdasd
d_rwdasd:
	using   .,r15
        l       r1,0(,sp)
	diag	r1,r0,x'0024'
	n	r0,=a(vdvrdo)
	bz	2f
	sr	r0,r0
	br	r14
2:	la	r0,1
	br	r14
vdvrdo = x'80'
/*/

/* Issue Release 6 Virtual Console Function Diagnose code 8 */
/**/    /*ARGSUSED*/
/**/    d_vcf(cp, op, cl, ol) char *cp, *op; { return(0); }
/*/
	entry   d_vcf
d_vcf:
	using   .,r15
	s       r13,=f'16'
	stm     r2,r5,0(r13)
	lm      r2,r5,16(r13)   / four args
	o       r4,=x'40000000' / flag for getting output back
	diag    r2,r4,x'0008'
	bz      1f
	lcr     r5,r5
1:      lr      r0,r5
	lm      r2,r5,0(r13)
	a       r13,=f'16'
	br      r14
/*/

/* Issue VMCF Diagnose */
/**/    /*ARGSUSED*/
/**/    d_vmcf(p) struct vmcparm *p; { return(0); }
/*/
        entry   d_vmcf
d_vmcf:
        l       r1,0(,sp)
        diag    r1,r0,x'0068'
        br      r14
/*/

/* get tag info for reader */
/**/    /*ARGSUSED*/
/**/    d_gettag(t, id) struct sfblok *t; int id; { return(0); }
/*/
	entry   d_gettag
d_gettag:
	l       r0,4(,sp)       / id at which to start search
	la      r1,x'fff'       / subcode
	l       r15,0(,sp)      / buffer
	diag	r15,r0,x'0014'	
	balr    r0,r0   / return cc
	sll	r0,2	
	srl	r0,30	
	br	r14	
/*/

/* Re-order reader file */
/**/    /*ARGSUSED*/
/**/    d_order(id, addr) {}
/*/
	entry   d_order
d_order:
	l       r15,0(,sp)      / spool file id
	l       r0,4(,sp)       / reader address
	la      r1,x'000C'      / sub-code
	diag    r15,r0,x'0014'
	br      r14
/*/

/* Issue VM accounting interface diagnose (only done once) */
/**/    /*ARGSUSED*/
/**/    d_vmai(aip) struct vmai *aip; {}
/*/
	entry   d_vmai
d_vmai:
	l       r1,0(,sp)
	diag    r1,r1,x'0070'
	br      r14
/*/

/* Following are routines using Logical Device Support Facility */
/* Diagnose code x'007C' */

/* Issue INITIATE subcommand of diagnose x'7c' */
/**/    /*ARGSUSED*/
/**/    d_ldsfi(type, addr) short *addr; { return(0); }
/*/
	entry   d_ldsfi
d_ldsfi:
	using   .,r15
	s       sp,=f'8'
	stm     r2,r3,0(sp)
	l       r1,8(,sp)       / rx+1 <- type
	la      r2,1            / ry <- subcommand
	diag    r0,r2,x'007c'
	l       r2,12(,sp)      / addr
	sth     r0,0(,r2)
	lr      r0,r3
	lm      r2,r3,0(sp)
	a       sp,=f'8'
	br      r14
/*/

/* Issue TERMINATE subcommand of x'7c' */
/**/    /*ARGSUSED*/
/**/    d_ldsft(addr) short addr; {}
/*/
	entry   d_ldsft
d_ldsft:
	using   .,r15
	s       sp,=f'8'
	stm     r2,r3,0(sp)
	l       r0,8(,sp)
	la      r2,4
	diag    r0,r2,x'007c'
	lm      r2,r3,0(sp)
	a       sp,=f'8'
	br      r14
/*/

/* Issue ACCEPT subcommand of x'7c' */
/**/    /*ARGSUSED*/
/**/    d_ldsfa(addr, buf, len, rlen) char *buf; int *rlen; { return(0); }
/*/
	entry   d_ldsfa
d_ldsfa:
	using   .,r15
	s       sp,=f'8'
	stm     r2,r3,0(sp)
	lm      r0,r1,8(sp)
	la      r2,2
	l       r3,16(,sp)
	diag    r0,r2,x'007c'
	balr    r0,0    / get cc in byte 2 of r0
	sll     r0,2
	srl     r0,30
	sll     r0,8
	or      r0,r3   / or in return code
	l       r1,20(,sp)
	st      r2,0(,r1)
	lm      r2,r3,0(sp)
	a       sp,=f'8'
	br      r14
/*/

/* Issue PRESENT subcommand of x'7c' */
/**/    /*ARGSUSED*/
/**/    d_ldsfp(addr, buf, len) char *buf; { return(0); }
/*/
	entry   d_ldsfp
d_ldsfp:
	using   .,r15
	s       sp,=f'8'
	stm     r2,r3,0(sp)
	lm      r0,r1,8(sp)
	la      r2,3
	l       r3,16(,sp)
	diag    r0,r2,x'007c'
	balr    r0,0    / get cc in byte 2 of r0
	sll     r0,2
	srl     r0,30
	sll     r0,8
	or      r0,r3   / or in return code
	lm      r2,r3,0(sp)
	a       sp,=f'8'
	br      r14
/*/

/*/
