#include "../h/param.h"

#define CATCH	01
#define IGNORE	02
#define CORE	04
#define NORESET	010

int sigact[NSIG+1] = {
	0,			/*  0 - unused */
	CATCH+IGNORE,		/*  1 - hangup */
	CATCH+IGNORE,		/*  2 - interrupt */
	CATCH+IGNORE+CORE,	/*  3 - quit */
	CATCH+CORE+NORESET,	/*  4 - operation exception */
	CATCH+IGNORE+NORESET,	/*  5 - monitor call */
	CATCH+IGNORE,		/*  6 - program event recording */
	CATCH+CORE,		/*  7 - page translation exception */
	CATCH+IGNORE+CORE,	/*  8 - floating divide exception */
	0,			/*  9 - kill */
	CATCH+CORE,		/* 10 - specification exception */
	CATCH+CORE,		/* 11 - segmentation exception */
	CATCH+IGNORE+CORE,	/* 12 - bad system call */
	CATCH+IGNORE,		/* 13 - end of pipe */
	CATCH+IGNORE,		/* 14 - alarm clock */
	CATCH+IGNORE,           /* 15 - soft kill */
	CATCH+IGNORE+CORE,	/* 16 - privileged operation exception */
	CATCH+IGNORE+CORE,	/* 17 - execute exception */
	CATCH+IGNORE+CORE,	/* 18 - protection exception */
	CATCH+IGNORE+CORE,	/* 19 - data exception */
	CATCH+IGNORE+CORE,	/* 20 - fixed point overflow */
	CATCH+IGNORE+CORE,	/* 21 - fixed point divide */
	CATCH+IGNORE+CORE,	/* 22 - decimal overflow */
	CATCH+IGNORE+CORE,	/* 23 - decimal divide */
	CATCH+IGNORE+CORE,	/* 24 - exponent overflow */
	CATCH+IGNORE+CORE,	/* 25 - exponent underflow */
	CATCH+IGNORE+CORE,	/* 26 - significance exception */
	CATCH,			/* 27 - out of disk space */
	CATCH,			/* 28 - no file structures */
	0,                      /* 29 - program initiation */
	0,                      /* 30 - svc interrupt */
	0,                      /* 31 - time slice end */
};
