/*
 * swap - swaps head and tail of standard input
 *        assumes input consists of a head, a separator, and a tail
 *        the separator is a single character, bell (\007) by default
 *        if an argument is passed to swap,
 *              its first character replaces bell as the separator
 *        the head and/or tail may be empty
 *        standard output becomes tail followed by head,
 *              with the separator removed
 *        if the file contains multiple separators, only the first is used
 *        if no separator is found, file is passed through unchanged
 */

#include <stdio.h>
#include <signal.h>

char separator = '\007';        /* default separator is BELL signal */
char inbuf [BUFSIZ];
char outbuf[BUFSIZ];
char tmpbuf[BUFSIZ];
char *tmpname;                  /* name of temporary file */

main(argc, argv)
int argc;
char *argv[];
{
	FILE *tmp;              /* temporary file holding head */
	int c;                  /* holds character */
	char *mktemp();
	extern int intr();

	if (signal(SIGHUP,  SIG_IGN) == 0)
	        signal(SIGHUP,  intr);
	if (signal(SIGINTR, SIG_IGN) == 0)
	        signal(SIGINTR, intr);
	if (signal(SIGQUIT, SIG_IGN) == 0)
	        signal(SIGQUIT, intr);
	signal(SIGTERM, intr);
	signal(SIGNOSPC, intr);

	/* create and open temporary file */
	tmpname = mktemp("/tmp/swap.XXXXXX");
	tmp = fdopen(creat(tmpname, 0600), "w");
	if (tmp == NULL) {
		fprintf(stderr, "swap: can't open temporary file\n");
		exit(1);
	}

	setbuf(stdin,   inbuf);
	setbuf(stdout, outbuf);
	setbuf(tmp,    tmpbuf);

	/* redefine separator to first char of first arg, if present */
	if (argc > 1) {
		separator = *argv[1];
	}

	/* move head to temporary file */
	while (((c=getchar()) != separator) && (c != EOF)) {
	        putc(c, tmp);
	}

	/* move tail to standard output */
	while ((c=getchar()) != EOF)
	        putchar(c);

	/* reopen temporary file for reading */
	freopen(tmpname, "r", tmp);
	if (tmp == NULL) {
		fprintf(stderr, "swap: can't reopen temporary file\n");
		exit(1);
	}

	/* move head from temporary file to standard output */
	while ((c=getc(tmp)) != EOF)
	        putchar(c);

	/* remove temporary file */
	fclose(tmp);
	unlink(tmpname);
}

intr(sig)
int sig;
{
	if (sig == SIGNOSPC) {
		fprintf(stderr, "swap: disk full error, try again\n");
	}
	unlink(tmpname);
	_exit(1);
}
